package com.biz.crm.tpm.business.platform.customer.sdk.service;


import com.biz.crm.tpm.business.platform.customer.sdk.dto.PlatformCustomerDto;

import java.util.List;

/**
 * 平台客户(PlatformCustomer)表服务接口
 *
 * @author yaoyongming
 * @since 2022-12-05 15:44:08
 */
public interface PlatformCustomerService {

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    PlatformCustomerDto findById(String id);

    /**
     * 新增数据
     *
     * @param platformCustomer 实体对象
     * @return 新增结果
     */
    PlatformCustomerDto create(PlatformCustomerDto platformCustomer);

    /**
     * 修改新据
     *
     * @param platformCustomer 实体对象
     * @return 修改结果
     */
    PlatformCustomerDto update(PlatformCustomerDto platformCustomer);

    /**
     * 批量启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 批量禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 批量导入
     *
     * @param platformCustomerDtoList
     */
    void importSave(List<PlatformCustomerDto> platformCustomerDtoList);

    /**
     * 创建验证
     *
     * @param platformCustomer
     */
    void createValidate(PlatformCustomerDto platformCustomer);

    /**
     * 查询验重
     *
     * @param platformCustomer
     */
    void validateRepeatabilityOnCreate(PlatformCustomerDto platformCustomer);
}

