package com.biz.crm.tpm.business.platform.customer.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Getter;
import lombok.Setter;

/**
 * @author: yaoyongming
 * @date: 2022/12/12 17:01
 */
@Getter
@Setter
@CrmExcelExport
public class PlatformCustomerExportsVo extends CrmExcelVo {

    /**
     * 平台编码
     */
    @CrmExcelColumn(value = "平台编码", order = 0)
    private String platformCode;

    /**
     * 平台名称
     */
    @CrmExcelColumn(value = "平台名称", order = 1)
    private String platformName;

    /**
     * 店铺名称
     */
    @CrmExcelColumn(value = "店铺名称", order = 2)
    private String shop;

    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码", order = 3)
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn(value = "客户名称", order = 4)
    private String customerName;

    /**
     * appKey
     */
    @CrmExcelColumn(value = "appKey", order = 5)
    private String appKey;

    /**
     * appSecret
     */
    @CrmExcelColumn(value = "appSecret", order = 6)
    private String appSecret;

    /**
     * 授权url
     */
    @CrmExcelColumn(value = "授权url", order = 7)
    private String url;

    /**
     * 备注
     */
    @CrmExcelColumn(value = "备注", order = 8)
    private String remark;

    /**
     * 创建人名称
     */
    @CrmExcelColumn("创建人名称")
    private String createName;

    /**
     * 创建时间
     */
    @CrmExcelColumn("创建时间")
    private String createTime;

    /**
     * 数据业务状态（启用状态）
     */
    @CrmExcelColumn("数据业务状态（启用状态）")
    private String enableStatus;
}
