package com.biz.crm.tpm.business.promotion.policy.template.config.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @ClassName TpmPromotionPolicyTemplateConfigDetailDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/1
 */
@Data
@ApiModel(value = "促销政策模板配置规则明细数据传输")
public class TpmPromotionPolicyTemplateConfigDetailDto extends TenantFlagOpDto {

    /**
     * 促销政策模板编码
     */
    @ApiModelProperty(value = "促销政策模板编码", notes = "")
    private String promotionPolicyTemplateCode;

    /**
     * 客户选择的促销政策
     */
    @ApiModelProperty(value = "条件类型", notes = "")
    private String typeCode;

    /**
     * 客户选择的促销政策
     */
    @ApiModelProperty(value = "判断条件,数量/金额", notes = "")
    private BigDecimal promotionCondition;

    /**
     * 客户选择的促销政策
     */
    @ApiModelProperty(value = "计算结果，数量/金额", notes = "")
    private BigDecimal promotionResult;

    /**
     * 客户选择的促销政策
     */
    @ApiModelProperty(value = "计算规则编码，多个逗号隔开", notes = "")
    private String calculateRule;

    public boolean validate(){
        return StringUtils.isNotEmpty(typeCode) && promotionCondition != null
                && promotionResult != null && StringUtils.isNotEmpty(calculateRule);
    }

}
