package com.biz.crm.tpm.business.promotion.policy.template.config.sdk.service;

import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.dto.TpmPromotionPolicyTemplateConfigDto;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.vo.TpmPromotionPolicyTemplateConfigRespVo;
import org.springframework.data.domain.Pageable;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * 促销政策模板配置接口类
 * @author kingj
 * @date 2022/11/2 14:53
 * @return
 */
public interface TpmPromotionPolicyTemplateConfigService {

    /**
     * 根据条件查询促销政策模板配置列表
     * @param pageable
     * @param dto
     * @return
     */
    Page<TpmPromotionPolicyTemplateConfigRespVo> findByConditions(Pageable pageable, TpmPromotionPolicyTemplateConfigDto dto);

    /**
     *根据id查询促销政策模板配置详情
     * @param id
     * @return
     */
    TpmPromotionPolicyTemplateConfigRespVo findById(String id);

    /**
     *创建新的促销政策模板配置
     * @param dto
     * @return
     */
    TpmPromotionPolicyTemplateConfigRespVo create(TpmPromotionPolicyTemplateConfigDto dto);

    /**
     *更新已有促销政策模板配置
     * @param dto
     * @return
     */
    TpmPromotionPolicyTemplateConfigRespVo update(TpmPromotionPolicyTemplateConfigDto dto);

    /**
     * 根据id逻辑删除促销政策模板
     * @param ids
     */
    void delete(List<String> ids);

    /**
     * 根据id启用促销政策模板配置
     * @param ids
     */
    void enable(List<String> ids);

    /**
     * 根据id禁用促销政策模板配置
     * @param ids
     */
    void disable(List<String> ids);


    TpmPromotionPolicyTemplateConfigRespVo findByCode(String code);
}
