package com.biz.crm.tpm.business.sales.plan.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.sales.plan.feign.feign.internal.SalesPlanFeignImpl;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年12月20日 9:37
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = SalesPlanFeignImpl.class)
public interface SalesPlanFeign {

    /**
     * 条件查询
     *
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo>>
     * @author huojia
     * @date 2022/12/20 9:47
     **/
    @PostMapping("/v1/sales/plan/conditions")
    Result<List<SalesPlanVo>> findByConditions(@RequestBody SalesPlanDto dto);

    /**
     * 条件查询
     *
     * @param salesPlanDto
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo>>
     * @author huojia
     * @date 2022/12/20 9:48
     **/
    @PostMapping("/v1/sales/plan/listByConditions")
    Result<List<SalesPlanVo>> listByConditions(@RequestBody SalesPlanDto salesPlanDto);

    /**
     * 根据维度统计回复量
     *
     * @param dto 查询实体
     * @return 统计数据map
     */
    @ApiOperation(value = "根据维度统计回复量")
    @PostMapping("/v1/sales/plan/summaryRecoveryAmount")
     Result<Map<String, BigDecimal>> summaryRecoveryAmount(@RequestBody SalesPlanSummaryDto dto);

}
