package com.biz.crm.tpm.business.sales.plan.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.sales.plan.feign.feign.SalesPlanFeign;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年12月20日 9:38
 */
@Slf4j
@Component
public class SalesPlanFeignImpl implements FallbackFactory<SalesPlanFeign> {
    @Override
    public SalesPlanFeign create(Throwable cause) {
        return new SalesPlanFeign() {

            @Override
            public Result<List<SalesPlanVo>> findByConditions(SalesPlanDto dto) {
                throw new UnsupportedOperationException("条件查询销售计划熔断！");
            }

            @Override
            public Result<List<SalesPlanVo>> listByConditions(SalesPlanDto salesPlanDto) {
                throw new UnsupportedOperationException("条件查询销售计划熔断！");
            }

            @Override
            public Result<Map<String, BigDecimal>> summaryRecoveryAmount(SalesPlanSummaryDto dto) {
                throw new UnsupportedOperationException("根据维度统计回复量熔断！");
            }
        };
    }
}
