package com.biz.crm.tpm.business.sales.plan.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.sales.plan.feign.feign.SalesPlanFeign;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanConfirmDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanReCalPlanAndReplyDto;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanSummaryDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SubSaleMonitorVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年12月20日 9:37
 */
@Slf4j
@Service
public class SalesPlanServiceImpl implements SalesPlanService {

    @Resource
    private SalesPlanFeign salesPlanFeign;

    @Override
    public Page<SalesPlanVo> findByConditions(Pageable pageable, SalesPlanDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesPlanVo> findByConditions(SalesPlanDto dto) {
        Result<List<SalesPlanVo>> result = salesPlanFeign.findByConditions(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public SalesPlanVo findById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SalesPlanVo update(SalesPlanDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SalesPlanVo create(SalesPlanDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void importSave(List<SalesPlanDto> importList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesPlanVo> listByConditions(SalesPlanDto salesPlanDto) {
        Result<List<SalesPlanVo>> result = salesPlanFeign.listByConditions(salesPlanDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Map<String, BigDecimal> summaryRecoveryAmount(SalesPlanSummaryDto dto) {
        Result<Map<String, BigDecimal>> result = salesPlanFeign.summaryRecoveryAmount(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public void manualCalPlanAndReply(SalesPlanReCalPlanAndReplyDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesPlanVo> findSalesPlanSumVo(SalesPlanDto queryDto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void confirmData(SalesPlanConfirmDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesPlanDto> convertOrg(List<SalesPlanDto> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<SalesPlanVo> findForSalesVolumeMonitoring(Pageable pageable, SalesPlanDto dto2) {
        throw new UnsupportedOperationException();
    }

    /**
     * 分子销量监控
     *
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public Page<SubSaleMonitorVo> subSaleMonitor(Pageable pageable, SalesPlanDto dto) {
        throw new UnsupportedOperationException();
    }

    /**
     * 销管资金池预算项目计算回复量
     *
     * @param dto
     * @return
     */
    @Override
    public List<SalesPlanVo> sumReplayReimburse(SalesPlanDto dto) {
        throw new UnsupportedOperationException();
    }

    /**
     * 其他预留项目预算项目计算回复量
     *
     * @param dto
     * @return
     */
    @Override
    public List<SalesPlanVo> sumReplayRestore(SalesPlanDto dto) {
        throw new UnsupportedOperationException();
    }

    /**
     * 其他预留项目预算项目计算计划量
     *
     * @param dto
     * @return
     */
    @Override
    public List<SalesPlanVo> sumReplayPlan(SalesPlanDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal findSaleAmount(SalesPlanDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesPlanVo> findForSaleAndFeeMonitoring(List<SalesPlanDto> dtos) {
        return null;
    }
}
