package com.biz.crm.tpm.business.sales.volume.channel.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author heding
 * @create 2022/11/26 17:21:44
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "销量渠道管理dto")
public class TpmSalesVolumeChannelDto extends TenantFlagOpDto {

    /**
     * 平台（数据字典mdm_estore_platform）
     */
    @ApiModelProperty(name = "平台（数据字典mdm_estore_platform）", notes = "平台（数据字典mdm_estore_platform）")
    private String platformName;
    /**
     * 销量渠道
     */
    @ApiModelProperty(name = "销量渠道", notes = "销量渠道")
    private String salesVolumeChannel;
    /**
     * 销量渠道完整匹配
     */
    @ApiModelProperty(name = "销量渠道完整匹配", notes = "销量渠道完整匹配")
    private String salesVolumeChannelEq;
    /**
     * 是否可以统计销售额（1是0否）
     */
    @ApiModelProperty(name = "是否可以统计销售额（1是0否）", notes = "是否可以统计销售额（1是0否）")
    private String statisticsOfSales;
    /**
     * 平台编码
     */
    @ApiModelProperty(name = "平台编码", notes = "平台编码")
    private String platformCode;
    /**
     * 销量渠道编码
     */
    @ApiModelProperty(name = "销量渠道编码", notes = "销量渠道编码")
    private String salesVolumeChannelCode;
    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;
}