package com.biz.crm.tpm.business.sales.volume.channel.sdk.event.log;

import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.log.SalesVolumeChannelLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author ：heding
 * @date ：Created in 2022/11/26 15:48:58
 * @description：销量渠道管理日志接口
 */
public interface SalesVolumeChannelEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(SalesVolumeChannelLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(SalesVolumeChannelLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(SalesVolumeChannelLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(SalesVolumeChannelLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(SalesVolumeChannelLogEventDto eventDto);
}
