package com.biz.crm.tpm.business.sales.volume.channel.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.TpmDataListDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.dto.TpmSalesVolumeChannelDto;
import com.biz.crm.tpm.business.sales.volume.channel.sdk.vo.TpmSalesVolumeChannelVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 销量渠道管理(TpmSalesVolumeChannel)表服务接口
 *
 * @author heding
 * @create 2022/11/26 13:29:44
 */
public interface TpmSalesVolumeChannelService {
    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmSalesVolumeChannelVo findById(String id);

    /**
     * 删除数据
     *
     * @param idList 主键集合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    void create(TpmDataListDto dto);

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询条件实体
     * @return 所有数据
     */
    Page<TpmSalesVolumeChannelVo> findByConditions(Pageable pageable, TpmSalesVolumeChannelDto dto);

    /**
     * 编辑数据
     *
     * @param dto 实体对象
     * @return 编辑结果
     */
    void update(TpmSalesVolumeChannelDto dto);

    /**
     * 启用
     *
     * @param idList 主键集合
     * @return 启用结果
     */
    void enable(List<String> idList);

    /**
     * 禁用
     *
     * @param idList 主键集合
     * @return 禁用结果
     */
    void disable(List<String> idList);
    /**
     * 批量新增
     *
     * @param importList 对象集合
     * @return 新增结果
     */
    void importSave(List<TpmSalesVolumeChannelDto> importList);

    /**
     * 渠道编码集合查询
     *
     * @param codeList
     * @return
     */
    List<TpmSalesVolumeChannelVo> findByCodeList(List<String> codeList);
}
