package com.biz.crm.tpm.business.sales.volume.channel.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
 * @author heding
 * @create 2022/11/26 13:21:44
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "TpmSalesVolumeChannelVo", description = "TPM-销量渠道管理")
public class TpmSalesVolumeChannelVo extends TenantFlagOpVo {


    /**
     * 平台（数据字典mdm_estore_platform）
     */
    @ApiModelProperty(name = "平台（数据字典mdm_estore_platform）", notes = "平台（数据字典mdm_estore_platform）")
    private String platformName;
    /**
     * 销量渠道
     */
    @ApiModelProperty(name = "销量渠道", notes = "销量渠道")
    private String salesVolumeChannel;
    /**
     * 是否可以统计销售额（1是0否）
     */
    @ApiModelProperty(name = "是否可以统计销售额（1是0否）", notes = "是否可以统计销售额（1是0否）")
    private String statisticsOfSales;
    /**
     * 平台编码
     */
    @ApiModelProperty(name = "平台编码", notes = "平台编码")
    private String platformCode;
    /**
     * 销量渠道编码
     */
    @ApiModelProperty(name = "销量渠道编码", notes = "销量渠道编码")
    private String salesVolumeChannelCode;
}