package com.biz.crm.tpm.business.settlement.manage.local.controller;


import com.biz.crm.tpm.business.settlement.manage.local.entity.TpmSettlementManage;
import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.settlement.manage.sdk.vo.TpmSettlementManageVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import javax.annotation.Resource;
import java.util.List;

/**
 * TPM-结算单管理(TpmSettlementManage)表相关的http接口
 *
 * @author duyiran
 * @since 2022-11-01 16:38:47
 */
@RestController
@RequestMapping("/v1/settlement/manage")
@Slf4j
@Api(tags = "TPM-结算单管理")
public class TpmSettlementManageController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private TpmSettlementManageService tpmSettlementManageService;

    /**
     * 分页查询所有数据
     *
     * @param pageable            分页对象
     * @param dto dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmSettlementManageVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "tpmSettlementManage", value = "TPM-结算单管理") TpmSettlementManageDto dto) {
        try {
            Page<TpmSettlementManageVo> page = this.tpmSettlementManageService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
        try {
            this.tpmSettlementManageService.delete(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
