package com.biz.crm.tpm.business.settlement.manage.local.customer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.settlement.manage.sdk.constant.SettlementManageConstant;
import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author duyiran
 * @create 2022-11-09 17:41
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = RocketMqUtil.ORDER + "${rocketmq.topic}" + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = SettlementManageConstant.SETTLEMENT_MANAGE_CREATE_LOG_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMqUtil.ORDER + SettlementManageConstant.SETTLEMENT_MANAGE_CREATE_LOG_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY)
public class TpmSettlementManageConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    TpmSettlementManageService tpmSettlementManageService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("=====>    结算单管理新增日志消息接收成功    <=====");
        List<TpmSettlementManageDto> dtoList = JSON.parseArray(message.getMsgBody(), TpmSettlementManageDto.class);
        tpmSettlementManageService.logCreate(dtoList);
        return "消费成功";
    }
}
