package com.biz.crm.tpm.business.settlement.manage.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 结算单管理 实体
 *
 * @author duyiran
 * @create 2022-11-01 14:18
 */
@Data
@TableName("tpm_settlement_manage")
@Entity(name = "tpm_settlement_manage")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmSettlementManage", description = "TPM-结算单管理")
@org.hibernate.annotations.Table(appliesTo = "tpm_settlement_manage", comment = "TPM-结算单管理")
@Table(name = "tpm_settlement_manage", indexes =
        {
                @Index(name = "tpm_settlement_manage_index1", columnList = "tenant_code, code", unique = false),
                @Index(name = "tpm_settlement_manage_index2", columnList = "verify_id", unique = false),
                @Index(name = "tpm_settlement_manage_index3", columnList = "customer_code, year_month_ly, activity_form_code, product_code", unique = false),
                @Index(name = "tpm_settlement_manage_index4", columnList = "customer_code, year_month_ly, activity_form_code", unique = false)
        })
public class TpmSettlementManage extends TenantFlagOpEntity {

    @ApiModelProperty(name = "单据来源", notes = "")
    @Column(name = "source_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单据来源'")
    private String sourceCode;

    @ApiModelProperty(name = "单据编码", notes = "")
    @Column(name = "code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单据编码'")
    private String code;

    @ApiModelProperty(name = "单据子编号", notes = "")
    @Column(name = "sub_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单据子编号'")
    private String subCode;

    @ApiModelProperty(name = "单据类型", notes = "")
    @Column(name = "order_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单据类型'")
    private String orderType;

    @ApiModelProperty(name = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "业务发生时间", notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "business_time" , nullable = true, length = 20, columnDefinition = "datetime COMMENT '业务发生时间'")
    private Date businessTime;

    @ApiModelProperty(name = "平台产品编码", notes = "")
    @Column(name = "platform_product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品编码'")
    private String platformProductCode;

    @ApiModelProperty(name = "平台产品名称", notes = "")
    @Column(name = "platform_product_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '商品编码'")
    private String platformProductName;

    @ApiModelProperty(name = "商品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty(name = "商品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty(name = "商品含税单价（元）", notes = "")
    @Column(name = "price", nullable = true, length = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT '商品含税单价（元）'")
    private BigDecimal price;

    @ApiModelProperty("商品数量（箱）")
    @Column(name = "quantity", length = 10, nullable = true, columnDefinition = "int(10) COMMENT '商品数量（箱）'")
    private Integer quantity;

    @ApiModelProperty(name = "费用项", notes = "")
    @Column(name = "expense_item", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '费用项'")
    private String expenseItem;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "费用金额（元）", notes = "")
    @Column(name = "amount", nullable = true, length = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '费用金额（元）'")
    private BigDecimal amount;

    @ApiModelProperty(name = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "销售机构", notes = "销售机构")
    @Column(name = "sales_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售机构'")
    private String salesOrgName;

    @ApiModelProperty(name = "渠道编码", notes = "渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty(name = "渠道", notes = "渠道")
    @Column(name = "channel_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '渠道'")
    private String channelName;

    @ApiModelProperty(name = "业态", notes = "业态编码")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty(name = "mdg编码", notes = "mdg编码")
    @Column(name = "mdg_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT 'mdg编码'")
    private String mdgCode;

    @ApiModelProperty(name = "年月", notes = "年月")
    @Column(name = "year_month_ly", length = 7, columnDefinition = "VARCHAR(7) COMMENT '年月'")
    private String yearMonthStr;

    @ApiModelProperty(name = "平台唯一Id", notes = "平台唯一Id")
    @Column(name = "platform_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '平台唯一Id'")
    private String platformId;

    /**
     * 保存时使用 后序调接口保存时需要参照现有导入功能去赋值
     * 保存时要保证该id唯一 数据库就不做强制校验了，注意一下就行
     */
    @ApiModelProperty(name = "验重id", notes = "验重id")
    @Column(name = "verify_id", length = 256, columnDefinition = "VARCHAR(256) COMMENT '验重id'")
    private String verifyId;

}
