package com.biz.crm.tpm.business.settlement.manage.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.tpm.business.settlement.manage.local.entity.TpmSettlementManage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.vo.TpmSettlementManageVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

/**
 * TPM-结算单管理(TpmSettlementManage)表mybatis访问层
 *
 * @author duyiran
 * @since 2022-11-01 16:38:49
 */
public interface TpmSettlementManageMapper extends BaseMapper<TpmSettlementManage> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  dto
     * @return 所有数据
     */
    Page<TpmSettlementManageVo> findByConditions(@Param("page") Page<TpmSettlementManageVo> page, @Param("dto") TpmSettlementManageDto dto);

    /**
     * 大批量保存
     *
     * @param entities   数据
     * @param baseEntity 用来初始化所需值
     */
    void bulkPreservation(@Param("entities") List<TpmSettlementManage> entities, @Param("baseEntity") TenantFlagOpEntity baseEntity);

    /**
     * 客户+产品+时间段/客户+时间段,统计数量
     *
     * @param dto dto对象
     * @return
     */
    BigDecimal getAmount(@Param("dto") TpmSettlementManageDto dto);

    /**
     * 客户+产品+时间段/客户+时间段,统计数量
     *
     * @param dto dto对象
     * @return
     */
    Integer getQuantity(@Param("dto") TpmSettlementManageDto dto);

    /**
     * 平台结算管理相关关键指标查询费用，汇总，客户+产品+时间段/客户+时间段
     * @param dto
     * @return
     */
    BigDecimal getAmountByActivityFormCode(@Param("dto") TpmSettlementManageDto dto);

    List<String> repeatValidateBatch(@Param("keyList")List<String> keyList);
}

