package com.biz.crm.tpm.business.settlement.manage.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 数据视图注册器
 * 基于nebula的数据视图提供列表查询功能
 *
 * @author duyiran
 * @create 2022-11-07 20:01
 */
@Component
@Slf4j
public class TpmSettlementManageRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_settlement_manage_data_view";
    }

    @Override
    public String desc() {
        return "TPM-结算单管理";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_settlement_manage t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

}
