package com.biz.crm.tpm.business.settlement.manage.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.settlement.manage.local.entity.TpmSettlementManage;
import com.biz.crm.tpm.business.settlement.manage.local.mapper.TpmSettlementManageMapper;
import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.vo.TpmSettlementManageVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;


/**
 * TPM-结算单管理(TpmSettlementManage)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-01 16:38:48
 */
@Component
public class TpmSettlementManageRepository extends ServiceImpl<TpmSettlementManageMapper, TpmSettlementManage> {

    @Autowired(required = false)
    private TpmSettlementManageMapper tpmSettlementManageMapper;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      dto对象
     * @return
     */
    public Page<TpmSettlementManageVo> findByConditions(Pageable pageable, TpmSettlementManageDto dto) {
        Page<TpmSettlementManageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmSettlementManageVo> pageList = this.tpmSettlementManageMapper.findByConditions(page, dto);
        return pageList;
    }

    /**
     * 大批量保存
     *
     * @param entities entities
     */
    public void bulkPreservation(List<TpmSettlementManage> entities) {
        //设置基础信息
        TenantFlagOpEntity baseEntity = new TenantFlagOpEntity();
        AbstractCrmUserIdentity loginDetails = loginUserService.getAbstractLoginUser();
        Date date = new Date();
        baseEntity.setId(UUID.randomUUID().toString().replace("-", ""));
        baseEntity.setCreateAccount(loginDetails.getUsername());
        baseEntity.setCreateName(loginDetails.getRealName());
        baseEntity.setModifyAccount(loginDetails.getUsername());
        baseEntity.setModifyName(loginDetails.getRealName());
        baseEntity.setCreateTime(date);
        baseEntity.setModifyTime(date);
        baseEntity.setTenantCode(loginDetails.getTenantCode());
        baseEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        baseEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entities.forEach(entity -> entity.setId(UUID.randomUUID().toString().replace("-", "")));

        //保存
        this.tpmSettlementManageMapper.bulkPreservation(entities, baseEntity);
    }

    /**
     * 客户+产品+时间段/客户+时间段,统计数量
     *
     * @param dto dto对象
     * @return
     */
    public BigDecimal getAmount(TpmSettlementManageDto dto) {
        return this.tpmSettlementManageMapper.getAmount(dto);
    }


    public Integer getQuantity(TpmSettlementManageDto dto) {
        return this.tpmSettlementManageMapper.getQuantity(dto);
    }

    /**
     * 平台结算管理相关关键指标查询费用，汇总，客户+产品+时间段/客户+时间段
     *
     * @param dto
     * @return
     */
    public BigDecimal getAmountByActivityFormCode(TpmSettlementManageDto dto) {
        return this.tpmSettlementManageMapper.getAmountByActivityFormCode(dto);
    }

    public Set<String> repeatValidateBatch(List<String> keyList) {
        Set<String> resultSet = Sets.newHashSet();
        if (CollectionUtils.isEmpty(keyList)) {
            return resultSet;
        }
        //给500试试 测下速度
        List<List<String>> keyListGroup = Lists.partition(keyList, 500);
        keyListGroup.forEach(keySubList -> resultSet.addAll(this.tpmSettlementManageMapper.repeatValidateBatch(keySubList)));
        return resultSet;
    }

}

