/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.settlement.manage.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.settlement.manage.local.entity.TpmSettlementManage;
import com.biz.crm.tpm.business.settlement.manage.local.mapper.TpmSettlementManageMapper;
import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.vo.TpmSettlementManageVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TpmSettlementManageRepository
extends ServiceImpl<TpmSettlementManageMapper, TpmSettlementManage> {
    @Autowired(required=false)
    private TpmSettlementManageMapper tpmSettlementManageMapper;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<TpmSettlementManageVo> findByConditions(Pageable pageable, TpmSettlementManageDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<TpmSettlementManageVo> pageList = this.tpmSettlementManageMapper.findByConditions((Page<TpmSettlementManageVo>)page, dto);
        return pageList;
    }

    public void bulkPreservation(List<TpmSettlementManage> entities) {
        TenantFlagOpEntity baseEntity = new TenantFlagOpEntity();
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        Date date = new Date();
        baseEntity.setId(UUID.randomUUID().toString().replace("-", ""));
        baseEntity.setCreateAccount(loginDetails.getUsername());
        baseEntity.setCreateName(loginDetails.getRealName());
        baseEntity.setModifyAccount(loginDetails.getUsername());
        baseEntity.setModifyName(loginDetails.getRealName());
        baseEntity.setCreateTime(date);
        baseEntity.setModifyTime(date);
        baseEntity.setTenantCode(loginDetails.getTenantCode());
        baseEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        baseEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entities.forEach(entity -> entity.setId(UUID.randomUUID().toString().replace("-", "")));
        this.tpmSettlementManageMapper.bulkPreservation(entities, baseEntity);
    }

    public BigDecimal getAmount(TpmSettlementManageDto dto) {
        return this.tpmSettlementManageMapper.getAmount(dto);
    }

    public Integer getQuantity(TpmSettlementManageDto dto) {
        return this.tpmSettlementManageMapper.getQuantity(dto);
    }

    public BigDecimal getAmountByActivityFormCode(TpmSettlementManageDto dto) {
        return this.tpmSettlementManageMapper.getAmountByActivityFormCode(dto);
    }

    public Set<String> repeatValidateBatch(List<String> keyList) {
        HashSet resultSet = Sets.newHashSet();
        if (CollectionUtils.isEmpty(keyList)) {
            return resultSet;
        }
        List keyListGroup = Lists.partition(keyList, (int)500);
        keyListGroup.forEach(keySubList -> resultSet.addAll(this.tpmSettlementManageMapper.repeatValidateBatch((List<String>)keySubList)));
        return resultSet;
    }
}

