/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.settlement.manage.local.service.imports;

import com.aliyun.openservices.shade.com.google.common.collect.Sets;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.platform.expense.form.sdk.dto.PlatformExpenseFormDto;
import com.biz.crm.tpm.business.platform.expense.form.sdk.service.PlatformExpenseFormService;
import com.biz.crm.tpm.business.platform.product.relation.sdk.dto.PlatformProductRelationDto;
import com.biz.crm.tpm.business.platform.product.relation.sdk.service.PlatformProductRelationService;
import com.biz.crm.tpm.business.platform.product.relation.sdk.vo.PlatformProductRelationVo;
import com.biz.crm.tpm.business.settlement.manage.local.entity.TpmSettlementManage;
import com.biz.crm.tpm.business.settlement.manage.local.repository.TpmSettlementManageRepository;
import com.biz.crm.tpm.business.settlement.manage.sdk.enums.TpmSettlementSourceEnum;
import com.biz.crm.tpm.business.settlement.manage.sdk.vo.imports.TmallSettlementImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TmallSettlementImportsProcess
implements ImportProcess<TmallSettlementImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(TmallSettlementImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private PlatformExpenseFormService platformExpenseFormService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    PlatformProductRelationService platformProductRelationService;
    @Autowired(required=false)
    private TpmSettlementManageRepository tpmSettlementManageRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public Integer getBatchCount() {
        return 10000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, TmallSettlementImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((data.values().size() <= this.getBatchCount() ? 1 : 0) != 0, (String)"\u5355\u6b21\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7%s\u6761", (long)this.getBatchCount().intValue());
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, TmallSettlementImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            TmallSettlementImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getCode()), "\u4e1a\u52a1\u4e3b\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSubCode()), "\u4e1a\u52a1\u5b50\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getOrderType()), "\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getPlatformProductCode()), "\u540e\u7aef\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getPlatformId()), "\u552f\u4e00ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getExpenseItem()), "\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getAmountStr()), "\u542b\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getMdgCode()), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesOrgCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getBusinessFormatCode()), "\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, TmallSettlementImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            this.baseValidate(data, errMap);
            List<TpmSettlementManage> importList = this.validateRepeatAndSave(data, errMap);
            if (errMap.isEmpty()) {
                this.tpmSettlementManageRepository.bulkPreservation(importList);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
        return errMap;
    }

    private void baseValidate(LinkedHashMap<Integer, TmallSettlementImportsVo> data, Map<Integer, String> errMap) {
        List expenseFormDtoList;
        List customerVos;
        Map mdmBusinessFormatMap = new HashMap();
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> platformProductRelationVoMap = new HashMap();
        Map<Object, Object> expenseFormDtoMap = new HashMap();
        mdmBusinessFormatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        HashSet customerCodeSet = Sets.newHashSet();
        HashSet expenseItemSet = Sets.newHashSet();
        HashSet productCodeSet = Sets.newHashSet();
        for (Map.Entry<Integer, TmallSettlementImportsVo> row : data.entrySet()) {
            productCodeSet.add(row.getValue().getPlatformProductCode());
            expenseItemSet.add(row.getValue().getExpenseItem());
            String customerCode = "";
            String mdgCode = row.getValue().getMdgCode();
            customerCode = customerCode + mdgCode;
            String salesOrgCode = row.getValue().getSalesOrgCode();
            customerCode = customerCode + salesOrgCode;
            String channelCode = row.getValue().getChannelCode();
            customerCode = customerCode + channelCode;
            String businessFormatCode = row.getValue().getBusinessFormatCode();
            if (!StringUtils.isEmpty((CharSequence)businessFormatCode)) {
                if (!mdmBusinessFormatMap.containsKey(businessFormatCode)) {
                    this.validateIsTrue(false, "\u4e1a\u6001" + businessFormatCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                } else {
                    row.getValue().setBusinessFormatCode((String)mdmBusinessFormatMap.get(businessFormatCode));
                }
            }
            customerCode = customerCode + row.getValue().getBusinessFormatCode();
            customerCodeSet.add(customerCode);
            row.getValue().setCustomerCode(customerCode);
            try {
                row.getValue().setAmount(new BigDecimal(row.getValue().getAmountStr()));
            }
            catch (Exception e3) {
                log.error("\u5bfc\u5165\u62a5\u9519:{}", (Object)e3.getMessage());
                this.validateIsTrue(false, "\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a\u6216\u683c\u5f0f\u9519\u8bef");
            }
            try {
                row.getValue().setQuantity(new Integer(row.getValue().getQuantityStr()));
                row.getValue().setPrice(new BigDecimal(row.getValue().getPriceStr()));
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                DateStringDealUtil.validateDateStrAndSet((String)row.getValue().getBusinessTimeStr(), (String)"\u4e1a\u52a1\u53d1\u751f\u65f6\u95f4", (boolean)true, (String)"yyyy-MM-dd HH:mm:ss", arg_0 -> ((TmallSettlementImportsVo)row.getValue()).setBusinessTime(arg_0));
            }
            catch (Exception e4) {
                this.validateIsTrue(false, e4.getMessage());
            }
            row.getValue().setYearMonthStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)row.getValue().getBusinessTime()));
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(row.getKey(), errInfo);
        }
        if (!CollectionUtils.isEmpty((Collection)customerCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)productCodeSet) && !CollectionUtils.isEmpty((Collection)customerCodeSet)) {
            PlatformProductRelationDto platformProductRelationDto = new PlatformProductRelationDto();
            platformProductRelationDto.setPlatformProductCodeSet((Set)productCodeSet);
            platformProductRelationDto.setCustomerCodeSet((Set)customerCodeSet);
            List platformVoList = this.platformProductRelationService.findListByConditions(platformProductRelationDto);
            if (!CollectionUtils.isEmpty((Collection)platformVoList)) {
                platformProductRelationVoMap = platformVoList.stream().collect(Collectors.toMap(e -> e.getCustomerCode() + e.getPlatformProductCode(), Function.identity(), (e1, e2) -> e1));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)productCodeSet) && !CollectionUtils.isEmpty((Collection)(expenseFormDtoList = this.platformExpenseFormService.findListByExpenseNameSet((Set)expenseItemSet)))) {
            expenseFormDtoMap = expenseFormDtoList.stream().collect(Collectors.toMap(PlatformExpenseFormDto::getExpensesName, Function.identity(), (e1, e2) -> e1));
        }
        for (Map.Entry<Integer, TmallSettlementImportsVo> row : data.entrySet()) {
            String errInfo;
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(row.getValue().getCustomerCode());
            PlatformProductRelationVo productVo = (PlatformProductRelationVo)platformProductRelationVoMap.get(row.getValue().getCustomerCode() + row.getValue().getPlatformProductCode());
            PlatformExpenseFormDto platformExpenseFormDto = (PlatformExpenseFormDto)expenseFormDtoMap.get(row.getValue().getExpenseItem());
            if (customerVo != null) {
                row.getValue().setCustomerName(customerVo.getCustomerName());
                row.getValue().setSalesOrgCode(customerVo.getSalesInstitutionErpCode());
                row.getValue().setSalesOrgName(customerVo.getSalesInstitutionName());
                row.getValue().setChannelCode(customerVo.getCustomerChannelCode());
                row.getValue().setChannelName(customerVo.getCustomerChannelName());
            } else {
                this.validateIsTrue(false, "\u6839\u636eMDG\u5ba2\u6237\u7f16\u7801+\u9500\u552e\u673a\u6784\u7f16\u7801+\u6e20\u9053\u7f16\u7801+\u4e1a\u6001\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237\uff01");
            }
            if (productVo != null) {
                row.getValue().setProductName(productVo.getProductName());
                row.getValue().setProductCode(productVo.getProductCode());
                row.getValue().setPlatformProductCode(productVo.getPlatformProductCode());
                row.getValue().setPlatformProductName(productVo.getPlatformProductName());
            } else {
                this.validateIsTrue(false, "\u6839\u636e\u540e\u7aef\u5546\u54c1\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u4ea7\u54c1\uff01");
            }
            if (platformExpenseFormDto != null) {
                row.getValue().setActivityFormCode(platformExpenseFormDto.getActivityFormCode());
                row.getValue().setActivityFormName(platformExpenseFormDto.getActivityFormName());
                row.getValue().setSourceCode(TpmSettlementSourceEnum.T_MALL.getCode());
            } else {
                this.validateIsTrue(false, "\u6839\u636e\u8d39\u7528\u7c7b\u578b\u672a\u627e\u5230\u5bf9\u5e94\u6d3b\u52a8\u5f62\u5f0f\uff01");
            }
            if ((errInfo = this.validateGetErrorInfo()) == null) continue;
            if (errMap.containsKey(row.getKey())) {
                errMap.put(row.getKey(), errMap.get(row.getKey()) + "," + errInfo);
                continue;
            }
            errMap.put(row.getKey(), errInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TpmSettlementManage> validateRepeatAndSave(LinkedHashMap<Integer, TmallSettlementImportsVo> data, Map<Integer, String> errMap) {
        HashMap repeatKeyToIndexMap = Maps.newHashMap();
        data.forEach((index, importsVo) -> {
            String key = TpmSettlementSourceEnum.T_MALL.getCode() + importsVo.getPlatformId();
            if (repeatKeyToIndexMap.containsKey(key)) {
                Integer lastIndex = (Integer)repeatKeyToIndexMap.get(key);
                this.validateIsTrue(false, "\u8be5\u884c\u552f\u4e00ID\u4e0e\u7b2c\u3010" + lastIndex + "\u3011\u884c\u91cd\u590d");
            } else {
                repeatKeyToIndexMap.put(key, index);
                importsVo.setVerifyId(key);
            }
            String errInfo = this.validateGetErrorInfo();
            if (errInfo != null) {
                if (errMap.containsKey(index)) {
                    errMap.put((Integer)index, (String)errMap.get(index) + "," + errInfo);
                } else {
                    errMap.put((Integer)index, errInfo);
                }
            }
        });
        List importList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), TmallSettlementImportsVo.class, TpmSettlementManage.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList<String> repeatKeyList = new ArrayList<String>(repeatKeyToIndexMap.keySet());
        boolean isLock = this.redisLockService.batchLock("tpm:settlement_manage:edit:", repeatKeyList, TimeUnit.MINUTES, 20);
        Validate.isTrue((boolean)isLock, (String)"\u52a0\u9501\u5931\u8d25", (Object[])new Object[0]);
        try {
            Set<String> repeatSet = this.tpmSettlementManageRepository.repeatValidateBatch(repeatKeyList);
            if (CollectionUtils.isNotEmpty(repeatSet)) {
                data.forEach((index, importsVo) -> {
                    String errInfo;
                    if (repeatSet.contains(importsVo.getVerifyId())) {
                        this.validateIsTrue(false, "\u552f\u4e00ID\u5df2\u6709\u73b0\u5b58\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                    }
                    if ((errInfo = this.validateGetErrorInfo()) != null) {
                        if (errMap.containsKey(index)) {
                            errMap.put((Integer)index, (String)errMap.get(index) + "," + errInfo);
                        } else {
                            errMap.put((Integer)index, errInfo);
                        }
                    }
                });
            }
        }
        finally {
            this.redisLockService.batchUnLock("tpm:settlement_manage:edit:", repeatKeyList);
        }
        return importList;
    }

    public Class<TmallSettlementImportsVo> findCrmExcelVoClass() {
        return TmallSettlementImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SETTLEMENT_TMALL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u7ed3\u7b97\u5355\u7ba1\u7406-\u732b\u8d85\u5bfc\u5165";
    }
}

