/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.settlement.manage.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.settlement.manage.local.entity.TpmSettlementManage;
import com.biz.crm.tpm.business.settlement.manage.local.repository.TpmSettlementManageRepository;
import com.biz.crm.tpm.business.settlement.manage.sdk.dto.TpmSettlementManageDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.dto.log.TpmSettlementManageLogEventDto;
import com.biz.crm.tpm.business.settlement.manage.sdk.event.log.TpmSettlementManageLogEventListener;
import com.biz.crm.tpm.business.settlement.manage.sdk.service.TpmSettlementManageService;
import com.biz.crm.tpm.business.settlement.manage.sdk.vo.TpmSettlementManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tpmSettlementManageService")
public class TpmSettlementManageServiceImpl
implements TpmSettlementManageService {
    private static final Logger log = LoggerFactory.getLogger(TpmSettlementManageServiceImpl.class);
    @Autowired(required=false)
    private TpmSettlementManageRepository tpmSettlementManageRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    public Page<TpmSettlementManageVo> findByConditions(Pageable pageable, TpmSettlementManageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmSettlementManageDto();
        }
        return this.tpmSettlementManageRepository.findByConditions(pageable, dto);
    }

    public BigDecimal getAmount(TpmSettlementManageDto dto) {
        if (Objects.isNull(dto) || Strings.isEmpty((CharSequence)dto.getCustomerCode()) || Strings.isEmpty((CharSequence)dto.getExpenseItem()) || Objects.isNull(dto.getBusinessStartTime()) || Objects.isNull(dto.getBusinessEndTime())) {
            return BigDecimal.ZERO;
        }
        return this.tpmSettlementManageRepository.getAmount(dto);
    }

    public Integer getQuantity(TpmSettlementManageDto dto) {
        if (Objects.isNull(dto) || Strings.isEmpty((CharSequence)dto.getCustomerCode()) || Strings.isEmpty((CharSequence)dto.getExpenseItem()) || Objects.isNull(dto.getBusinessStartTime()) || Objects.isNull(dto.getBusinessEndTime())) {
            return 0;
        }
        return this.tpmSettlementManageRepository.getQuantity(dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmSettlementManageRepository.lambdaUpdate().in(UuidEntity::getId, idList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<TpmSettlementManageDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, TpmSettlementManageDto.class, TpmSettlementManage.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.tpmSettlementManageRepository.bulkPreservation(new ArrayList<TpmSettlementManage>(entities));
        if (importList.size() > 10000) {
            while (importList.size() > 0) {
                int removeSize = Math.min(importList.size(), 50);
                List<TpmSettlementManageDto> removeList = importList.subList(0, removeSize);
                MqMessageVo mqMessage = new MqMessageVo();
                mqMessage.setMsgBody(JSON.toJSONString(removeList));
                mqMessage.setTag("SETTLEMENT_MANAGE_CREATE_LOG_TAG");
                this.rocketMqProducer.sendMqMsg(mqMessage);
                importList.removeAll(removeList);
            }
        } else {
            this.logCreate(importList);
        }
    }

    public void logCreate(List<TpmSettlementManageDto> dtoList) {
        dtoList.forEach(dto -> {
            TpmSettlementManageLogEventDto logEventDto = new TpmSettlementManageLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = TpmSettlementManageLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmSettlementManageLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public BigDecimal getAmountByActivityFormCode(TpmSettlementManageDto dto) {
        return this.tpmSettlementManageRepository.getAmountByActivityFormCode(dto);
    }
}

