package com.biz.crm.tpm.business.subsidiary.activity.design.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.subsidiary.activity.design.feign.impl.CpsPushSubsidiaryActivityDesignFeignImpl;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.cps.CpsFeeDetailDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = CpsPushSubsidiaryActivityDesignFeignImpl.class)
public interface CpsPushSubsidiaryActivityDesignFeign {

    /**
     * cps渠道分子公司费用明细推送
     * @param dtoList
     * @return
     */
    @PostMapping(value = "/v1/subsidiary/activity/design/pushFeeDetail")
    public Result pushFeeDetail(@RequestBody List<CpsFeeDetailDto> dtoList);

}
