package com.biz.crm.tpm.business.subsidiary.activity.design.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.subsidiary.activity.design.feign.impl.SfaPushSubComActivityDesignFeignImpl;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.sfa.SfaSubComActivityDesignCreateResult;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.sfa.SfaSubComActivityDesignDisplayCreateDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * 活动占用推送feign
 * @author wanghaojia
 * @date 2023/1/5 17:02
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = SfaPushSubComActivityDesignFeignImpl.class)
public interface SfaPushSubComActivityDesignFeign {

    @PostMapping(value = "/v1/subsidiary/activity/design/sfaSubComActivityDesignCreateDisplay")
    Result<List<SfaSubComActivityDesignCreateResult>> sfaSubComActivityDesignCreateDisplay(List<SfaSubComActivityDesignDisplayCreateDto> list);
    
}
