/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.warning.config.local.job.RefreshWarningMonitoringTask;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.service.TpmWarningConfigService;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigDisplayVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tpmWarningConfig"})
@Api(tags={"TPM-\u9884\u8b66\u914d\u7f6e"})
public class TpmWarningConfigController {
    private static final Logger log = LoggerFactory.getLogger(TpmWarningConfigController.class);
    @Autowired(required=false)
    private TpmWarningConfigService tpmWarningConfigService;
    @Autowired(required=false)
    private RefreshWarningMonitoringTask refreshWarningMonitoringTask;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<TpmWarningConfigVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="tpmWarningConfig", value="TPM-\u9884\u8b66\u914d\u7f6e") TpmWarningConfigDto tpmWarningConfig) {
        try {
            Page page = this.tpmWarningConfigService.findByConditions(pageable, tpmWarningConfig);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e(\u524d\u7aef\u7528)")
    @GetMapping(value={"{id}"})
    public Result<TpmWarningConfigDisplayVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            TpmWarningConfigDisplayVo tpmWarningConfig = this.tpmWarningConfigService.findById(id);
            return Result.ok((Object)tpmWarningConfig);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<TpmWarningConfigVo> create(@ApiParam(name="tpmWarningConfig", value="TPM-\u9884\u8b66\u914d\u7f6e") @RequestBody TpmWarningConfigDto tpmWarningConfig) {
        try {
            TpmWarningConfigVo result = this.tpmWarningConfigService.create(tpmWarningConfig);
            String dayStr = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd");
            TpmWarningConfigDto tpmWarningConfigDto = (TpmWarningConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, TpmWarningConfigDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.refreshWarningMonitoringTask.startNewtWarningMonitoring(dayStr, tpmWarningConfigDto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<TpmWarningConfigVo> update(@ApiParam(name="tpmWarningConfig", value="TPM-\u9884\u8b66\u914d\u7f6e") @RequestBody TpmWarningConfigDto tpmWarningConfig) {
        try {
            TpmWarningConfigVo result = this.tpmWarningConfigService.update(tpmWarningConfig);
            TpmWarningConfigDto tpmWarningConfigDto = (TpmWarningConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, TpmWarningConfigDto.class, HashSet.class, ArrayList.class, new String[0]);
            this.refreshWarningMonitoringTask.resetWarningMonitoring(tpmWarningConfigDto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            List list = this.tpmWarningConfigService.delete(idList);
            Collection tpmWarningConfigDtos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmWarningConfigVo.class, TpmWarningConfigDto.class, HashSet.class, ArrayList.class, new String[0]);
            for (TpmWarningConfigDto tpmWarningConfigDto : tpmWarningConfigDtos) {
                this.refreshWarningMonitoringTask.resetWarningMonitoring(tpmWarningConfigDto);
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"stopWarningMonitoringByTaskDesc"})
    @ApiOperation(value="\u505c\u6b62\u9884\u8b66\u76d1\u63a7\u4efb\u52a1")
    public Result stopWarningMonitoringByTaskDesc(@ApiParam(name="taskDesc", value="\u4efb\u52a1\u63cf\u8ff0") @RequestParam String taskDesc) {
        try {
            this.refreshWarningMonitoringTask.stopWarningMonitoringByTaskDesc(taskDesc);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

