/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.warning.config.local.service.TpmWarningMonitoringService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tpmWarningMonitoring"})
@Api(tags={"TPM-\u9884\u8b66\u914d\u7f6e"})
public class TpmWarningMonitoringController {
    private static final Logger log = LoggerFactory.getLogger(TpmWarningMonitoringController.class);
    @Autowired(required=false)
    private TpmWarningMonitoringService tpmWarningMonitoringService;

    @ApiOperation(value="\u67e5\u8be2\u76d1\u63a7\u8868\u53d8\u91cf")
    @GetMapping(value={"findTpmWarningMonitoringVariableList"})
    public Result<List<TpmWarningMonitoringVariable>> findTpmWarningMonitoringVariableList(String monitoringTable) {
        try {
            Validate.notBlank((CharSequence)monitoringTable, (String)"\u76d1\u63a7\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List<TpmWarningMonitoringVariable> list = this.tpmWarningMonitoringService.findTpmWarningMonitoringVariableList(monitoringTable);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76d1\u63a7\u8868\u53d8\u91cf-\u516c\u5f0f")
    @GetMapping(value={"findTpmWarningMonitoringConditionVariableList"})
    public Result<List<TpmWarningMonitoringVariable>> findTpmWarningMonitoringConditionVariableList(String monitoringTable) {
        try {
            Validate.notBlank((CharSequence)monitoringTable, (String)"\u76d1\u63a7\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List<Object> list = this.tpmWarningMonitoringService.findTpmWarningMonitoringVariableList(monitoringTable);
            list = list.stream().filter(TpmWarningMonitoringVariable::getIsCondition).collect(Collectors.toList());
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76d1\u63a7\u8868\u53d8\u91cf-\u63d0\u793a")
    @GetMapping(value={"findTpmWarningMonitoringWarningVariableList"})
    public Result<List<TpmWarningMonitoringVariable>> findTpmWarningMonitoringWarningVariableList(String monitoringTable) {
        try {
            Validate.notBlank((CharSequence)monitoringTable, (String)"\u76d1\u63a7\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List<Object> list = this.tpmWarningMonitoringService.findTpmWarningMonitoringVariableList(monitoringTable);
            list = list.stream().filter(TpmWarningMonitoringVariable::getIsWaring).collect(Collectors.toList());
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6267\u884c\u76d1\u63a7\u8868\u9884\u8b66")
    @GetMapping(value={"runTpmWarningMonitoring"})
    public Result runTpmWarningMonitoring(TpmWarningConfigDto dto) {
        try {
            List<TpmWarningConfigDto> configDtos = this.tpmWarningMonitoringService.findRunTpmWarningMonitoring(dto);
            for (TpmWarningConfigDto configDto : configDtos) {
                try {
                    this.tpmWarningMonitoringService.runTpmWarningMonitoring(configDto);
                }
                catch (Exception e) {
                    log.error("\u9884\u8b66\u914d\u7f6e[" + configDto.getCode() + "]\u6267\u884c\u5931\u8d25!", (Throwable)e);
                }
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"disable"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7f16\u7801\u7981\u7528")
    public Result disable(@ApiParam(name="monitoringTable", value="\u8868") @RequestParam String monitoringTable, @ApiParam(name="businessCodeList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> businessCodeList) {
        try {
            this.tpmWarningMonitoringService.disable(monitoringTable, businessCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"enable"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7f16\u7801\u542f\u7528")
    public Result enable(@ApiParam(name="monitoringTable", value="\u8868") @RequestParam String monitoringTable, @ApiParam(name="businessCodeList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> businessCodeList) {
        try {
            this.tpmWarningMonitoringService.enable(monitoringTable, businessCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

