/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.job;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningMonitoringRepository;
import com.biz.crm.tpm.business.warning.config.local.service.TpmWarningMonitoringService;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.task.dto.DynamicTaskSchedulerDto;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="refreshWarningMonitoringTask")
public class RefreshWarningMonitoringTask {
    private static final Logger log = LoggerFactory.getLogger(RefreshWarningMonitoringTask.class);
    @Autowired(required=false)
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired(required=false)
    private TpmWarningMonitoringRepository tpmWarningMonitoringRepository;
    @Autowired(required=false)
    private TpmWarningMonitoringService tpmWarningMonitoringService;

    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u9884\u8b66\u76d1\u63a7\u5b9a\u65f6\u521b\u5efa\u4efb\u52a1")
    public void refreshWarningMonitoring() {
        List<TpmWarningConfigDto> runTpmWarningMonitoring = this.tpmWarningMonitoringService.findRunTpmWarningMonitoring(new TpmWarningConfigDto());
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        String dayStr = DateUtil.getDateStrByFormat((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        for (TpmWarningConfigDto tpmWarningConfigDto : runTpmWarningMonitoring) {
            String code = tpmWarningConfigDto.getCode();
            String taskCode = "WARING-MONITORING-" + dayStr + code + UuidCrmUtil.general();
            String taskName = "\u9884\u8b66\u76d1\u63a7-" + dayStr + code + tpmWarningConfigDto.getName();
            this.dynamicTaskSchedulerVoService.createIgnorePrefix(taskCode, "refreshWarningMonitoringTask", "runTpmWarningMonitoring", tpmWarningConfigDto.getWarningFrequency(), calendar.getTime(), taskName, new Object[]{tpmWarningConfigDto.getCode()});
        }
    }

    public void stopWarningMonitoringByTaskDesc(String taskDesc) {
        DynamicTaskSchedulerDto dynamicTaskSchedulerDto = new DynamicTaskSchedulerDto();
        dynamicTaskSchedulerDto.setTaskDesc(taskDesc);
        List<DynamicTaskSchedulerVo> taskList = this.tpmWarningMonitoringRepository.findWarningMonitoringTaskList(dynamicTaskSchedulerDto);
        this.stopWarningMonitoring(taskList.stream().map(DynamicTaskSchedulerVo::getTaskCode).collect(Collectors.toList()));
    }

    public void stopWarningMonitoring(List<String> taskCodes) {
        if (CollectionUtil.isEmpty(taskCodes)) {
            return;
        }
        log.info("\u9884\u8b66\u76d1\u63a7\u505c\u6b62\u4efb\u52a1" + taskCodes);
        this.dynamicTaskSchedulerVoService.stop(taskCodes.toArray(new String[0]));
    }

    public void resetWarningMonitoring(TpmWarningConfigDto tpmWarningConfigDto) {
        String dayStr = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd");
        String code = tpmWarningConfigDto.getCode();
        this.stopWarningMonitoringByTaskDesc("\u9884\u8b66\u76d1\u63a7-" + dayStr + code);
        if (!EnableStatusEnum.ENABLE.getCode().equals(tpmWarningConfigDto.getEnableStatus())) {
            return;
        }
        if (!DelFlagStatusEnum.NORMAL.getCode().equals(tpmWarningConfigDto.getDelFlag())) {
            return;
        }
        Date curDate = new Date();
        if (tpmWarningConfigDto.getStartDate().compareTo(curDate) > 0 || tpmWarningConfigDto.getEndDate().compareTo(curDate) < 0) {
            return;
        }
        this.startNewtWarningMonitoring(dayStr, tpmWarningConfigDto);
    }

    public void startNewtWarningMonitoring(String dayStr, TpmWarningConfigDto tpmWarningConfigDto) {
        this.startNewtWarningMonitoring(dayStr, Lists.newArrayList((Object[])new TpmWarningConfigDto[]{tpmWarningConfigDto}));
    }

    public void startNewtWarningMonitoring(String dayStr, List<TpmWarningConfigDto> runTpmWarningMonitoring) {
        if (CollectionUtil.isEmpty(runTpmWarningMonitoring)) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        for (TpmWarningConfigDto tpmWarningConfigDto : runTpmWarningMonitoring) {
            String code = tpmWarningConfigDto.getCode();
            String taskCode = "WARING-MONITORING-" + dayStr + code + UuidCrmUtil.general();
            String taskName = "\u9884\u8b66\u76d1\u63a7-" + dayStr + code + tpmWarningConfigDto.getName();
            this.dynamicTaskSchedulerVoService.createIgnorePrefix(taskCode, "refreshWarningMonitoringTask", "runTpmWarningMonitoring", tpmWarningConfigDto.getWarningFrequency(), calendar.getTime(), taskName, new Object[]{tpmWarningConfigDto.getCode()});
        }
    }

    @DynamicTaskService(cornExpression="0 0 * * * ?", taskDesc="\u9884\u8b66\u76d1\u63a7\u5b9a\u65f6\u6e05\u7406\u4efb\u52a1-\u5220\u9664\u5df2\u505c\u6b62\u4efb\u52a1")
    public void clearWarningMonitoring() {
        DynamicTaskSchedulerDto dynamicTaskSchedulerDto = new DynamicTaskSchedulerDto();
        dynamicTaskSchedulerDto.setTaskDesc("\u9884\u8b66\u76d1\u63a7-");
        dynamicTaskSchedulerDto.setWorkingStatus(Integer.valueOf(3));
        List<DynamicTaskSchedulerVo> taskList = this.tpmWarningMonitoringRepository.findWarningMonitoringTaskList(dynamicTaskSchedulerDto);
        if (CollectionUtil.isEmpty(taskList)) {
            return;
        }
        this.dynamicTaskSchedulerVoService.deleteByTaskcodes((String[])taskList.stream().map(DynamicTaskSchedulerVo::getTaskCode).toArray(String[]::new));
    }

    public void runTpmWarningMonitoring(String warningCode) {
        TpmWarningConfigDto searchDto = new TpmWarningConfigDto();
        searchDto.setCode(warningCode);
        List<TpmWarningConfigDto> runTpmWarningMonitoring = this.tpmWarningMonitoringService.findRunTpmWarningMonitoring(searchDto);
        this.tpmWarningMonitoringService.runTpmWarningMonitoring(runTpmWarningMonitoring.get(0));
    }
}

