/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.register;

import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoring;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningMonitoringRepository;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class TpmWaringMonitoringQueryInterceptor
implements ExternalQueryInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TpmWaringMonitoringQueryInterceptor.class);
    private static final String field = "warning_status";
    @Autowired(required=false)
    private TpmWarningMonitoringRepository tpmWarningMonitoringRepository;

    public String code() {
        return "tpm_waring_monitoring_warning_status";
    }

    public String name() {
        return "\u76d1\u63a7\u9884\u8b66-\u9884\u8b66\u72b6\u6001";
    }

    public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String ... strings) {
        List results = executeContent.getResults();
        if (CollectionUtils.isEmpty((Collection)results)) {
            return null;
        }
        String businessCodeField = "only_key";
        String monitoringTable = "tpm_up_expect_audit_amount_monitor";
        List<String> businessCodeList = results.stream().map(item -> Optional.ofNullable(item.get(businessCodeField)).orElse("").toString()).collect(Collectors.toList());
        List<TpmWarningMonitoring> warningMonitoringList = this.tpmWarningMonitoringRepository.findByBusinessCodeList(monitoringTable, businessCodeList);
        Map warningMonitoringMap = warningMonitoringList.stream().collect(Collectors.toMap(TpmWarningMonitoring::getBusinessCode, Function.identity()));
        ArrayList contents = Lists.newArrayList();
        for (Map item2 : results) {
            if (null == item2) {
                contents.add(null);
                continue;
            }
            String businessCode = Optional.ofNullable(item2.get(businessCodeField)).orElse("").toString();
            TpmWarningMonitoring tpmWarningMonitoring = (TpmWarningMonitoring)((Object)warningMonitoringMap.get(businessCode));
            contents.add(Lists.newArrayList((Object[])new String[]{tpmWarningMonitoring.getWarningStatus()}).toArray());
        }
        return contents;
    }
}

