/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningCondition;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningConditionMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmWarningConditionRepository
extends ServiceImpl<TpmWarningConditionMapper, TpmWarningCondition> {
    @Autowired(required=false)
    private TpmWarningConditionMapper tpmWarningConditionMapper;

    public Page<TpmWarningCondition> findByConditions(Pageable pageable, TpmWarningCondition tpmWarningCondition) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmWarningConditionMapper.findByConditions((Page<TpmWarningCondition>)page, tpmWarningCondition);
    }

    public void removeByCode(String code, String tenantCode) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TpmWarningCondition::getCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public Map<String, List<TpmWarningCondition>> findByCodeList(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Maps.newConcurrentMap();
        }
        return Lists.partition(codeList, (int)500).parallelStream().flatMap(x -> {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(TpmWarningCondition::getCode, (Collection)x)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
            return this.list((Wrapper)wrapper).stream();
        }).collect(Collectors.groupingBy(TpmWarningCondition::getCode));
    }
}

