/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoring;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningMonitoringMapper;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWaringMonitoringStatus;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningMonitoringVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.dto.DynamicTaskSchedulerDto;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TpmWarningMonitoringRepository
extends ServiceImpl<TpmWarningMonitoringMapper, TpmWarningMonitoring> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Value(value="${spring.application.name}")
    private String applicationName;

    public List<TpmWarningMonitoring> findByBusinessCodeList(String monitoringTable, List<String> businessCodeList) {
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmWarningMonitoring::getMonitoringTable, (Object)monitoringTable)).in(TpmWarningMonitoring::getBusinessCode, businessCodeList));
    }

    public List<String> findWarningBusinessCodeList(String monitoringTable) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmWarningMonitoring::getMonitoringTable, (Object)monitoringTable)).eq(TpmWarningMonitoring::getWarningStatus, (Object)TpmWaringMonitoringStatus.WARNING.getCode())).select(new SFunction[]{TpmWarningMonitoring::getBusinessCode})).stream().map(TpmWarningMonitoring::getBusinessCode).distinct().collect(Collectors.toList());
    }

    public List<TpmWarningMonitoringVo> findTpmWarningMonitoringList(String monitoringTable, List<String> businessCodeList) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmWarningMonitoring::getMonitoringTable, (Object)monitoringTable)).in(TpmWarningMonitoring::getBusinessCode, businessCodeList));
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmWarningMonitoring.class, TpmWarningMonitoringVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<String> findExcludeBusinessCodeList(String monitoringTable) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmWarningMonitoring::getMonitoringTable, (Object)monitoringTable)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{TpmWarningMonitoring::getBusinessCode})).stream().map(TpmWarningMonitoring::getBusinessCode).collect(Collectors.toList());
    }

    public List<DynamicTaskSchedulerVo> findWarningMonitoringTaskList(DynamicTaskSchedulerDto dynamicTaskSchedulerDto) {
        dynamicTaskSchedulerDto.setAppCode(TenantUtils.getTenantCode());
        dynamicTaskSchedulerDto.setApplicationName(this.applicationName);
        return ((TpmWarningMonitoringMapper)this.baseMapper).findWarningMonitoringTaskList(dynamicTaskSchedulerDto);
    }
}

