/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.warning.config.local.mapper.TpmWarningConfigMapper;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigExportsDto;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigExportsVo;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmWarningConfigExportsProcess
implements ExportProcess<TpmWarningConfigExportsVo> {
    @Autowired(required=false)
    private TpmWarningConfigMapper tpmWarningConfigMapper;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        TpmWarningConfigExportsDto dto = this.convertParams(params);
        Integer total = this.tpmWarningConfigMapper.getExportTotal(dto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        TpmWarningConfigExportsDto dto = this.convertParams(params);
        dto.setOffset(Integer.valueOf(this.getPageSize() * vo.getPageNo()));
        dto.setLimit(vo.getPageSize());
        List<TpmWarningConfigExportsVo> data = this.tpmWarningConfigMapper.findData(dto);
        return JSON.parseArray((String)JSON.toJSONString(data));
    }

    public Class<TpmWarningConfigExportsVo> findCrmExcelVoClass() {
        return TpmWarningConfigExportsVo.class;
    }

    public String getBusinessCode() {
        return "TPM_WARNING_CONFIG_EXPORT";
    }

    public String getBusinessName() {
        return "TPM\u9884\u8b66\u914d\u7f6e\u5bfc\u51fa";
    }

    private TpmWarningConfigExportsDto convertParams(Map<String, Object> params) {
        return (TpmWarningConfigExportsDto)JSON.parseObject((String)JSON.toJSONString(params), TpmWarningConfigExportsDto.class);
    }
}

