/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningCondition;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningConfig;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.local.job.RefreshWarningMonitoringTask;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningConditionRepository;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningConfigRepository;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningReceivingObjectRepository;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningReceivingObjectDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.log.TpmWarningConfigLogEventDto;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningReceivingObjectTypeEnum;
import com.biz.crm.tpm.business.warning.config.sdk.event.TpmWarningConfigLogEventListener;
import com.biz.crm.tpm.business.warning.config.sdk.service.TpmWarningConfigService;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConditionVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigDisplayVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningConfigVo;
import com.biz.crm.tpm.business.warning.config.sdk.vo.TpmWarningReceivingObjectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tpmWarningConfigService")
public class TpmWarningConfigServiceImpl
implements TpmWarningConfigService {
    @Autowired(required=false)
    private TpmWarningConfigRepository tpmWarningConfigRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmWarningConditionRepository tpmWarningConditionRepository;
    @Autowired(required=false)
    private TpmWarningReceivingObjectRepository tpmWarningReceivingObjectRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private RefreshWarningMonitoringTask refreshWarningMonitoringTask;

    public Page<TpmWarningConfigVo> findByConditions(Pageable pageable, TpmWarningConfigDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmWarningConfigDto();
        }
        return this.tpmWarningConfigRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void executeWarning() {
        List<TpmWarningConfigVo> tpmWarningConfigVoList = this.tpmWarningConfigRepository.findUnderWay();
        if (CollectionUtils.isEmpty(tpmWarningConfigVoList)) {
            return;
        }
        List<String> codeList = tpmWarningConfigVoList.stream().map(TpmWarningConfigVo::getCode).collect(Collectors.toList());
        Map<String, List<TpmWarningCondition>> codeToConditionListMap = this.tpmWarningConditionRepository.findByCodeList(codeList);
    }

    public TpmWarningConfigDisplayVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmWarningConfig entity = (TpmWarningConfig)((Object)this.tpmWarningConfigRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmWarningConfigDisplayVo tpmWarningConfigVo = (TpmWarningConfigDisplayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmWarningConfigDisplayVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<TpmWarningConditionVo> conditions = this.tpmWarningConfigRepository.findConditionsByCode(entity.getCode());
        List<TpmWarningReceivingObjectVo> objects = this.tpmWarningConfigRepository.findObjectsByCode(entity.getCode());
        tpmWarningConfigVo.setConditionList(conditions);
        tpmWarningConfigVo.setPushDimensionList(objects.stream().filter(e -> TpmWarningReceivingObjectTypeEnum.PUSH_DIMENSION.getCode().equals(e.getWarningReceivingObjectType())).collect(Collectors.toList()));
        tpmWarningConfigVo.setOrgs(objects.stream().filter(e -> TpmWarningReceivingObjectTypeEnum.ORG.getCode().equals(e.getWarningReceivingObjectType()) && BooleanEnum.TRUE.getCapital().equals(e.getIsContains())).collect(Collectors.toList()));
        tpmWarningConfigVo.setNonOrgs(objects.stream().filter(e -> TpmWarningReceivingObjectTypeEnum.ORG.getCode().equals(e.getWarningReceivingObjectType()) && BooleanEnum.FALSE.getCapital().equals(e.getIsContains())).collect(Collectors.toList()));
        tpmWarningConfigVo.setPositions(objects.stream().filter(e -> TpmWarningReceivingObjectTypeEnum.POSITION.getCode().equals(e.getWarningReceivingObjectType()) && BooleanEnum.TRUE.getCapital().equals(e.getIsContains())).collect(Collectors.toList()));
        tpmWarningConfigVo.setNonPositions(objects.stream().filter(e -> TpmWarningReceivingObjectTypeEnum.POSITION.getCode().equals(e.getWarningReceivingObjectType()) && BooleanEnum.FALSE.getCapital().equals(e.getIsContains())).collect(Collectors.toList()));
        if (StringUtils.isNotEmpty((CharSequence)tpmWarningConfigVo.getPushDimension())) {
            tpmWarningConfigVo.setPushDimensionStrList(Arrays.asList(tpmWarningConfigVo.getPushDimension().split(",")));
        }
        return tpmWarningConfigVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmWarningConfigVo create(TpmWarningConfigDto dto) {
        this.createValidate(dto);
        TpmWarningConfig entity = (TpmWarningConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmWarningConfig.class, HashSet.class, ArrayList.class, new String[0]));
        Validate.isTrue((boolean)this.tpmWarningConfigRepository.repeatValidate(dto), (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u9884\u8b66\u7ef4\u5ea6\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        entity.setTenantCode(tenantCode);
        String code = (String)this.generateCodeService.generateCode("YJPZ", 1, Integer.valueOf(6), 0L, TimeUnit.DAYS).get(0);
        entity.setCode(code);
        Collection conditions = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getConditionList(), TpmWarningConditionDto.class, TpmWarningCondition.class, HashSet.class, ArrayList.class, new String[0]);
        Collection objects = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getObjectList(), TpmWarningReceivingObjectDto.class, TpmWarningReceivingObject.class, HashSet.class, ArrayList.class, new String[0]);
        AtomicInteger index = new AtomicInteger(1);
        conditions.forEach(e -> {
            e.setTenantCode(tenantCode);
            e.setCode(code);
            e.setSubCode(code + "-" + index.getAndIncrement());
        });
        objects.forEach(e -> {
            e.setTenantCode(tenantCode);
            e.setCode(code);
        });
        this.tpmWarningConfigRepository.save((Object)entity);
        this.tpmWarningConditionRepository.saveBatch(conditions);
        this.tpmWarningReceivingObjectRepository.saveBatch(objects);
        TpmWarningConfigLogEventDto logEventDto = new TpmWarningConfigLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = TpmWarningConfigLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmWarningConfigLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (TpmWarningConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmWarningConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmWarningConfigVo update(TpmWarningConfigDto dto) {
        this.updateValidate(dto);
        TpmWarningConfig oldEntity = (TpmWarningConfig)((Object)this.tpmWarningConfigRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)oldEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(oldEntity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(oldEntity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String code = oldEntity.getCode();
        Validate.isTrue((boolean)code.equals(dto.getCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmWarningConfigDto oldDto = (TpmWarningConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, TpmWarningConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<TpmWarningConditionVo> oldConditions = this.tpmWarningConfigRepository.findConditionsByCode(code);
        List<TpmWarningReceivingObjectVo> oldObjects = this.tpmWarningConfigRepository.findObjectsByCode(code);
        oldDto.setConditionList((List)Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(oldConditions, TpmWarningConditionVo.class, TpmWarningConditionDto.class, HashSet.class, ArrayList.class, new String[0])));
        oldDto.setObjectList((List)Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(oldObjects, TpmWarningReceivingObjectVo.class, TpmWarningReceivingObjectDto.class, HashSet.class, ArrayList.class, new String[0])));
        Validate.isTrue((boolean)this.tpmWarningConfigRepository.repeatValidate(dto), (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u9884\u8b66\u7ef4\u5ea6\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01", (Object[])new Object[0]);
        TpmWarningConfig newEntity = (TpmWarningConfig)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmWarningConfig.class, HashSet.class, ArrayList.class, new String[0]));
        Collection newConditions = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getConditionList(), TpmWarningConditionDto.class, TpmWarningCondition.class, HashSet.class, ArrayList.class, new String[0]);
        Collection newObjects = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getObjectList(), TpmWarningReceivingObjectDto.class, TpmWarningReceivingObject.class, HashSet.class, ArrayList.class, new String[0]);
        AtomicInteger index = new AtomicInteger(1);
        newConditions.forEach(e -> {
            e.setTenantCode(tenantCode);
            e.setCode(code);
            e.setSubCode(code + "-" + index.getAndIncrement());
        });
        newObjects.forEach(e -> {
            e.setTenantCode(tenantCode);
            e.setCode(code);
        });
        this.tpmWarningConditionRepository.removeByCode(code, tenantCode);
        this.tpmWarningReceivingObjectRepository.removeByCode(code, tenantCode);
        this.tpmWarningConfigRepository.saveOrUpdate((Object)newEntity);
        this.tpmWarningConditionRepository.saveOrUpdateBatch(newConditions);
        this.tpmWarningReceivingObjectRepository.saveOrUpdateBatch(newObjects);
        TpmWarningConfigLogEventDto logEventDto = new TpmWarningConfigLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = TpmWarningConfigLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmWarningConfigLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return (TpmWarningConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)newEntity, TpmWarningConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TpmWarningConfigVo> delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.tpmWarningConfigRepository.lambdaQuery().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
        for (TpmWarningConfig tpmWarningConfig : list) {
            tpmWarningConfig.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.tpmWarningConfigRepository.lambdaUpdate().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
        return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, TpmWarningConfig.class, TpmWarningConfigVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidate(TpmWarningConfigDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u8b66\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u8b66\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u8b66\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWarningMode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u8b66\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.noNullElements((Iterable)dto.getConditionList(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u8b66\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validateConditionList(dto, dto.getConditionList());
        Validate.noNullElements((Iterable)dto.getObjectList(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u8b66\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validateObjectList(dto.getObjectList());
    }

    private void updateValidate(TpmWarningConfigDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u8b66\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartDate(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u8b66\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndDate(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u8b66\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getWarningMode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u8b66\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.noNullElements((Iterable)dto.getConditionList(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u8b66\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validateConditionList(dto, dto.getConditionList());
        Validate.noNullElements((Iterable)dto.getObjectList(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u9884\u8b66\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validateObjectList(dto.getObjectList());
    }

    private void validateConditionList(TpmWarningConfigDto dto, List<TpmWarningConditionDto> conditionList) {
        if (!CollectionUtils.isEmpty((Collection)dto.getPushDimensionStrList())) {
            dto.setPushDimension(String.join((CharSequence)",", dto.getPushDimensionStrList()));
        }
        conditionList.forEach(e -> {
            e.setId(null);
            Validate.notBlank((CharSequence)e.getFormula(), (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getFormulaName(), (String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getWarningLevel(), (String)"\u9884\u8b66\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }

    private void validateObjectList(List<TpmWarningReceivingObjectDto> objectList) {
        objectList.forEach(e -> {
            e.setId(null);
            Validate.notBlank((CharSequence)e.getSubCode(), (String)"\u7ec4\u7ec7/\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getIsContains(), (String)"\u662f\u5426\u5305\u542b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)e.getWarningReceivingObjectType(), (String)"\u9884\u8b66\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }
}

