/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.third.system.alibaba.dingtalk.sdk.service.DingTalkService;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoringLog;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningReceivingObjectRepository;
import com.biz.crm.tpm.business.warning.config.local.service.WarningMonitoringPushMsgStrategy;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringMsgPushDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TpmWarningMonitoringAsyncService {
    private static final Logger log = LoggerFactory.getLogger(TpmWarningMonitoringAsyncService.class);
    @Autowired(required=false)
    private DingTalkService dingTalkService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmWarningReceivingObjectRepository tpmWarningReceivingObjectRepository;
    @Autowired(required=false)
    private List<WarningMonitoringPushMsgStrategy> pushMsgStrategyList;

    @Async
    public void pushMsg(UserIdentity loginUser, TpmWarningConfigDto dto, AbstractTpmWarningMonitoringVariableRegister variableRegister, List<Map<String, Object>> warningDataList, List<TpmWarningMonitoringLog> warningMonitoringLogList) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        List<TpmWarningReceivingObject> receivingObjects = this.tpmWarningReceivingObjectRepository.findByCode(dto.getCode());
        WarningMonitoringPushMsgStrategy msgStrategy = null;
        for (WarningMonitoringPushMsgStrategy strategy : this.pushMsgStrategyList) {
            if (!strategy.matched(dto)) continue;
            msgStrategy = strategy;
            break;
        }
        if (null == msgStrategy) {
            return;
        }
        List<TpmWarningMonitoringMsgPushDto> pushMsgList = msgStrategy.getPushMsg(dto, variableRegister, warningDataList, warningMonitoringLogList, receivingObjects);
        if (CollectionUtils.isEmpty(pushMsgList)) {
            return;
        }
        log.info("\u9884\u8b66[" + dto.getCode() + "]\u63a8\u9001\u9489\u9489:" + JSONObject.toJSONString(pushMsgList));
        List variableList = variableRegister.allVariableList();
        variableList.sort(Comparator.comparing(item -> item.getVariableField().length()).reversed());
        for (TpmWarningMonitoringMsgPushDto tpmWarningMonitoringMsgPushDto : pushMsgList) {
            String pushContent;
            if (CollectionUtils.isEmpty((Collection)tpmWarningMonitoringMsgPushDto.getUserNameList()) || StringUtils.isEmpty((CharSequence)(pushContent = this.replacePushContentVariable(dto, variableList, tpmWarningMonitoringMsgPushDto.getVariableMap())))) continue;
            this.dingTalkService.sendTextMsgByUserIdList(tpmWarningMonitoringMsgPushDto.getUserNameList(), pushContent);
        }
    }

    public String replacePushContentVariable(TpmWarningConfigDto dto, List<TpmWarningMonitoringVariable> variableList, Map<String, Object> variableMap) {
        String computeFormula = dto.getPushContentFormula();
        for (TpmWarningMonitoringVariable tpmWarningMonitoringVariable : variableList) {
            String valueStr = "";
            if (variableMap.containsKey(tpmWarningMonitoringVariable.getVariableField())) {
                Object valueObj = Optional.ofNullable(variableMap.get(tpmWarningMonitoringVariable.getVariableField())).orElse("");
                valueStr = valueObj.toString();
            }
            computeFormula = computeFormula.replace(tpmWarningMonitoringVariable.getVariableField(), valueStr);
        }
        return computeFormula;
    }
}

