/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.service.internal;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningCondition;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoring;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoringLog;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningConditionRepository;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningConfigRepository;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningMonitoringLogRepository;
import com.biz.crm.tpm.business.warning.config.local.repository.TpmWarningMonitoringRepository;
import com.biz.crm.tpm.business.warning.config.local.service.TpmWarningMonitoringService;
import com.biz.crm.tpm.business.warning.config.local.service.internal.TpmWarningMonitoringAsyncService;
import com.biz.crm.tpm.business.warning.config.local.util.WarningMonitoringMathUtil;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWaringMonitoringStatus;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TpmWarningMonitoringServiceImpl
implements TpmWarningMonitoringService {
    @Autowired(required=false)
    private TpmWarningConfigRepository tpmWarningConfigRepository;
    @Autowired(required=false)
    private TpmWarningConditionRepository tpmWarningConditionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<AbstractTpmWarningMonitoringVariableRegister> variableRegisters;
    @Autowired(required=false)
    private TpmWarningMonitoringRepository tpmWarningMonitoringRepository;
    @Autowired(required=false)
    private TpmWarningMonitoringLogRepository tpmWarningMonitoringLogRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmWarningMonitoringAsyncService tpmWarningMonitoringAsyncService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @Override
    public List<TpmWarningMonitoringVariable> findTpmWarningMonitoringVariableList(String monitoringTable) {
        ArrayList list = Lists.newArrayList();
        for (AbstractTpmWarningMonitoringVariableRegister variableRegister : this.variableRegisters) {
            if (!variableRegister.monitoringTable().equals(monitoringTable)) continue;
            return variableRegister.allVariableList();
        }
        return list;
    }

    @Override
    public List<TpmWarningConfigDto> findRunTpmWarningMonitoring(TpmWarningConfigDto dto) {
        return this.tpmWarningConfigRepository.findRunTpmWarningMonitoring(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackOn={Exception.class})
    public void runTpmWarningMonitoring(TpmWarningConfigDto dto) {
        String lockKey = "warning_monitoring:lock:" + dto.getCode();
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 2L);
            if (!lockSuccess) {
                throw new RuntimeException("\u9884\u8b66[" + dto.getCode() + "]\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c\uff01");
            }
            String monitoringTable = dto.getMonitoringTable();
            AbstractTpmWarningMonitoringVariableRegister variableRegister = null;
            for (AbstractTpmWarningMonitoringVariableRegister register : this.variableRegisters) {
                if (!register.monitoringTable().equals(monitoringTable)) continue;
                variableRegister = register;
                break;
            }
            if (null == variableRegister) {
                return;
            }
            Map<String, List<TpmWarningCondition>> conditionListMap = this.tpmWarningConditionRepository.findByCodeList(Lists.newArrayList((Object[])new String[]{dto.getCode()}));
            List<TpmWarningCondition> conditionList = conditionListMap.get(dto.getCode());
            if (CollectionUtils.isEmpty(conditionList)) {
                return;
            }
            List conditionDtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(conditionList, TpmWarningCondition.class, TpmWarningConditionDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setConditionList(conditionDtoList);
            for (TpmWarningConditionDto tpmWarningConditionDto : conditionDtoList) {
                if (StringUtils.isEmpty((CharSequence)tpmWarningConditionDto.getFormula())) continue;
                tpmWarningConditionDto.setFormula(WarningMonitoringMathUtil.formatFormulaPercent(tpmWarningConditionDto.getFormula()));
            }
            List resultMapList = variableRegister.dataList(conditionDtoList);
            if (CollectionUtils.isEmpty((Collection)resultMapList)) {
                return;
            }
            ArrayList warningMonitoringList = Lists.newArrayList();
            ArrayList warningMonitoringLogList = Lists.newArrayList();
            String runUuid = UUID.randomUUID().toString().replace("-", "");
            List variableList = variableRegister.allVariableList();
            String tenantCode = TenantUtils.getTenantCode();
            ArrayList warningDataList = Lists.newArrayList();
            for (Map objectMap : resultMapList) {
                String businessCodeField;
                Object businessCodeObj = objectMap.get(businessCodeField = variableRegister.businessCodeField());
                if (null == businessCodeObj) continue;
                String businessCode = businessCodeObj.toString();
                int warningVariableCount = 0;
                for (TpmWarningConditionDto tpmWarningCondition : conditionDtoList) {
                    String computeFormula = tpmWarningCondition.getFormula();
                    for (TpmWarningMonitoringVariable tpmWarningMonitoringVariable : variableList) {
                        if (!computeFormula.contains(tpmWarningMonitoringVariable.getVariableField())) continue;
                        Integer valueObj = objectMap.getOrDefault(tpmWarningMonitoringVariable.getVariableField(), 0);
                        computeFormula = computeFormula.replace(tpmWarningMonitoringVariable.getVariableField(), ((Object)valueObj).toString());
                    }
                    Boolean aBoolean = true;
                    if (variableRegister.doMathCompute()) {
                        aBoolean = WarningMonitoringMathUtil.computeCondition(computeFormula);
                    }
                    if (!aBoolean.booleanValue()) continue;
                    ++warningVariableCount;
                    tpmWarningCondition.getWarningDataList().add(objectMap);
                    tpmWarningCondition.setWarningCount(Integer.valueOf(Optional.ofNullable(tpmWarningCondition.getWarningCount()).orElse(0) + 1));
                    TpmWarningMonitoringLog tpmWarningMonitoringLog = new TpmWarningMonitoringLog();
                    tpmWarningMonitoringLog.setRunUuid(runUuid);
                    tpmWarningMonitoringLog.setWarningCode(dto.getCode());
                    tpmWarningMonitoringLog.setFormula(tpmWarningCondition.getFormula());
                    tpmWarningMonitoringLog.setFormulaName(tpmWarningCondition.getFormulaName());
                    tpmWarningMonitoringLog.setFormulaValue(computeFormula);
                    tpmWarningMonitoringLog.setBusinessCode(businessCode);
                    tpmWarningMonitoringLog.setTenantCode(tenantCode);
                    warningMonitoringLogList.add(tpmWarningMonitoringLog);
                }
                TpmWarningMonitoring tpmWarningMonitoring = new TpmWarningMonitoring();
                tpmWarningMonitoring.setWarningCode(dto.getCode());
                tpmWarningMonitoring.setWarningName(dto.getName());
                tpmWarningMonitoring.setMonitoringTable(dto.getMonitoringTable());
                tpmWarningMonitoring.setBusinessCode(businessCode);
                tpmWarningMonitoring.setTenantCode(tenantCode);
                if (warningVariableCount > 0) {
                    warningDataList.add(objectMap);
                }
                tpmWarningMonitoring.setWarningVariableCount(warningVariableCount);
                warningMonitoringList.add(tpmWarningMonitoring);
            }
            if (!CollectionUtils.isEmpty((Collection)warningMonitoringLogList)) {
                this.tpmWarningMonitoringAsyncService.pushMsg((UserIdentity)this.loginUserService.getAbstractLoginUser(), dto, variableRegister, warningDataList, warningMonitoringLogList);
            }
            this.updateWarningMonitoringPartition(dto, warningMonitoringList);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    private void updateWarningMonitoringPartition(TpmWarningConfigDto dto, List<TpmWarningMonitoring> warningMonitoringList) {
        List partition = Lists.partition(warningMonitoringList, (int)1000);
        for (List tpmWarningMonitorings : partition) {
            this.updateWarningMonitoring(dto, tpmWarningMonitorings);
        }
    }

    private void updateWarningMonitoring(TpmWarningConfigDto dto, List<TpmWarningMonitoring> warningMonitoringList) {
        if (CollectionUtils.isEmpty(warningMonitoringList)) {
            return;
        }
        List<String> businessCodeList = warningMonitoringList.stream().map(TpmWarningMonitoring::getBusinessCode).collect(Collectors.toList());
        List<TpmWarningMonitoring> existsList = this.tpmWarningMonitoringRepository.findByBusinessCodeList(dto.getMonitoringTable(), businessCodeList);
        Map existsMap = existsList.stream().collect(Collectors.toMap(TpmWarningMonitoring::getBusinessCode, Function.identity()));
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        ArrayList deleteList = Lists.newArrayList();
        for (TpmWarningMonitoring tpmWarningMonitoring : warningMonitoringList) {
            if (existsMap.containsKey(tpmWarningMonitoring.getBusinessCode())) {
                TpmWarningMonitoring existsTpmWarningMonitoring = (TpmWarningMonitoring)((Object)existsMap.get(tpmWarningMonitoring.getBusinessCode()));
                existsTpmWarningMonitoring.setWarningCount(existsTpmWarningMonitoring.getWarningCount() + 1);
                existsTpmWarningMonitoring.setWarningVariableCount(tpmWarningMonitoring.getWarningVariableCount());
                if (existsTpmWarningMonitoring.getWarningVariableCount() == 0) {
                    tpmWarningMonitoring.setWarningStatus(TpmWaringMonitoringStatus.NORMAL.getCode());
                    deleteList.add(existsTpmWarningMonitoring.getId());
                    continue;
                }
                updateList.add(existsTpmWarningMonitoring);
                continue;
            }
            if (tpmWarningMonitoring.getWarningVariableCount() == 0) continue;
            tpmWarningMonitoring.setRecoverWarningCount(0);
            tpmWarningMonitoring.setWarningCount(1);
            tpmWarningMonitoring.setWarningStatus(TpmWaringMonitoringStatus.WARNING.getCode());
            saveList.add(tpmWarningMonitoring);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.tpmWarningMonitoringRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.tpmWarningMonitoringRepository.updateBatchById(updateList);
        }
        if (!CollectionUtils.isEmpty((Collection)deleteList)) {
            this.tpmWarningMonitoringRepository.removeByIds(deleteList);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void disable(String monitoringTable, List<String> businessCodeList) {
        List<TpmWarningMonitoring> list = this.tpmWarningMonitoringRepository.findByBusinessCodeList(monitoringTable, businessCodeList);
        for (TpmWarningMonitoring tpmWarningMonitoring : list) {
            Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(tpmWarningMonitoring.getEnableStatus()), (String)"\u5b58\u5728\u5df2\u7981\u7528\u6570\u636e\uff01", (Object[])new Object[0]);
        }
        list.forEach(item -> item.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.tpmWarningMonitoringRepository.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void enable(String monitoringTable, List<String> businessCodeList) {
        List<TpmWarningMonitoring> list = this.tpmWarningMonitoringRepository.findByBusinessCodeList(monitoringTable, businessCodeList);
        for (TpmWarningMonitoring tpmWarningMonitoring : list) {
            Validate.isTrue((boolean)EnableStatusEnum.DISABLE.getCode().equals(tpmWarningMonitoring.getEnableStatus()), (String)"\u5b58\u5728\u672a\u7981\u7528\u6570\u636e\uff01", (Object[])new Object[0]);
        }
        list.forEach(item -> {
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setRecoverWarningCount(Optional.ofNullable(item.getRecoverWarningCount()).orElse(0) + 1);
        });
        this.tpmWarningMonitoringRepository.updateBatchById(list);
    }
}

