/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.service.internal.msgbuilder;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoringLog;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.local.service.WarningMonitoringPushMsgStrategy;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringMsgPushDto;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningReceivingObjectTypeEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DefaultWarningMonitoringPushMsgStrategy
implements WarningMonitoringPushMsgStrategy {
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private UserVoService userVoService;
    private static final String TPM_WARING_MONITORING_TABLE = "tpm_waring_monitoring_table";

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean matched(TpmWarningConfigDto dto) {
        return true;
    }

    @Override
    public List<TpmWarningMonitoringMsgPushDto> getPushMsg(TpmWarningConfigDto dto, AbstractTpmWarningMonitoringVariableRegister variableRegister, List<Map<String, Object>> warningDataList, List<TpmWarningMonitoringLog> warningMonitoringLogList, List<TpmWarningReceivingObject> receivingObjects) {
        TpmWarningMonitoringMsgPushDto tpmWarningMonitoringMsgPushDto = new TpmWarningMonitoringMsgPushDto();
        HashMap variableMap = Maps.newHashMap();
        variableMap.put("warningMsg", this.defaultWarningMsg(dto, warningDataList.size()));
        tpmWarningMonitoringMsgPushDto.setVariableMap((Map)variableMap);
        tpmWarningMonitoringMsgPushDto.setUserNameList(this.getPushUserNameList(receivingObjects));
        return Lists.newArrayList((Object[])new TpmWarningMonitoringMsgPushDto[]{tpmWarningMonitoringMsgPushDto});
    }

    public List<String> getPushUserNameList(List<TpmWarningReceivingObject> receivingObjects) {
        List positionCodeList = receivingObjects.stream().filter(item -> TpmWarningReceivingObjectTypeEnum.POSITION.getCode().equals(item.getWarningReceivingObjectType()) && BooleanEnum.TRUE.getCapital().equals(item.getIsContains())).map(TpmWarningReceivingObject::getSubCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return Lists.newArrayList();
        }
        List userVos = this.userVoService.findByPositionCodeList(positionCodeList);
        if (CollectionUtils.isEmpty((Collection)userVos)) {
            return Lists.newArrayList();
        }
        return userVos.stream().map(UserVo::getUserName).collect(Collectors.toList());
    }

    public String defaultWarningMsg(TpmWarningConfigDto dto, long warningDataCount) {
        List conditionDtoList = dto.getConditionList();
        StringBuilder warningMsgBuilder = new StringBuilder("\u51fa\u73b0");
        warningMsgBuilder.append(warningDataCount).append("\u6761\u5f02\u5e38\uff0c");
        for (TpmWarningConditionDto tpmWarningConditionDto : conditionDtoList) {
            if (null == tpmWarningConditionDto.getWarningCount() || tpmWarningConditionDto.getWarningCount() <= 0) continue;
            warningMsgBuilder.append(tpmWarningConditionDto.getFormulaName()).append("[").append(tpmWarningConditionDto.getWarningCount()).append("]\u6761\uff0c");
        }
        return warningMsgBuilder.toString();
    }
}

