/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.warning.config.local.service.internal.msgbuilder;

import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningMonitoringLog;
import com.biz.crm.tpm.business.warning.config.local.entity.TpmWarningReceivingObject;
import com.biz.crm.tpm.business.warning.config.local.service.WarningMonitoringPushMsgStrategy;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConfigDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringMsgPushDto;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningReceivingObjectTypeEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class VerticalWarningMonitoringPushMsgStrategy
implements WarningMonitoringPushMsgStrategy {
    private static final Logger log = LoggerFactory.getLogger(VerticalWarningMonitoringPushMsgStrategy.class);

    public int getOrder() {
        return 1;
    }

    @Override
    public boolean matched(TpmWarningConfigDto dto) {
        return BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode());
    }

    @Override
    public List<TpmWarningMonitoringMsgPushDto> getPushMsg(TpmWarningConfigDto dto, AbstractTpmWarningMonitoringVariableRegister variableRegister, List<Map<String, Object>> warningDataList, List<TpmWarningMonitoringLog> warningMonitoringLogList, List<TpmWarningReceivingObject> receivingObjects) {
        if (!(variableRegister instanceof AbstractTpmWarningMonitoringVariableAndPushGroupRegister)) {
            return null;
        }
        AbstractTpmWarningMonitoringVariableAndPushGroupRegister variableAndPushGroupRegister = (AbstractTpmWarningMonitoringVariableAndPushGroupRegister)variableRegister;
        List groupDataList = variableAndPushGroupRegister.groupList(dto, warningDataList);
        log.error("\u9884\u8b66\u914d\u7f6e[" + dto.getCode() + "]\u6c47\u603b\u6570\u636e\u6761\u6570:" + groupDataList.size());
        ArrayList list = Lists.newArrayList();
        for (Map objectMap : groupDataList) {
            TpmWarningMonitoringMsgPushDto tpmWarningMonitoringMsgPushDto = new TpmWarningMonitoringMsgPushDto();
            objectMap.put("warningMsg", this.defaultWarningMsg(dto, objectMap, variableAndPushGroupRegister));
            tpmWarningMonitoringMsgPushDto.setVariableMap(objectMap);
            tpmWarningMonitoringMsgPushDto.setUserNameList(this.getPushUserName(dto, objectMap, variableAndPushGroupRegister, receivingObjects));
            list.add(tpmWarningMonitoringMsgPushDto);
        }
        return list;
    }

    private List<String> getPushUserName(TpmWarningConfigDto dto, Map<String, Object> objectMap, AbstractTpmWarningMonitoringVariableAndPushGroupRegister variableRegister, List<TpmWarningReceivingObject> receivingObjects) {
        String pushDimension = dto.getPushDimension();
        String[] split = pushDimension.split(",");
        if (CollectionUtils.isEmpty(receivingObjects = receivingObjects.stream().filter(item -> TpmWarningReceivingObjectTypeEnum.PUSH_DIMENSION.getCode().equals(item.getWarningReceivingObjectType())).collect(Collectors.toList()))) {
            return Lists.newArrayList();
        }
        HashMap dimensionMap = Maps.newHashMap();
        for (String dimension : split) {
            String dimensionCodeKey;
            Object dimensionValue;
            TpmWarningDimensionEnum dimensionEnum = TpmWarningDimensionEnum.findByCode((String)dimension);
            if (null == dimensionEnum || null == (dimensionValue = objectMap.get(dimensionCodeKey = variableRegister.getDimensionCodeKey(dimensionEnum))) || StringUtils.isEmpty((CharSequence)dimensionValue.toString())) continue;
            dimensionMap.put(dimension, dimensionValue.toString());
        }
        ArrayList userNameList = Lists.newArrayList();
        for (TpmWarningReceivingObject receivingObject : receivingObjects) {
            if (StringUtils.isEmpty((CharSequence)receivingObject.getUserName())) continue;
            boolean hasEquals = false;
            if (StringUtils.isNotEmpty((CharSequence)receivingObject.getRegionCode())) {
                if (!receivingObject.getRegionCode().equals(dimensionMap.get(TpmWarningDimensionEnum.REGION.getCode())) && !receivingObject.getRegionName().equals(dimensionMap.get(TpmWarningDimensionEnum.REGION.getCode()))) continue;
                hasEquals = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)receivingObject.getCustomerRetailerCode())) {
                if (!receivingObject.getCustomerRetailerCode().equals(dimensionMap.get(TpmWarningDimensionEnum.SYSTEM.getCode()))) continue;
                hasEquals = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)receivingObject.getCustomerCode())) {
                if (!receivingObject.getCustomerCode().equals(dimensionMap.get(TpmWarningDimensionEnum.CUSTOMER.getCode()))) continue;
                hasEquals = true;
            }
            if (!hasEquals) continue;
            userNameList.add(receivingObject.getUserName());
        }
        return userNameList;
    }

    public String defaultWarningMsg(TpmWarningConfigDto dto, Map<String, Object> objectMap, AbstractTpmWarningMonitoringVariableAndPushGroupRegister variableRegister) {
        long warningDataCount = Long.parseLong(objectMap.get("warning_count").toString());
        List conditionDtoList = dto.getConditionList();
        StringBuilder warningMsgBuilder = new StringBuilder("\u51fa\u73b0");
        warningMsgBuilder.append(warningDataCount).append("\u6761\u5f02\u5e38\uff0c");
        List dimensionCodeKeyList = variableRegister.getDimensionCodeKeyList(dto);
        for (TpmWarningConditionDto tpmWarningConditionDto : conditionDtoList) {
            List conditionWarningDataList;
            List warningDataList = tpmWarningConditionDto.getWarningDataList();
            if (CollectionUtils.isEmpty((Collection)warningDataList) || (conditionWarningDataList = warningDataList.stream().filter(item -> {
                for (String dimensionCodeKey : dimensionCodeKeyList) {
                    if (this.equalsNullDeal(item.get(dimensionCodeKey), objectMap.get(dimensionCodeKey))) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList())).size() <= 0) continue;
            warningMsgBuilder.append(tpmWarningConditionDto.getFormulaName()).append("[").append(conditionWarningDataList.size()).append("]\u6761\uff0c");
        }
        return warningMsgBuilder.toString();
    }

    private boolean equalsNullDeal(Object a, Object b) {
        if (null == a && null == b) {
            return true;
        }
        return null != a && null != b && a.equals(b);
    }
}

