package com.biz.crm.tpm.business.withholding.detail.local.sdk.constant;
import org.apache.commons.lang3.StringUtils;

/**
 * @ClassName TpmWithholdingDetailCategoryEnum
 * @Description
 * @Author: jiangyin
 * @Date 2022/12/19
 */
public enum TpmWithholdingDetailAdjustReasonEnum {

    NOT_APPLY("1", "未申请批复"),
    OVER_LIMIT("2", "超批复执行"),
    PREDICT_FEE_COST("3", "预估扣款"),
    ACTUAL_OVER_PREDICT("4", "实际发生小于批复");

    /**
     * 字典编码
     */
    private String code;

    /**
     * 字典值
     */
    private String name;

    TpmWithholdingDetailAdjustReasonEnum(String code, String name){
        this.code = code;
        this.name = name;
    }

    public static TpmWithholdingDetailAdjustReasonEnum codeToEnum(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (TpmWithholdingDetailAdjustReasonEnum v : values()) {
            if (v.code.equals(code)) {
                return v;
            }
        }
        return null;
    }

    public static TpmWithholdingDetailAdjustReasonEnum nameToEnum(String desc) {
        if (StringUtils.isEmpty(desc)) {
            return null;
        }
        for (TpmWithholdingDetailAdjustReasonEnum v : values()) {
            if (v.name.equals(desc)) {
                return v;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
