package com.biz.crm.tpm.business.withholding.detail.local.sdk.dto;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jdk.nashorn.internal.ir.annotations.Ignore;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @ClassName TpmWithholdingDetailDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/4
 */
@Data
@CrmExcelImport(startRow = 1)
@ApiModel(value = "预提明细数据传输类")
public class TpmWithholdingDetailImportDto extends CrmExcelVo {

    /**
     * 业态
     */
    @CrmExcelColumn(value = "*业态(常温/低温/冰品)", order = 0)
    @ApiModelProperty(value = "业态", notes = "")
    private String businessFormatName;
    /**
     * 业务单元
     */
    @CrmExcelColumn(value = "*业务单元(主体/分子公司/垂直重客/新零售)", order = 1)
    @ApiModelProperty(value = "业务单元", notes = "")
    private String businessUnitName;

    /**
     * 渠道
     */
    @CrmExcelColumn(value = "渠道", order = 1)
    private String channelName;

    /**
     * 渠道编码
     */
    @CrmExcelColumn(value = "*渠道编码", order = 1)
    private String channelCode;
    /**
     * 预提年月
     */
    @CrmExcelColumn(value = "*预提年月", order = 1)
    @ApiModelProperty(value = "预提年月", notes = "")
    private String withholdingYearMonth;
    /**
     * 预提对象
     */
    @CrmExcelColumn(value = "*预提对象", order = 1)
    @ApiModelProperty(value = "预提对象", notes = "")
    private String withholdingTarget;
    /**
     * 业务单元
     */
    @CrmExcelColumn(value = "预提名称", order = 2)
    @ApiModelProperty(value = "预提名称", notes = "")
    private String withholdingName;
    /**
     * 预算科目
     */
    @CrmExcelColumn(value = "*预算科目编码", order = 3)
    @ApiModelProperty(value = "预算科目", notes = "")
    private String budgetSubjectCode;

    /**
     * 销售组织
     */
    @Ignore
    @ApiModelProperty(value = "*销售组织编码", notes = "")
    private String salesOrgCode;

    /**
     * 销售机构
     */
    @CrmExcelColumn(value = "*销售机构编码", order = 4)
    @ApiModelProperty(value = "*销售机构编码", notes = "")
    private String salesInstitutionCode;

    /**
     * 销售部门
     */
    @CrmExcelColumn(value = "销售部门编码", order = 5)
    @ApiModelProperty(value = "销售部门编码", notes = "")
    private String salesRegionCode;

    /**
     * 销售组
     */
    @CrmExcelColumn(value = "销售组编码", order = 6)
    @ApiModelProperty(value = "销售组编码", notes = "")
    private String salesGroupCode;

    /**
     * 组织编码
     */
    @Ignore
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @Ignore
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;
    /**
     * 活动类型
     */
    @CrmExcelColumn(value = "活动类型编码", order = 9)
    @ApiModelProperty(value = "活动类型编码", notes = "")
    private String activityTypeCode;
    /**
     * 活动形式
     */
    @CrmExcelColumn(value = "活动形式编码", order = 10)
    @ApiModelProperty(value = "活动形式编码", notes = "")
    private String activityFormCode;
    /**
     * 客户编码
     */
    @CrmExcelColumn(value = "客户编码", order = 11)
    @ApiModelProperty(value = "客户编码", notes = "")
    private String customerCode;

    /**
     * 产品编码
     */
    @CrmExcelColumn(value = "产品编码", order = 11)
    private String productCode;

//    /**
//     * 客户编码
//     */
//    @CrmExcelColumn(value = "客户名称", order = 7)
//    @ApiModelProperty(value = "客户名称", notes = "")
//    private String customerName;

//    /**
//     * 零售商
//     */
//    @CrmExcelColumn(value = "零售商", order = 8)
//    @ApiModelProperty(value = "零售商", notes = "零售商")
//    private String resaleCommercialName;
    /**
     * 零售商
     */
    @CrmExcelColumn(value = "零售商编码", order = 12)
    @ApiModelProperty(value = "零售商编码", notes = "零售商编码")
    private String resaleCommercialCode;
//    /**
//     * 门店名称
//     */
//    @CrmExcelColumn(value = "门店名称", order = 9)
//    @ApiModelProperty(value = "门店名称", notes = "")
//    private String terminalName;
    /**
     * 门店编码
     */
    @CrmExcelColumn(value = "门店编码", order = 13)
    @ApiModelProperty(value = "门店编码", notes = "")
    private String terminalCode;
//    /**
//     * 供应商名称
//     */
//    @CrmExcelColumn(value = "供应商名称", order = 10)
//    @ApiModelProperty("供应商名称")
//    private String supplierName;
    /**
     * 供应商编码
     */
    @CrmExcelColumn(value = "供应商编码", order = 14)
    @ApiModelProperty("供应商编码")
    private String supplierCode;
    /**
     * 费用所属年月
     */
    @CrmExcelColumn(value = "费用所属年月(下划线“_”分隔)", order = 15)
    @ApiModelProperty(value = "费用所属年月", notes = "")
    private String feeYearMonth;
    /**
     * 预提金额
     */
    @CrmExcelColumn(value = "*预提金额", order = 16)
    @ApiModelProperty(value = "预提金额", notes = "")
    private String withholdingAmountStr;
    /**
     * 备注
     */
    @CrmExcelColumn(value = "备注", order = 17)
    @ApiModelProperty(value = "备注", notes = "")
    private String remark;

    /**
     * 手动预提入参校验
     * @author kingj
     * @date 2022/11/4 17:55
     * @return boolean
     */
    public boolean validate(){
        return StringUtils.isNotEmpty(this.withholdingYearMonth) && StringUtils.isNotEmpty(this.feeYearMonth)
                && StringUtils.isNotEmpty(this.businessFormatName) && StringUtils.isNotEmpty(this.businessUnitName)
                && StringUtils.isNotEmpty(this.channelCode) && StringUtils.isNotEmpty(this.withholdingTarget)
                && StringUtils.isNotEmpty(this.withholdingName)
                && StringUtils.isNotEmpty(this.activityTypeCode) && StringUtils.isNotEmpty(this.activityFormCode)
                && StringUtils.isNotEmpty(this.salesInstitutionCode) && StringUtils.isNotEmpty(this.withholdingAmountStr);
    }
}
