package com.biz.crm.tpm.business.withholding.detail.local.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.dto.*;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailActivityDetailPlanVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailRespVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailSubmitSummaryRespVo;
import com.biz.crm.tpm.business.withholding.detail.local.sdk.vo.TpmWithholdingDetailVerticalSplitDataRespVo;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import java.util.Map;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * (TpmWithholdingDetail)表服务接口
 *
 * @author jiangyin
 * @since 2022-11-04 14:20:28
 */
public interface TpmWithholdingDetailService extends MnPageCacheService<TpmWithholdingDetailRespVo, TpmWithholdingDetailDto> {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    TpmWithholdingDetailRespVo queryById(String id);

    /**
     * 分页查询
     *
     * @param tpmWithholdingDetail 筛选条件
     * @param pageable             分页对象
     * @return 查询结果
     */
    Page<TpmWithholdingDetailRespVo> queryByPage(TpmWithholdingDetailDto tpmWithholdingDetail, Pageable pageable);

    /**
     * 新增数据
     *
     * @param tpmWithholdingDetail 实例对象
     * @return 实例对象
     */
    TpmWithholdingDetailRespVo insert(TpmWithholdingDetailDto tpmWithholdingDetail);

    /**
     * 修改数据
     *
     * @param tpmWithholdingDetail 实例对象
     * @return 实例对象
     */
    TpmWithholdingDetailRespVo update(TpmWithholdingDetailDto tpmWithholdingDetail);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(String id);

    /**
     * 通过主键列表删除数据
     *
     * @param ids 主键列表
     * @return 是否成功
     */
    void deleteByIds(List<String> ids);

    /**
     * 根据唯一键列表启用预提明细
     *
     * @param ids 唯一键列表
     * @return void
     * @author jiangyin
     * @date 2022/11/7 16:53
     */
    void enable(List<String> ids);

    /**
     * 根据唯一键列表禁用预提明细
     *
     * @param ids 唯一键列表
     * @return void
     * @author jiangyin
     * @date 2022/11/7 16:53
     */
    void disable(List<String> ids);

    /**
     * 据唯一键列表直接审批通过预提明细
     *
     * @param ids 唯一键列表
     * @return void
     * @author jiangyin
     * @date 2022/11/7 16:54
     */
    void submitAndSetPass(List<String> ids);

    /**
     * 手动触发系统预提
     *
     * @param dto 请求参数
     * @return java.lang.String
     * @author jiangyin
     * @date 2023/1/2 18:11
     */
    String redoWithholding(TpmWithholdingDetailRedoWithholdingDto dto);

    /**
     * 系统预提
     *
     * @return java.lang.String
     * @author jiangyin
     * @date 2023/1/2 18:12
     */
    String systemWithholding();

    /**
     * 保存预提明细导入数据
     *
     * @param data 导入预提明细数据
     * @author jiangyin
     * @date 2023/1/2 18:12
     */
    Map<Integer, String> saveImport(LinkedHashMap<Integer, TpmWithholdingDetailImportDto> data);

    /**
     * 保存预提明细导入数据
     *
     * @param data 导入预提明细数据
     */
    void saveImport(List<TpmWithholdingDetailDto> data);

    /**
     * 保存预提明细更新导入数据
     *
     * @param data 预提明细更新导入数据
     * @author jiangyin
     * @date 2023/1/2 18:11
     */
    Map<Integer, String> saveRefreshImport(LinkedHashMap<Integer, TpmWithholdingDetailRefreshImportDto> data);

    /**
     * 提交流程接口
     *
     * @param submitDto 流程参数
     * @return void
     * @author jiangyin
     * @date 2023/1/2 18:10
     */
    void submitApproval(TpmWithholdingDetailSubmitDto submitDto);

    /**
     * 保存预提明细列表
     *
     * @param dtoList 预提明细数据传输类列表
     * @return void
     * @author jiangyin
     * @date 2023/1/2 18:10
     */
    void insertList(List<TpmWithholdingDetailDto> dtoList);

    TpmWithholdingDetailSubmitSummaryRespVo summaryForSubmit(List<String> ids);

    void saveFeePoolWithholding(String ds, JSONObject userJsonObject, TpmWithholdingDetailRedoWithholdingDto dto);

    /**
     * 查询预提明细
     *
     * @param detailCode 查询参数
     * @return TpmWithholdingDetailRespVo
     */
    TpmWithholdingDetailRespVo getWithholdingDetailByCode(String detailCode);

    TpmWithholdingDetailSubmitSummaryRespVo summaryForSubmitByProcessNo(String processNo);

    /**
     * 预提明细批量审批查询用
     *
     * @param reqVo
     * @return java.util.List<java.lang.String>
     * @author jiangyin
     * @date 2023/3/1 15:23
     */
    List<String> findIdListByCondition(TpmWithholdingDetailDto reqVo);

    Page<TpmWithholdingDetailRespVo> findDetailPageForSubmit(Pageable pageable, TpmWithholdingDetailDto reqVo);

    TpmWithholdingDetailRespVo findTotalAmountForSubmit(TpmWithholdingDetailDto reqVo);

    void addProtocol(TpmWithholdingDetailProtocolDto dto);

    List<OrdinaryFileVo> findProtocolById(String id);

    /**
     * 批量调整-选择活动细案
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<TpmWithholdingDetailActivityDetailPlanVo> activityPlanPage(Pageable pageable, TpmWithholdingDetailActivityDetailPlanDto dto);

    /**
     * 批量调整-分摊
     *
     * @param dto
     */
    void createSplitData(TpmWithholdingDetailAdjustDto dto);

    /**
     * 批量调整-提交
     *
     * @param dto
     */
    void saveSplitData(TpmWithholdingDetailAdjustDto dto);

    List<TpmWithholdingDetailVerticalSplitDataRespVo> findSplitDataByCostCenterCodeList(List<String> costCenterCodeList, String feeYearMonth);
}
