package com.biz.crm.tpm.business.withholding.detail.local.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName TpmWithholdingDetailRespVo
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/4
 */
@Data
public class TpmWithholdingDetailRespVo extends TenantFlagOpVo {

    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态", notes = "")
    private String processStatus;

    /**
     * 审批流程编码
     */
    @ApiModelProperty(value = "审批流程编码", notes = "")
    private String processNo;

    /**
     * 预提名称
     */
    @ApiModelProperty(value = "预提名称", notes = "")
    private String withholdingName;

    /**
     * 预提类型
     */
    @ApiModelProperty(value = "预提类型", notes = "")
    private String withholdingType;

    /**
     * 预提分类
     */
    @ApiModelProperty(value = "预提分类", notes = "")
    private String withholdingCategory;

    /**
     * 预提对象
     */
    @ApiModelProperty(value = "预提对象", notes = "")
    private String withholdingTarget;

    /**
     * 预提明细编号
     */
    @ApiModelProperty(value = "预提明细编号", notes = "")
    private String withholdingDetailCode;

    /**
     * 预提年月
     */
    @ApiModelProperty(value = "预提年月", notes = "")
    private String withholdingYearMonth;

    /**
     * 费用所属年月
     */
    @ApiModelProperty(value = "费用所属年月", notes = "")
    private String feeYearMonth;
    /**
     * 活动明细编码
     */
    @ApiModelProperty(value = "活动明细编码", notes = "")
    private String activityDetailCode;
    /**
     * 活动名称
     */
    @ApiModelProperty(value = "活动名称", notes = "")
    private String activityName;
    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元", notes = "")
    private String businessUnitCode;
    /**
     * 业态
     */
    @ApiModelProperty(value = "业态", notes = "")
    private String businessFormatCode;
    /**
     * 销售组织
     */
    @ApiModelProperty(value = "销售组织", notes = "")
    private String salesOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    private String salesOrgName;

    /**
     * 组织
     */
    @ApiModelProperty(value = "组织", notes = "")
    private String orgCode;
    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;
    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    private String customerName;
    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码", notes = "")
    private String systemCode;
    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称", notes = "")
    private String systemName;
    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码", notes = "")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称", notes = "")
    private String terminalName;
    /**
     * 是否完全上账
     */
    @ApiModelProperty(value = "是否完全上账", notes = "")
    private String amountStatus;
    /**
     * 已上账金额
     */
    @ApiModelProperty(value = "已上账金额", notes = "")
    private BigDecimal usedAmount;
    /**
     * 活动申请金额
     */
    @ApiModelProperty(value = "活动申请金额", notes = "")
    private BigDecimal activityApplyAmount;
    /**
     * 细案预测金额
     */
    @ApiModelProperty(value = "细案预测金额", notes = "")
    private BigDecimal predictAmount;
    /**
     * 本次预提金额
     */
    @ApiModelProperty(value = "本次预提金额", notes = "")
    private BigDecimal withholdingAmount;
    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额", notes = "")
    private BigDecimal adjustAmount;
    /**
     * 调整后金额
     */
    @ApiModelProperty(value = "调整后金额", notes = "")
    private BigDecimal afterAdjustAmount;

    /**
     * 调整后金额前端用
     */
    @ApiModelProperty(value = "调整后金额前端用", notes = "")
    private String afterAdjustAmountStr;

    /**
     * 支付方式
     */
    @ApiModelProperty(value = "支付方式", notes = "")
    private String payType;
    /**
     * 活动类型
     */
    @ApiModelProperty(value = "活动类型编码", notes = "")
    private String activityTypeCode;
    /**
     * 活动类型
     */
    @ApiModelProperty(value = "活动类型名称", notes = "")
    private String activityTypeName;
    /**
     * 活动形式
     */
    @ApiModelProperty(value = "活动形式编码", notes = "")
    private String activityFormCode;
    /**
     * 活动形式
     */
    @ApiModelProperty(value = "活动形式名称", notes = "")
    private String activityFormName;
    /**
     * 预算科目
     */
    @ApiModelProperty(value = "预算科目", notes = "")
    private String budgetSubjectCode;

    /**
     * 预算科目
     */
    @ApiModelProperty(value = "预算科目", notes = "")
    private String budgetSubjectName;

    /**
     * 活动开始时间
     */
    @ApiModelProperty(value = "活动开始时间", notes = "")
    private Date beginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty(value = "活动结束时间", notes = "")
    private Date endDate;
    /**
     * 是否已汇总
     */
    @ApiModelProperty(value = "是否已汇总", notes = "")
    private String isSummary;
    /**
     * 零售商编码
     */
    @ApiModelProperty(value = "零售商编码", notes = "")
    private String resaleCommercialCode;
    /**
     * 供应商编码
     */
    @ApiModelProperty(value = "供应商编码", notes = "")
    private String supplierCode;
    /**
     * 零售商名称
     */
    @ApiModelProperty(value = "零售商名称", notes = "")
    private String resaleCommercialName;
    /**
     * 供应商名称
     */
    @ApiModelProperty(value = "供应商名称", notes = "")
    private String supplierName;
    /**
     * 汇总编码
     */
    @ApiModelProperty(value = "汇总编码", notes = "")
    private String withholdingDetailSummaryCode;
    /**
     * 自行生成唯一键
     */
    @ApiModelProperty(value = "自行生成唯一键", notes = "")
    private String uniqueMd5Key;
    /**
     * 电商唯一键
     */
    @ApiModelProperty(value = "电商唯一键", notes = "")
    private String uniqueKeyDs;
    /**
     * 客户erp编码
     */
    @ApiModelProperty(value = "客户erp编码", notes = "")
    private String customerErpCode;
    /**
     * 销售组织erp编码
     */
    @ApiModelProperty(value = "销售组织erp编码", notes = "")
    private String salesOrgErpCode;
    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    private String productName;
    /**
     * 结案形式
     */
    @ApiModelProperty(value = "结案形式", notes = "")
    private String auditForm;
    /**
     * 区域
     */
    @ApiModelProperty(value = "区域", notes = "")
    private String region;
    /**
     * 销售组织层级
     */
    @ApiModelProperty(value = "销售组织层级", notes = "")
    private String salesOrgLevel;

    /**
     * 调整原因
     */
    @ApiModelProperty(value = "调整原因", notes = "")
    private String adjustReason;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售大区编码/所属销售部门编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售组编码")
    private String salesGroupCode;

    @ApiModelProperty("附件id列表")
    private String protocolList;

    @ApiModelProperty("分摊形式")
    private String splitType;

    @ApiModelProperty("成本中心")
    private String costCenter;

    @ApiModelProperty("成本中心名称")
    private String costCenterName;

    @ApiModelProperty("垂直-人员数量")
    private BigDecimal quantity;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;
}
