package com.biz.crm.tpm.business.withholding.detail.local.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @ClassName TpmWithholdingDetailSubmitSummaryRespVo
 * @Description
 * @Author: jiangyin
 * @Date 2023/1/5
 */
@Data
@ApiModel(value = "TPM-预提明细提交审批数据统计返回视图类")
public class TpmWithholdingDetailSubmitSummaryRespVo {

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty("销售组织")
    private String salesOrgName;

    @ApiModelProperty("预提年月")
    private String withholdingYearMonth;

    @ApiModelProperty(value = "总部已处理未折扣费用")
    private BigDecimal baseHandledUnDiscountAmount;

    @ApiModelProperty(value = "总部未处理费用")
    private BigDecimal baseUnHandledAmount;

    @ApiModelProperty(value = "总部未兑现费用")
    private BigDecimal baseUnClearAmount;

    @ApiModelProperty(value = "已处理未折扣费用 ")
    private BigDecimal handledUnDiscountAmount;

    @ApiModelProperty(value = "应处理未处理费用")
    private BigDecimal unHandledAmount;

    @ApiModelProperty(value = "分类统计预提金额")
    Map<String, BigDecimal> eachTypeAmountMap;

    @ApiModelProperty(value = "其他费用")
    private BigDecimal otherAmount;

    @ApiModelProperty(value = "未兑现费用")
    private BigDecimal unClearAmount;

    @ApiModelProperty(value = "累计预提金额（剔税）")
    private BigDecimal withholdingAmountSummaryExcludeTax;

    @ApiModelProperty(value = "预提明细-预提对象向上")
    List<TpmWithholdingDetailRespVo> upwardWithholdingDetailList;

    @ApiModelProperty(value = "预提明细-预提对象向下")
    List<TpmWithholdingDetailRespVo> downwardWithholdingDetailList;

    @ApiModelProperty(value = "涉及本次审批的预提明细id列表")
    List<String> idList;

}
