package com.biz.crm.tpm.business.year.budget.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.constant.YearBudgetConstant;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author huojia
 * @date 2022年11月03日 16:16
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = RocketMqUtil.ORDER + "${rocketmq.topic}" + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = YearBudgetConstant.CAL_TASK_POINT_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMqUtil.ORDER + YearBudgetConstant.CAL_TASK_POINT_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY)
public class YearBudgetConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private YearBudgetService yearBudgetService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("=====>    年度预算计算消息接收成功    <=====");
        List<YearBudgetDto> yearBudgetDtoList = JSON.parseArray(message.getMsgBody(), YearBudgetDto.class);
        /*yearBudgetService.calTaskAndPoint(yearBudgetDtoList);*/
        return "消费成功";
    }
}
