package com.biz.crm.tpm.business.year.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月26日 16:21
 */
@ApiModel(value = "YearBudgetDataEntity", description = "TPM-年度预算数据信息")
@TableName("tpm_year_budget_data")
@Getter
@Setter
@Entity(name = "tpm_year_budget_data")
@Table(name = "tpm_year_budget_data", indexes = {@Index(name = "tpm_year_budget_data_index1", columnList = "year_budget_code"),
        @Index(name = "tpm_year_budget_data_index2", columnList = "data_type")})
@org.hibernate.annotations.Table(appliesTo = "tpm_year_budget_data", comment = "TPM-年度预算数据信息")
public class YearBudgetDataEntity extends TenantFlagOpEntity {

    /**
     * 年度预算编码（关联）
     */
    @ApiModelProperty(name = "年度预算编码（关联）", notes = "")
    @Column(name = "year_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度预算编码（关联） '")
    private String yearBudgetCode;

    /**
     * 数据类型（区分行）[数据类型:tpm_line_data_type]
     */
    @ApiModelProperty(name = "数据类型（区分行）[数据类型:tpm_line_data_type]", notes = "")
    @Column(name = "data_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据类型（区分行）[数据类型:tpm_line_data_type] '")
    private String dataType;

    /**
     * 排序
     */
    @ApiModelProperty(name = "排序", notes = "")
    @Column(name = "sort_num", nullable = true, length = 2, columnDefinition = "INT(2) COMMENT '排序 '")
    private Integer sortNum;

    /**
     * 一月份
     */
    @ApiModelProperty("一月份")
    @Column(name = "january_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 一月份 '")
    private BigDecimal januaryNum;

    /**
     * 二月份
     */
    @ApiModelProperty("二月份")
    @Column(name = "february_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 二月份 '")
    private BigDecimal februaryNum;

    /**
     * 三月份
     */
    @ApiModelProperty("三月份")
    @Column(name = "march_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 三月份 '")
    private BigDecimal marchNum;

    /**
     * 四月份
     */
    @ApiModelProperty("四月份")
    @Column(name = "april_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 四月份 '")
    private BigDecimal aprilNum;

    /**
     * 五月份
     */
    @ApiModelProperty("五月份")
    @Column(name = "may_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 五月份 '")
    private BigDecimal mayNum;

    /**
     * 六月份
     */
    @ApiModelProperty("六月份")
    @Column(name = "june_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 六月份 '")
    private BigDecimal juneNum;

    /**
     * 七月份
     */
    @ApiModelProperty("七月份")
    @Column(name = "july_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 七月份 '")
    private BigDecimal julyNum;

    /**
     * 八月份
     */
    @ApiModelProperty("八月份")
    @Column(name = "august_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 八月份 '")
    private BigDecimal augustNum;

    /**
     * 九月份
     */
    @ApiModelProperty("九月份")
    @Column(name = "september_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 九月份 '")
    private BigDecimal septemberNum;

    /**
     * 十月份
     */
    @ApiModelProperty("十月份")
    @Column(name = "october_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 十月份 '")
    private BigDecimal octoberNum;

    /**
     * 十一月份
     */
    @ApiModelProperty("十一月份")
    @Column(name = "november_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 十一月份 '")
    private BigDecimal novemberNum;

    /**
     * 十二月份
     */
    @ApiModelProperty("十二月份")
    @Column(name = "december_num", precision = 20, scale = 6, columnDefinition = "DECIMAL(20,6) COMMENT ' 十二月份 '")
    private BigDecimal decemberNum;
}
