package com.biz.crm.tpm.business.year.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月26日 15:19
 */
@ApiModel(value = "YearBudgetEntity", description = "TPM-年度预算")
@TableName("tpm_year_budget")
@Getter
@Setter
@Entity(name = "tpm_year_budget")
@Table(name = "tpm_year_budget", indexes = {
        @Index(name = "tpm_year_budget_index1", columnList = "year_budget_code"),
        @Index(name = "tpm_year_budget_index2", columnList = "fee_belong_code"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_year_budget", comment = "TPM-年度预算")
public class YearBudgetEntity extends TenantFlagOpEntity {

    /**
     * 年度预算编码
     */
    @ApiModelProperty(name = "年度预算编码", notes = "")
    @Column(name = "year_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度预算编码 '")
    private String yearBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 是否生成已月度预算[数据字典:yesOrNo]
     */
    @ApiModelProperty(name = "是否生成已月度预算[数据字典:yesOrNo]", notes = "")
    @Column(name = "month_budget_flag", nullable = true, length = 4, columnDefinition = "VARCHAR(4) COMMENT '是否生成已月度预算[数据字典:yesOrNo] '")
    private String monthBudgetFlag;

    /**
     * 年份
     */
    @ApiModelProperty(name = "年份", notes = "")
    @Column(name = "year_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年份 '")
    private String yearLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(name = "分组[数据字典:tpm_group_code]", notes = "")
    @Column(name = "group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分组[数据字典:tpm_group_code] '")
    private String groupCode;

    /**
     * 部门编码
     */
    @ApiModelProperty(name = "部门编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '部门编码 '")
    private String orgCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(name = "部门名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '部门名称 '")
    private String orgName;

    /**
     * 部门层级
     */
    @ApiModelProperty(name = "部门层级", notes = "")
    @Column(name = "org_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '部门层级 '")
    private String orgLevelCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(name = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(name = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(name = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    @Column(name = "budget_item_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目层级[数据字典:tpm_budget_item_level] '")
    private String budgetItemLevelCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(name = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String feeBelongCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织ERP编码", notes = "")
    @Column(name = "sales_org_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织ERP编码 '")
    private String salesOrgErpCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(name = "销售组织层级", notes = "")
    @Column(name = "sales_org_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织层级 '")
    private String salesOrgLevelCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码 '")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户渠道名称 '")
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @ApiModelProperty(value = "客户渠道层级", notes = "")
    @Column(name = "customer_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道层级 '")
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    @Column(name = "terminal_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道层级 '")
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    @Column(name = "terminal_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道编码 '")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    @Column(name = "terminal_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店渠道名称 '")
    private String terminalChannelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(name = "系统编码", notes = "")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(name = "系统名称", notes = "")
    @Column(name = "system_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '系统名称 '")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;

    /**
     * 客户ERP编码
     */
    @ApiModelProperty(name = "客户ERP编码", notes = "")
    @Column(name = "customer_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户ERP编码 '")
    private String customerErpCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "门店编码", notes = "")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码 '")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "门店名称", notes = "")
    @Column(name = "terminal_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称 '")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "区域名称", notes = "")
    @Column(name = "region_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '区域名称 '")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(name = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(name = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(name = "品项编码", notes = "")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码 '")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称", notes = "")
    @Column(name = "product_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称 '")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码 '")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称 '")
    private String productName;

    /**
     * 预算计算编码
     */
    @ApiModelProperty(name = "预算计算编码", notes = "")
    @Column(name = "budget_cal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算计算编码 '")
    private String budgetCalCode;

    /**
     * 预算总点数
     */
    @ApiModelProperty(name = "预算总点数", notes = "")
    @Column(name = "budget_total_point", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算总点数 '")
    private BigDecimal budgetTotalPoint;

    /**
     * 年度力度
     */
    @ApiModelProperty(name = "年度力度", notes = "")
    @Column(name = "budget_intensity", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度力度 '")
    private String budgetIntensity;
    /**
     * 年度力度-分子
     */
    @ApiModelProperty(name = "年度力度-分子", notes = "")
    @Column(name = "budget_intensity_numerator", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '年度力度-分子 '")
    private BigDecimal budgetIntensityNumerator;
    /**
     * 年度力度-分母
     */
    @ApiModelProperty(name = "年度力度-分母", notes = "")
    @Column(name = "budget_intensity_denominator", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '年度力度-分母 '")
    private BigDecimal budgetIntensityDenominator;

    /**
     * 预算总金额
     */
    @ApiModelProperty(name = "预算总金额", notes = "")
    @Column(name = "budget_total_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算总金额 '")
    private BigDecimal budgetTotalAmount;

    /**
     * 总目标量
     */
    @ApiModelProperty(name = "总目标量", notes = "")
    @Column(name = "total_goal_quantity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '总目标量 '")
    private BigDecimal totalGoalQuantity;

    /**
     * 策略关联金额
     */
    @ApiModelProperty(name = "策略关联金额", notes = "")
    @Column(name = "strategy_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '策略关联金额 '")
    private BigDecimal strategyAmount;

    /**
     * 剩余可关联金额
     */
    @ApiModelProperty(name = "剩余可关联金额", notes = "")
    @Column(name = "remainder_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '剩余可关联金额 '")
    private BigDecimal remainderAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    @Column(name = "used_strategy_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已使用策略金额 '")
    private BigDecimal usedStrategyAmount;

}
