package com.biz.crm.tpm.business.year.budget.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.year.budget.local.entity.YearBudgetEntity;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetToralPointDto;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetReportVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @author huojia
 * @date 2022年10月26日 16:44
 */
public interface YearBudgetMapper extends BaseMapper<YearBudgetEntity> {

    /**
     * 分页查询数据
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo>
     * @author huojia
     * @date 2022/10/26 17:12
     **/
    Page<YearBudgetVo> findByConditions(Page<YearBudgetVo> page, @Param("dto") YearBudgetDto dto);

    /**
     * 获取维度相同的年度预算数量
     *
     * @param dto 分页参数dto
     * @return Integer
     */
    Integer checkRepeat(@Param("dto") YearBudgetDto dto);

    List<YearBudgetReportVo> findYearBudgetSumVo(@Param("dto")YearBudgetDto queryDto);

    /**
     * 查询年度预算总点数
     *
     * @param pointDto 参数
     * @param pointDto 参数
     * @return List<MonthBudgetVo>
     */
    BigDecimal getYearBudgetTotalPoint(@Param("dto") YearBudgetToralPointDto pointDto, @Param("tenantCode") String tenantCode);

    /**
     * 查询年度预算总点数按组织分组
     *
     * @param pointDto
     * @param tenantCode
     * @return
     */
     List<YearBudgetVo> getYearBudgetTotalPointGroupBySalesOrg(@Param("dto") YearBudgetToralPointDto pointDto, @Param("tenantCode") String tenantCode);

    /**
     * 根据预算项目查年度预算
     * @param yearBudgetCodes
     * @param tenantCode
     * @param delFlag
     * @param enableStatus
     * @return
     */
    List<YearBudgetVo> findYearBudgetByYearBudgetCodes(@Param("yearBudgetCodes") List<String> yearBudgetCodes, @Param("tenantCode") String tenantCode
            , @Param("delFlag") String delFlag, @Param("enableStatus") String enableStatus);

    Page<YearBudgetVo> findPageForOut(@Param("page") Page<YearBudgetVo> page,@Param("dto") YearBudgetDto dto);

    BigDecimal getYearBudgetTotalPointForCustomerGroup(@Param("dto")YearBudgetToralPointDto pointDto,@Param("tenantCode") String tenantCode);

    List<YearBudgetDto> getListByConditions(@Param("dto") YearBudgetDto dto);

    List<YearBudgetVo> findListForFR(@Param("list") List<YearBudgetDto> dtos, @Param("tenantCode") String tenantCode);
}
