package com.biz.crm.tpm.business.year.budget.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.year.budget.sdk.eunm.YearBudgetDataTypeEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author huojia
 * @date 2022年11月07日 17:10
 */
@Component
public class YearBudgetRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_year_budget_data_view";
    }

    @Override
    public String desc() {
        return "TPM-年度预算";
    }

    @Override
    public String buildSql() {
        return "SELECT " +
                " a.id," +
                "a.create_account," +
                "a.terminal_name," +
                "a.product_code," +
                "a.create_time," +
                "a.business_format_code," +
                "a.business_unit_code," +
                "a.budget_item_name," +
                "a.sales_org_level_code," +
                "a.group_code," +
                "a.org_level_code," +
                "a.terminal_channel_level_code," +
                "a.fee_belong_code," +
                "a.system_name," +
                "a.terminal_code," +
                "a.terminal_channel_code," +
                "a.org_name," +
                "a.sales_org_name," +
                "a.customer_channel_name," +
                "a.sales_org_code," +
                "a.sales_org_erp_code," +
                "a.modify_name," +
                "a.month_budget_flag," +
                "a.modify_time," +
                "a.product_name," +
                "a.budget_intensity," +
                "a.customer_name," +
                "a.product_category_name," +
                "a.region_code," +
                "a.year_budget_code," +
                "a.product_brand_name," +
                "a.terminal_channel_name," +
                "a.product_item_name," +
                "a.region_name," +
                "a.remark," +
                "a.budget_item_code," +
                "a.product_brand_code," +
                "a.product_item_code," +
                "a.modify_account," +
                "a.customer_channel_code," +
                "a.budget_item_level_code," +
                "a.tenant_code," +
                "a.system_code," +
                "a.enable_status," +
                "a.product_category_code," +
                "a.year_ly," +
                "a.customer_code," +
                "a.customer_erp_code," +
                "a.customer_channel_level_code," +
                "a.create_name," +
                "a.org_code," +
                "a.budget_cal_code," +
                "a.del_flag," +
                " b.january_num ," +
                " b.february_num," +
                " b.march_num," +
                " b.april_num," +
                " b.may_num," +
                " b.june_num," +
                " b.july_num," +
                " b.august_num," +
                " b.september_num," +
                " b.october_num," +
                " b.november_num," +
                " b.december_num," +
                "TRUNCATE(a.budget_total_point, 2) as budget_total_point," +
                "TRUNCATE(a.budget_intensity_numerator, 2) as budget_intensity_numerator," +
                "TRUNCATE(a.budget_intensity_denominator, 2) as budget_intensity_denominator," +
                "TRUNCATE(a.budget_total_amount, 2) as budget_total_amount," +
                "TRUNCATE(a.total_goal_quantity, 2) as total_goal_quantity," +
                "TRUNCATE(a.used_strategy_amount, 2) as used_strategy_amount," +
                "TRUNCATE(a.strategy_amount, 2) as strategy_amount," +
                "TRUNCATE(a.remainder_amount, 2) as remainder_amount" +
                " FROM" +
                " tpm_year_budget a" +
                " LEFT JOIN tpm_year_budget_data b ON a.year_budget_code = b.year_budget_code " +
                " AND b.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                " AND b.data_type = '" + YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode() + "' " +
                " where a.tenant_code = :tenantCode " +
                " and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
