package com.biz.crm.tpm.business.year.budget.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.YearBudgetEventDto;
import com.biz.crm.tpm.business.year.budget.local.entity.YearBudgetEntity;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetToralPointDto;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetImportsVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetReportVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月26日 16:45
 */
public interface YearBudgetService {

    /**
     * 分页查询数据
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo>
     * @author huojia
     * @date 2022/10/26 17:01
     **/
    Page<YearBudgetVo> findByConditions(Pageable pageable, YearBudgetDto dto);

    /**
     * 根据主键查询数据
     *
     * @param id
     * @param editFlag
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/10/26 17:01
     **/
    YearBudgetVo findById(String id, String editFlag);

    /**
     * 新增
     *
     * @param dto
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/10/26 17:01
     **/
    YearBudgetDto create(YearBudgetDto dto);

    /**
     * 编辑
     *
     * @param dto
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/10/26 17:01
     **/
    YearBudgetVo update(YearBudgetDto dto);

    /**
     * 批量删除
     *
     * @param ids
     * @author huojia
     * @date 2022/10/26 17:01
     **/
    void delete(List<String> ids);

    /**
     * 批量导入新增
     *
     * @param importList
     * @author huojia
     * @date 2022/10/28 14:40
     **/
    void importSave(List<YearBudgetDto> importList);

    /**
     * 计算任务量、预算点数
     *
     * @param yearBudgetDtoList
     * @author huojia
     * @date 2022/11/3 16:48
     **/
    void calTaskAndPoint(List<YearBudgetDto> yearBudgetDtoList);

    /**
     * 手动触发生成月度预算
     *
     * @param ids
     * @author huojia
     * @date 2022/11/4 14:58
     **/
    void manualUpdateMonth(List<String> ids);

    /**
     * 根据年度预算编码获取年度预算（包含明细）
     *
     * @param codes
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo>
     * @author huojia
     * @date 2022/11/10 20:00
     **/
    List<YearBudgetVo> listByCodes(List<String> codes);

    /**
     * 导入测试
     *
     * @param importsVos
     * @author huojia
     * @date 2023/1/2 16:01
     **/
    void importTest(List<YearBudgetImportsVo> importsVos);

    /**
     * 费用归口下拉框
     *
     * @return java.util.List<com.biz.crm.mn.common.base.vo.CommonSelectVo>
     * @author huojia
     * @date 2023/1/2 23:23
     **/
    List<CommonSelectVo> findBelongSelect(String businessFormatCode, String businessUnitCode);

    /**
     * 生成月度预算
     *
     * @param dto
     * @author huojia
     * @date 2023/1/3 0:29
     **/
    void generateMonthBudget(YearBudgetDto dto);

    /**
     * 根据必填项查询出已有的年度预算
     * @param dto
     * @return {@link List}<{@link YearBudgetVo}>
     */
    List<YearBudgetVo> findListByConditions(YearBudgetDto dto);

    /**
     * 根据编码查询年度预算
     * @param yearBudgetCode 年度预算编码
     * @return YearBudgetVo
     */
    YearBudgetVo getBudgetByCode(String yearBudgetCode);

    List<YearBudgetReportVo> findYearBudgetSumVo(YearBudgetDto queryDto);

    List<String> generateMonthBudgetForOut(List<String> ids);

    /**
     * 查询年度预算总点数
     * @param pointDto 参数
     * @return BigDecimal
     */
    BigDecimal getYearBudgetTotalPoint(YearBudgetToralPointDto pointDto);

    List<YearBudgetVo> findYearBudgetByYearBudgetCodes(List<String> yearBudgetCodes);

    Page<YearBudgetVo> findPageForOut(Pageable pageable, YearBudgetDto dto);

    /**
     * 查询年度预算总点数
     * @param pointDto 参数
     * @return BigDecimal
     */
    BigDecimal getYearBudgetTotalPointForCustomerGroup(YearBudgetToralPointDto pointDto);

    void updateOperateBudget(List<YearBudgetEntity> budgetVos);

}
