package com.biz.crm.tpm.business.year.budget.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.BudgetTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalDataFromEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesGoalAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesOrgAreaEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.*;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthConstant;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.eunm.YearSalesTypeEnum;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.year.budget.local.entity.YearBudgetDataEntity;
import com.biz.crm.tpm.business.year.budget.local.entity.YearBudgetEntity;
import com.biz.crm.tpm.business.year.budget.local.mapper.YearBudgetMapper;
import com.biz.crm.tpm.business.year.budget.local.repository.YearBudgetDataRepository;
import com.biz.crm.tpm.business.year.budget.local.repository.YearBudgetRepository;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetService;
import com.biz.crm.tpm.business.year.budget.local.service.process.YearBudgetImportsProcess;
import com.biz.crm.tpm.business.year.budget.sdk.constant.YearBudgetConstant;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDataDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetLogEventDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetToralPointDto;
import com.biz.crm.tpm.business.year.budget.sdk.eunm.FeeSourceEnum;
import com.biz.crm.tpm.business.year.budget.sdk.eunm.YearBudgetDataTypeEnum;
import com.biz.crm.tpm.business.year.budget.sdk.event.YearBudgetLogEventListener;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetDataVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetImportsVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetReportVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月26日 16:45
 */
@Slf4j
@Service
public class YearBudgetServiceImpl implements YearBudgetService {

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private YearBudgetMapper yearBudgetMapper;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private TransactionTemplate transactionTemplate;

    @Autowired(required = false)
    private YearBudgetRepository yearBudgetRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private BudgetCalConfigService budgetCalConfigService;

    @Autowired(required = false)
    private YearBudgetDataRepository yearBudgetDataRepository;

    @Autowired(required = false)
    private YearBudgetImportsProcess yearBudgetImportsProcess;

    @Autowired(required = false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;


    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    /**
     * 分页查询年度预算
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo>
     * @author huojia
     * @date 2022/11/1 21:14
     **/
    @Override
    public Page<YearBudgetVo> findByConditions(Pageable pageable, YearBudgetDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new YearBudgetDto();
        }
        Page<YearBudgetVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<YearBudgetVo> yearBudgetVoPage = this.yearBudgetMapper.findByConditions(page, dto);
        if (CollectionUtils.isEmpty(yearBudgetVoPage.getRecords())) {
            return yearBudgetVoPage;
        }
        convertBudgetProperty(yearBudgetVoPage.getRecords());
        List<String> yearBudgetCodeList = yearBudgetVoPage.getRecords().stream().map(YearBudgetVo::getYearBudgetCode).collect(Collectors.toList());
        // 查询年度预算对应（预算金额）数据信息
        List<YearBudgetDataEntity> dataList = yearBudgetDataRepository.listByYearBudgetCodes(yearBudgetCodeList, Lists.newArrayList(YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode()));
        if (!CollectionUtils.isEmpty(dataList)) {
            Map<String, YearBudgetDataEntity> dataMap = dataList.stream().collect(Collectors.toMap(YearBudgetDataEntity::getYearBudgetCode, Function.identity()));
            yearBudgetVoPage.getRecords().forEach(record -> {
                if (dataMap.containsKey(record.getId())) {
                    BeanUtils.copyProperties(dataMap.get(record.getId()), record);
                }
            });
        }
        return yearBudgetVoPage;
    }


    /**
     * 转换字段
     */
    public void convertBudgetProperty(List<YearBudgetVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, String> feeSourceMap = Maps.newHashMap();
        if (null != dictDataVoService) {
            try {
                List<DictDataVo> feeSourceList = dictDataVoService.findByDictTypeCode(YearBudgetConstant.DICT_TPM_FEE_BELONG_VERTICAL);
                if (!CollectionUtils.isEmpty(feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            } catch (Exception e) {
                log.error("费用归口数据字典查询失败：" + e.getMessage());
            }
        }
        for (YearBudgetVo vo : list) {
            //费用来源转换
            if (StringUtils.isNotEmpty(vo.getFeeBelongCode())) {
                vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
            }
        }
    }

    /**
     * 根据主键、是否编辑页面标记查询年度预算
     *
     * @param id
     * @param editFlag 标识是否为编辑页面（Y：是，N：否）
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/11/1 21:14
     **/
    @Override
    public YearBudgetVo findById(String id, String editFlag) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        YearBudgetEntity yearBudgetEntity = this.yearBudgetRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull(yearBudgetEntity, "当前数据不存在，请刷新后重试！");
        List<String> codes = Lists.newArrayList(yearBudgetEntity.getYearBudgetCode());
        // 查询对应数据，按规定排序
        List<String> dataTypeList = new ArrayList<>();
        if (BooleanEnum.TRUE.getCapital().equals(editFlag)) {
            dataTypeList = YearBudgetDataTypeEnum.concertEnumToEditList();
        }
        List<YearBudgetDataEntity> yearBudgetDataEntities = this.yearBudgetDataRepository.listByYearBudgetCodes(codes, dataTypeList);
        YearBudgetVo yearBudgetVo = this.nebulaToolkitService.copyObjectByBlankList(yearBudgetEntity, YearBudgetVo.class, LinkedHashSet.class, ArrayList.class);
        if (CollectionUtils.isEmpty(yearBudgetDataEntities)) {
            return yearBudgetVo;
        }
        Collection<YearBudgetDataVo> dataVos = this.nebulaToolkitService.copyCollectionByBlankList(yearBudgetDataEntities, YearBudgetDataEntity.class, YearBudgetDataVo.class, LinkedHashSet.class, ArrayList.class);
        yearBudgetVo.setDataVos(new ArrayList<>(dataVos));
        return yearBudgetVo;
    }

    /**
     * 新增年度预算
     *
     * @param dto
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/11/1 21:15
     **/
    @Override
    public YearBudgetDto create(YearBudgetDto dto) {
        // 根据配置校验必填字段
        this.createValidate(dto);

        List<YearBudgetDto> yearBudgetDtoList = Lists.newArrayList(dto);
        this.calTaskAndPoint(yearBudgetDtoList);
        YearBudgetDto yearBudgetDto = yearBudgetDtoList.get(0);

        // 保存年度预算
        YearBudgetEntity yearBudgetEntity = this.nebulaToolkitService.copyObjectByWhiteList(yearBudgetDto, YearBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
        this.yearBudgetRepository.saveOrUpdate(yearBudgetEntity);
        yearBudgetDto.setId(yearBudgetEntity.getId());
        // 根据数据类型进行排序
        Map<String, Integer> dataTypeMap = YearBudgetDataTypeEnum.concertEnumToMap();
        List<YearBudgetDataDto> dataVos = yearBudgetDto.getDataVos();
        dataVos.forEach(dataVo -> {
            if (dataTypeMap.containsKey(dataVo.getDataType())) {
                dataVo.setSortNum(dataTypeMap.get(dataVo.getDataType()));
            }
        });
        // 新增数据明细
        List<YearBudgetDataEntity> yearBudgetDataEntities = (List<YearBudgetDataEntity>) this.nebulaToolkitService.copyCollectionByBlankList(
                dataVos, YearBudgetDataDto.class, YearBudgetDataEntity.class, LinkedHashSet.class, ArrayList.class
        );
        this.yearBudgetDataRepository.saveBatch(yearBudgetDataEntities);

        // 业务日志新增
        YearBudgetLogEventDto logEventDto = new YearBudgetLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(yearBudgetDto);
        SerializableBiConsumer<YearBudgetLogEventListener, YearBudgetLogEventDto> onCreate =
                YearBudgetLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, YearBudgetLogEventListener.class, onCreate);
        return yearBudgetDto;
    }

    /**
     * 异步计算任务量、预算点数
     * <p>
     * 新增、导入、手动更新 才去会触发该方法，编辑则不触发
     * <p>
     * 手动更新则不管年度预算中是否存在[预算点数、任务量]都去重新更新年度预算、月度预算中的[预算点数、任务量]，新增、导入需要考虑是否已经存在[预算点数、任务量]，存在的则不再更新
     *
     * @param yearBudgetDtoList
     * @param manualFlag
     * @author huojia
     * @date 2022/11/3 15:35
     **/
    private void asyncCalTaskAndPoint(List<YearBudgetDto> yearBudgetDtoList, String manualFlag) {
        List<YearBudgetDto> asyncList = new ArrayList<>();
        // 不存在预算点数、任务量才跑数据，手动触发则不考虑
        //if (BooleanEnum.TRUE.getCapital().equals(manualFlag)) {
        asyncList.addAll(yearBudgetDtoList);
        /*} else {
            yearBudgetDtoList.forEach(yearBudgetDto -> {
                List<YearBudgetDataDto> collect = yearBudgetDto.getDataVos().stream()
                        .filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_POINT.getCode().equals(dataVo.getDataType())
                                && YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode().equals(dataVo.getDataType()))
                        .collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    asyncList.add(yearBudgetDto);
                }
            });
        }*/
        // 每次发送50条，避免超过mq消息体大小
        while (asyncList.size() > 0) {
            int removeSize = Math.min(asyncList.size(), 50);
            List<YearBudgetDto> removeList = asyncList.subList(0, removeSize);
            // 发送MQ消息
            MqMessageVo mqMessage = new MqMessageVo();
            //数据
            mqMessage.setMsgBody(JSON.toJSONString(removeList));
            //MQ标签
            mqMessage.setTag(YearBudgetConstant.CAL_TASK_POINT_TAG);
            rocketMqProducer.sendMqMsg(mqMessage);
            //截断
            asyncList.removeAll(removeList);
        }
    }

    /**
     * 根据年度预算生成对应12个月的月度预算
     *
     * @param dtoList
     * @author huojia
     * @date 2022/11/3 13:58
     **/
    @Transactional(rollbackFor = Exception.class)
    void buildMonthBudget(List<YearBudgetDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<String> monthList = MonthEnum.concertEnumToList();
        List<MonthBudgetDto> monthBudgetDtoList = new ArrayList<>();
//        String ruleCode = StringUtils.join(MonthBudgetConstant.MONTH_BUDGET_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        List<String> monthCodeList = generateCodeService.generateCode(MonthBudgetConstant.MONTH_BUDGET_CODE, dtoList.size() * 12, 8, 2, TimeUnit.DAYS);
        Iterator<String> iterator = monthCodeList.iterator();
        dtoList.forEach(yearDto -> {
            // 获取预算金额、预算点数
            List<YearBudgetDataDto> budgetAmountList = yearDto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
            List<YearBudgetDataDto> budgetPointList = yearDto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_POINT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
            List<YearBudgetDataDto> goalQuantityList = yearDto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
            log.info("budgetAmountList：{}", JSONObject.toJSONString(budgetAmountList));
            log.info("budgetPointList：{}", JSONObject.toJSONString(budgetPointList));
            log.info("goalQuantityList：{}", JSONObject.toJSONString(goalQuantityList));
            // 构建每个月的月度预算明细
            monthList.forEach(month -> {
                MonthBudgetDto monthBudgetDto = nebulaToolkitService.copyObjectByWhiteList(yearDto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
                monthBudgetDto.setId(null);
                monthBudgetDto.setMonthBudgetCode(iterator.next());
                monthBudgetDto.setYearMonthLy(yearDto.getYearLy() + "-" + month);
                monthBudgetDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                monthBudgetDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                monthBudgetDto.setTenantCode(TenantUtils.getTenantCode());
                monthBudgetDto.setBudgetIntensityDenominator(yearDto.getBudgetIntensityDenominator());
                //力度
                String budgetIntensity = yearDto.getBudgetIntensity();
                if(org.springframework.util.StringUtils.hasText(budgetIntensity)){
                    String[] budgetIntensityArray = budgetIntensity.split("/");
                    if (budgetIntensityArray.length >= 2) {
                        monthBudgetDto.setBudgetIntensityNumerator(new BigDecimal(budgetIntensityArray[0]));
                        monthBudgetDto.setBudgetIntensityDenominator(new BigDecimal(budgetIntensityArray[1]));
                    }
                }

                // 设置年初分解金额、预算点数
                switch (month) {
                    case MonthConstant.JANUARY:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getJanuaryNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJanuaryNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getJanuaryNum());
                        }
                        break;
                    case MonthConstant.FEBRUARY:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getFebruaryNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getFebruaryNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getFebruaryNum());
                        }
                        break;
                    case MonthConstant.MARCH:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getMarchNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getMarchNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getMarchNum());
                        }
                        break;
                    case MonthConstant.APRIL:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getAprilNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getAprilNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getAprilNum());
                        }
                        break;
                    case MonthConstant.MAY:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getMayNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getMayNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getMayNum());
                        }
                        break;
                    case MonthConstant.JUNE:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getJuneNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJuneNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getJuneNum());
                        }
                        break;
                    case MonthConstant.JULY:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getJulyNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJulyNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getJulyNum());
                        }
                        break;
                    case MonthConstant.AUGUST:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getAugustNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getAugustNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getAugustNum());
                        }
                        break;
                    case MonthConstant.SEPTEMBER:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getSeptemberNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getSeptemberNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getSeptemberNum());
                        }
                        break;
                    case MonthConstant.OCTOBER:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getOctoberNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getOctoberNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getOctoberNum());
                        }
                        break;
                    case MonthConstant.NOVEMBER:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getNovemberNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getNovemberNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getNovemberNum());
                        }
                        break;
                    case MonthConstant.DECEMBER:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getDecemberNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getDecemberNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getDecemberNum());
                        }
                        break;
                    default:
                        break;
                }
                monthBudgetDto.setAccumulatedAvailableBalance(monthBudgetDto.getInitResolveAmount());
                monthBudgetDto.setAfterFreezeAmount(monthBudgetDto.getInitResolveAmount());
                if (!BusinessUnitEnum.VERTICAL.getCode().equals(yearDto.getBusinessUnitCode())
                        && !BusinessUnitEnum.ONLINE.getCode().equals(yearDto.getBusinessUnitCode())) {
                    monthBudgetDto.setBudgetTotalPoint(yearDto.getBudgetTotalPoint());
                }
                monthBudgetDtoList.add(monthBudgetDto);
            });
        });
        log.info("monthBudgetDtoList {}", JSONObject.toJSONString(monthBudgetDtoList));
        monthBudgetService.saveBatch(monthBudgetDtoList);
        List<String> ids = dtoList.stream().map(UuidDto::getId).collect(Collectors.toList());
        List<YearBudgetEntity> yearBudgetEntities = yearBudgetRepository.listByIds(ids);
        yearBudgetEntities.forEach(yearBudgetEntity -> {
            yearBudgetEntity.setMonthBudgetFlag(BooleanEnum.TRUE.getCapital());
        });
        yearBudgetRepository.updateBatchById(yearBudgetEntities);
    }

    /**
     * 根据年度预算生成对应12个月的月度预算-能力中心
     *
     * @param dtoList
     * @author huojia
     * @date 2022/11/3 13:58
     **/
    @Transactional(rollbackFor = Exception.class)
    public List<String> buildMonthBudgetForOut(List<YearBudgetDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return null;
        }
        List<String> monthBudgetIdList;
        List<String> monthList = MonthEnum.concertEnumToList();
        List<MonthBudgetDto> monthBudgetDtoList = new ArrayList<>();
        String ruleCode = StringUtils.join(MonthBudgetConstant.MONTH_BUDGET_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        List<String> monthCodeList = generateCodeService.generateCode(ruleCode, dtoList.size() * 12, 8, 2, TimeUnit.DAYS);
        Iterator<String> iterator = monthCodeList.iterator();
        dtoList.forEach(yearDto -> {
            // 获取预算金额、预算点数
            List<YearBudgetDataDto> budgetAmountList = yearDto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
            List<YearBudgetDataDto> budgetPointList = yearDto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_POINT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
            List<YearBudgetDataDto> goalQuantityList = yearDto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
            // 构建每个月的月度预算明细
            monthList.forEach(month -> {
                MonthBudgetDto monthBudgetDto = nebulaToolkitService.copyObjectByWhiteList(yearDto, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
                monthBudgetDto.setId(null);
                monthBudgetDto.setMonthBudgetCode(iterator.next());
                monthBudgetDto.setYearMonthLy(yearDto.getYearLy() + "-" + month);
                monthBudgetDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                monthBudgetDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                monthBudgetDto.setTenantCode(TenantUtils.getTenantCode());

                // 设置年初分解金额、预算点数
                switch (month) {
                    case MonthConstant.JANUARY:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getJanuaryNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJanuaryNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getJanuaryNum());
                        }
                        break;
                    case MonthConstant.FEBRUARY:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getFebruaryNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getFebruaryNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getFebruaryNum());
                        }
                        break;
                    case MonthConstant.MARCH:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getMarchNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getMarchNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getMarchNum());
                        }
                        break;
                    case MonthConstant.APRIL:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getAprilNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getAprilNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getAprilNum());
                        }
                        break;
                    case MonthConstant.MAY:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getMayNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getMayNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getMayNum());
                        }
                        break;
                    case MonthConstant.JUNE:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getJuneNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJuneNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getJuneNum());
                        }
                        break;
                    case MonthConstant.JULY:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getJulyNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJulyNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getJulyNum());
                        }
                        break;
                    case MonthConstant.AUGUST:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getAugustNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getAugustNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getAugustNum());
                        }
                        break;
                    case MonthConstant.SEPTEMBER:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getSeptemberNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getSeptemberNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getSeptemberNum());
                        }
                        break;
                    case MonthConstant.OCTOBER:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getOctoberNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getOctoberNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getOctoberNum());
                        }
                        break;
                    case MonthConstant.NOVEMBER:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getNovemberNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getNovemberNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getNovemberNum());
                        }
                        break;
                    case MonthConstant.DECEMBER:
                        if (!CollectionUtils.isEmpty(budgetAmountList)) {
                            monthBudgetDto.setInitResolveAmount(budgetAmountList.get(0).getDecemberNum());
                        }
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getDecemberNum());
                        }
                        if (!CollectionUtils.isEmpty(goalQuantityList)) {
                            monthBudgetDto.setTotalGoalQuantity(goalQuantityList.get(0).getDecemberNum());
                        }
                        break;
                    default:
                        break;
                }
                monthBudgetDto.setAccumulatedAvailableBalance(monthBudgetDto.getInitResolveAmount());
                monthBudgetDto.setAfterFreezeAmount(monthBudgetDto.getInitResolveAmount());
                if (!BusinessUnitEnum.VERTICAL.getCode().equals(yearDto.getBusinessUnitCode())) {
                    monthBudgetDto.setBudgetTotalPoint(yearDto.getBudgetTotalPoint());
                }
                monthBudgetDtoList.add(monthBudgetDto);
            });
        });
        monthBudgetIdList = monthBudgetService.saveBatchForOut(monthBudgetDtoList);
        List<String> ids = dtoList.stream().map(UuidDto::getId).collect(Collectors.toList());
        List<YearBudgetEntity> yearBudgetEntities = yearBudgetRepository.listByIds(ids);
        yearBudgetEntities.forEach(yearBudgetEntity -> {
            yearBudgetEntity.setMonthBudgetFlag(BooleanEnum.TRUE.getCapital());
        });
        yearBudgetRepository.updateBatchById(yearBudgetEntities);
        return monthBudgetIdList;
    }

    /**
     * 创建校验
     *
     * @param dto
     * @author huojia
     * @date 2022/10/26 20:35
     **/
    private void createValidate(YearBudgetDto dto) {
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
//        String ruleCode = StringUtils.join(YearBudgetConstant.YEAR_BUDGET_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        dto.setYearBudgetCode(generateCodeService.generateCode(YearBudgetConstant.YEAR_BUDGET_CODE, 1, 8, 2, TimeUnit.DAYS).get(0));
        dto.setMonthBudgetFlag(BooleanEnum.FALSE.getCapital());
        if (CollectionUtils.isEmpty(dto.getDataVos())) {
            throw new RuntimeException("数据信息不能为空！");
        }
        Validate.notEmpty(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notEmpty(dto.getBusinessUnitCode(), "业务单元不能为空！");
        Validate.notEmpty(dto.getYearLy(), "年份不能为空！");
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            Validate.notEmpty(dto.getOrgCode(), "部门编码不能为空！");
            Validate.notEmpty(dto.getOrgName(), "部门名称不能为空！");
            Validate.notEmpty(dto.getOrgLevelCode(), "部门层级不能为空！");
        }
        Validate.notEmpty(dto.getBudgetItemCode(), "预算项目编码不能为空！");
        Validate.notEmpty(dto.getBudgetItemName(), "预算项目名称不能为空！");
        Validate.notEmpty(dto.getBudgetItemLevelCode(), "预算项目层级不能为空！");

        // 根据维度校验字段
        /*DimensionInformationQueryData dimensionVo = new DimensionInformationQueryData();
        dimensionVo.setBusinessState(dto.getBusinessFormatCode());
        dimensionVo.setBusinessUnit(dto.getBusinessUnitCode());
        dimensionVo.setMenu(MenuCodeEnum.YEAR_BUDGET.getCode());
        dimensionVo.setSalesOrgCodeList(Arrays.asList(dto.getSalesOrgCode()));
        List<DimensionDimensionInformationVo> dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dimensionVo);*/
        /*if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new RuntimeException("未维护对应维度配置数据，请检查！");
        }
        Class<YearBudgetDto> clazz = YearBudgetDto.class;
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(dto);
                if (ObjectUtils.isEmpty(o)) {
                    throw new RuntimeException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new RuntimeException(e.getMessage());
            }
        });*/
        // 校验明细
        dto.getDataVos().forEach(yearBudgetDataDto -> {
            Validate.notBlank(yearBudgetDataDto.getDataType(), "数据信息类型不能为空！");
            yearBudgetDataDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            yearBudgetDataDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            yearBudgetDataDto.setYearBudgetCode(dto.getYearBudgetCode());
            yearBudgetDataDto.setTenantCode(TenantUtils.getTenantCode());

            if (YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode().equals(yearBudgetDataDto.getDataType())) {
                if (yearBudgetDataDto.getJanuaryNum() == null
                        || yearBudgetDataDto.getFebruaryNum() == null
                        || yearBudgetDataDto.getMarchNum() == null
                        || yearBudgetDataDto.getAprilNum() == null
                        || yearBudgetDataDto.getMayNum() == null
                        || yearBudgetDataDto.getJuneNum() == null
                        || yearBudgetDataDto.getJulyNum() == null
                        || yearBudgetDataDto.getAugustNum() == null
                        || yearBudgetDataDto.getSeptemberNum() == null
                        || yearBudgetDataDto.getOctoberNum() == null
                        || yearBudgetDataDto.getNovemberNum() == null
                        || yearBudgetDataDto.getDecemberNum() == null) {
                    throw new RuntimeException("12个月份的预算金额均不能为空！");
                }
            }
        });
    }

    /**
     * 编辑年度预算
     *
     * @param dto
     * @return com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo
     * @author huojia
     * @date 2022/11/1 21:15
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public YearBudgetVo update(YearBudgetDto dto) {
        // 根据配置校验必填字段
        this.updateValidate(dto);
        YearBudgetVo yearBudgetVo = this.findById(dto.getId(), BooleanEnum.TRUE.getCapital());
        if (ObjectUtils.isEmpty(yearBudgetVo)) {
            throw new RuntimeException("修改数据失败，原数据不存在！");
        }
        //年度预算验重
        int count = this.yearBudgetRepository.checkRepeat(dto);
        Validate.isTrue(count == 0, "已存在此维度的年度预算，请勿重复添加");

        List<MonthBudgetVo> oldMonthList = monthBudgetService.listByYearBudgetCode(yearBudgetVo.getYearBudgetCode());
        if (!CollectionUtils.isEmpty(oldMonthList)) {
            throw new RuntimeException("修改数据失败，当前年度预算已生成对应月度预算！");
        }
        YearBudgetDto oldDto = this.nebulaToolkitService.copyObjectByWhiteList(yearBudgetVo, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class);

        // 计算年度预算点数
        List<YearBudgetDto> yearBudgetDtoList = Lists.newArrayList(dto);
        this.calTaskAndPoint(yearBudgetDtoList);
        YearBudgetDto yearBudgetDto = yearBudgetDtoList.get(0);

        // 保存年度预算
        YearBudgetEntity yearBudgetEntity = this.nebulaToolkitService.copyObjectByWhiteList(yearBudgetDto, YearBudgetEntity.class, LinkedHashSet.class, ArrayList.class);

        this.yearBudgetRepository.updateById(yearBudgetEntity);
        yearBudgetDto.setId(yearBudgetEntity.getId());
        List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.listByYearBudgetCode(yearBudgetEntity.getYearBudgetCode());
        if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
            monthBudgetVoList.forEach(monthBudgetVo -> {
                monthBudgetVo.setBudgetTotalPoint(yearBudgetEntity.getBudgetTotalPoint());
            });
            List<MonthBudgetDto> monthBudgetDtoList = (List<MonthBudgetDto>) this.nebulaToolkitService.copyCollectionByWhiteList(
                    monthBudgetVoList, MonthBudgetVo.class, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class
            );
            monthBudgetService.updateBatch(monthBudgetDtoList);
        }
        // 根据数据类型进行排序
        Map<String, Integer> dataTypeMap = YearBudgetDataTypeEnum.concertEnumToMap();
        List<YearBudgetDataDto> dataVos = yearBudgetDto.getDataVos();
        dataVos.forEach(dataVo -> {
            dataVo.setYearBudgetCode(yearBudgetVo.getYearBudgetCode());
            if (dataTypeMap.containsKey(dataVo.getDataType())) {
                dataVo.setSortNum(dataTypeMap.get(dataVo.getDataType()));
            }
        });
        // 明细
        List<String> yearBudgetCodeList = Lists.newArrayList(yearBudgetVo.getYearBudgetCode());
        List<YearBudgetDataEntity> oldDataEntityList = this.yearBudgetDataRepository.listByYearBudgetCodes(yearBudgetCodeList, YearBudgetDataTypeEnum.concertEnumToEditList());
        Collection<YearBudgetDataDto> yearBudgetDataDtoList = this.nebulaToolkitService.copyCollectionByBlankList(oldDataEntityList, YearBudgetDataEntity.class, YearBudgetDataDto.class, LinkedHashSet.class, ArrayList.class);
        oldDto.setDataVos(new ArrayList<>(yearBudgetDataDtoList));
        // 新增数据明细
        this.yearBudgetDataRepository.deleteByYearBudgetCode(yearBudgetVo.getYearBudgetCode());
        Collection<YearBudgetDataEntity> yearBudgetDataEntities = this.nebulaToolkitService.copyCollectionByBlankList(dataVos, YearBudgetDataDto.class, YearBudgetDataEntity.class, LinkedHashSet.class, ArrayList.class);
        this.yearBudgetDataRepository.saveBatch(yearBudgetDataEntities);
        // 业务日志编辑
        YearBudgetLogEventDto logEventDto = new YearBudgetLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<YearBudgetLogEventListener, YearBudgetLogEventDto> onUpdate =
                YearBudgetLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, YearBudgetLogEventListener.class, onUpdate);
        return this.nebulaToolkitService.copyObjectByWhiteList(dto, YearBudgetVo.class, LinkedHashSet.class, ArrayList.class);

        /*boolean lock = true;
        try {
            if (!CollectionUtils.isEmpty(monthBudgetCodeList)) {
                lock = monthBudgetLockService.lock(monthBudgetCodeList, TimeUnit.MILLISECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME);
            }
            // 生成月度预算
            this.buildMonthBudget(Lists.newArrayList(dto));
        } finally {
            if (!CollectionUtils.isEmpty(monthBudgetCodeList) && lock) {
                monthBudgetLockService.unLock(monthBudgetCodeList);
            }
        }*/
    }

    /**
     * 编辑校验
     *
     * @param dto
     * @author huojia
     * @date 2022/10/26 20:35
     **/
    private void updateValidate(YearBudgetDto dto) {
        // 根据维度校验字段
        DimensionInformationQueryData dimensionVo = new DimensionInformationQueryData();
        dimensionVo.setBusinessFormatCode(dto.getBusinessFormatCode());
        dimensionVo.setBusinessUnitCode(dto.getBusinessUnitCode());
        dimensionVo.setMenu(MenuCodeEnum.YEAR_BUDGET.getCode());
        dimensionVo.setSalesOrgCodeList(Arrays.asList(dto.getSalesOrgCode()));

        Validate.notEmpty(dto.getId(), "id不能为空！");
        Validate.notEmpty(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notEmpty(dto.getBusinessUnitCode(), "业务单元不能为空！");
        Validate.notEmpty(dto.getYearLy(), "年份不能为空！");
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            Validate.notEmpty(dto.getOrgCode(), "部门编码不能为空！");
            Validate.notEmpty(dto.getOrgName(), "部门名称不能为空！");
            Validate.notEmpty(dto.getOrgLevelCode(), "部门层级不能为空！");
        }
        Validate.notEmpty(dto.getBudgetItemCode(), "预算项目编码不能为空！");
        Validate.notEmpty(dto.getBudgetItemName(), "预算项目名称不能为空！");
        Validate.notEmpty(dto.getBudgetItemLevelCode(), "预算项目层级不能为空！");

        /*List<DimensionDimensionInformationVo> dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dimensionVo);
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new RuntimeException("未维护对应维度配置数据，请检查！");
        }
        Class<YearBudgetDto> clazz = YearBudgetDto.class;
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(dto);
                if (ObjectUtils.isEmpty(o)) {
                    throw new RuntimeException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new RuntimeException(e.getMessage());
            }
        });*/
        if (CollectionUtils.isEmpty(dto.getDataVos())) {
            throw new RuntimeException("数据信息不能为空！");
        }
        // 校验明细
        dto.getDataVos().forEach(yearBudgetDataDto -> {
            Validate.notBlank(yearBudgetDataDto.getDataType(), "数据信息类型不能为空！");
            yearBudgetDataDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            yearBudgetDataDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            yearBudgetDataDto.setYearBudgetCode(dto.getYearBudgetCode());
            yearBudgetDataDto.setTenantCode(TenantUtils.getTenantCode());
            yearBudgetDataDto.setId(null);
        });
    }

    /**
     * 批量删除
     *
     * @param ids
     * @author huojia
     * @date 2022/11/1 21:15
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("请选择要删除的数据！");
        }
        List<YearBudgetEntity> yearBudgetEntities = this.yearBudgetRepository.listByIds(ids);
        if (CollectionUtils.isEmpty(yearBudgetEntities)) {
            throw new RuntimeException("年度预算不存在，请检查！");
        }
        List<String> yearBudgetCodeList = yearBudgetEntities.stream().map(YearBudgetEntity::getYearBudgetCode).collect(Collectors.toList());
        List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.listByYearBudgetCodes(yearBudgetCodeList);
        if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
            Set<String> collect = monthBudgetVoList.stream().map(MonthBudgetVo::getYearBudgetCode).collect(Collectors.toSet());
            throw new RuntimeException("年度预算" + String.join(",", collect) + "已生成对应月度预算，无法删除！");
        }
        // TODO:未关联任何策略的年度预算才可进行删除
        yearBudgetEntities.forEach(yearBudgetEntity -> {
            yearBudgetEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.yearBudgetRepository.updateBatchById(yearBudgetEntities);
        yearBudgetCodeList.forEach(yearBudgetCode -> {
            this.yearBudgetDataRepository.deleteByYearBudgetCode(yearBudgetCode);
        });
        yearBudgetEntities.forEach(yearBudgetEntity -> {
            YearBudgetLogEventDto logEventDto = new YearBudgetLogEventDto();
            logEventDto.setOriginal(this.nebulaToolkitService.copyObjectByWhiteList(yearBudgetEntity, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class));
            logEventDto.setNewest(null);
            SerializableBiConsumer<YearBudgetLogEventListener, YearBudgetLogEventDto> onDelete =
                    YearBudgetLogEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, YearBudgetLogEventListener.class, onDelete);
        });
    }

    /**
     * 批量导入新增
     *
     * @param importList
     * @author huojia
     * @date 2022/11/1 21:15
     **/
    @Override
    public void importSave(List<YearBudgetDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        List<YearBudgetDataDto> dataVos = new ArrayList<>();
//        String ruleCode = StringUtils.join(YearBudgetConstant.YEAR_BUDGET_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        List<String> codeList = generateCodeService.generateCode(YearBudgetConstant.YEAR_BUDGET_CODE, importList.size(), 8, 2, TimeUnit.DAYS);
        AtomicInteger index = new AtomicInteger(0);
//        importList.forEach(importVo -> {
//            //非电商导入 追加 预算点数
//            if(!BusinessUnitEnum.ONLINE.getCode().equals(importVo.getBusinessUnitCode())){
//                YearBudgetDataDto yearBudgetDataDto = new YearBudgetDataDto();
//                yearBudgetDataDto.setDataType(YearBudgetDataTypeEnum.BUDGET_POINT.getCode());
//                importVo.getDataVos().add(yearBudgetDataDto);
//            }
//        });
        this.calTaskAndPoint(importList);
        importList.forEach(dto -> {
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setYearBudgetCode(codeList.get(index.getAndIncrement()));
            dto.setMonthBudgetFlag(BooleanEnum.FALSE.getCapital());
            dto.getDataVos().forEach(dataDto -> {
                dataDto.setYearBudgetCode(dto.getYearBudgetCode());
                dataDto.setTenantCode(TenantUtils.getTenantCode());
                dataDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dataVos.add(dataDto);
            });
        });
        this.saveBatch(importList, dataVos);
        // 业务日志新增
        importList.forEach(dto -> {
            YearBudgetLogEventDto logEventDto = new YearBudgetLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer<YearBudgetLogEventListener, YearBudgetLogEventDto> onCreate =
                    YearBudgetLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, YearBudgetLogEventListener.class, onCreate);
        });
    }

    @Transactional(rollbackFor = Exception.class)
    void saveBatch(List<YearBudgetDto> importList, List<YearBudgetDataDto> dataVos) {
        // 保存年度预算
        Collection<YearBudgetEntity> yearBudgetEntities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, YearBudgetDto.class, YearBudgetEntity.class, LinkedHashSet.class, ArrayList.class);
        this.yearBudgetRepository.saveBatch(new ArrayList<>(yearBudgetEntities));

        // 根据数据类型进行排序
        Map<String, Integer> dataTypeMap = YearBudgetDataTypeEnum.concertEnumToMap();
        dataVos.forEach(dataVo -> {
            if (dataTypeMap.containsKey(dataVo.getDataType())) {
                dataVo.setSortNum(dataTypeMap.get(dataVo.getDataType()));
            }
        });
        // 新增数据明细
        Collection<YearBudgetDataEntity> yearBudgetDataEntities = this.nebulaToolkitService.copyCollectionByBlankList(dataVos, YearBudgetDataDto.class, YearBudgetDataEntity.class, LinkedHashSet.class, ArrayList.class);
        this.yearBudgetDataRepository.saveBatch(yearBudgetDataEntities);
    }

    /**
     * 计算任务量、预算点数
     *
     * @param yearBudgetDtoList
     * @author huojia
     * @date 2022/11/3 16:49
     **/
    @Override
    public void  calTaskAndPoint(List<YearBudgetDto> yearBudgetDtoList) {
        if (CollectionUtils.isEmpty(yearBudgetDtoList)) {
            return;
        }
        yearBudgetDtoList.forEach(yearBudgetDto -> {
            //年度力度分数校验逻辑都要
            try {
                if (StringUtils.isNotBlank(yearBudgetDto.getBudgetIntensity())) {
                    if (yearBudgetDto.getBudgetIntensity().contains("/")){
                        yearBudgetDto.setBudgetIntensityNumerator(new BigDecimal(yearBudgetDto.getBudgetIntensity().split("/")[0]));//分子
                        yearBudgetDto.setBudgetIntensityDenominator(new BigDecimal(yearBudgetDto.getBudgetIntensity().split("/")[1]));//分母
                    }else{
                        yearBudgetDto.setBudgetIntensityNumerator(new BigDecimal(yearBudgetDto.getBudgetIntensity()));//分子
                        yearBudgetDto.setBudgetIntensityDenominator(BigDecimal.ONE);//分母
                    }
                }
            } catch (Exception e) {
                throw new IllegalArgumentException("年度力度格式错误，请填分数");
            }
            // 垂直逻辑
            if (BusinessUnitEnum.VERTICAL.getCode().equals(yearBudgetDto.getBusinessUnitCode())) {
                // 根据年度预算维度，查询对应计算配置    主体有费用归口，其他的有没有呢？
                BudgetCalConfigDto budgetCalConfigDto = this.nebulaToolkitService.copyObjectByWhiteList(
                        yearBudgetDto, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class
                );
                budgetCalConfigDto.setBudgetTypeCode(BudgetTypeEnum.YEAR_BUDGET.getCode());
                budgetCalConfigDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                budgetCalConfigDto.setFeeBelongCode(yearBudgetDto.getFeeBelongCode());
                List<BudgetCalConfigVo> budgetCalConfigVos = budgetCalConfigService.listByConditions(budgetCalConfigDto);
                // 没维护计算配置则不进行计算，跳过当前循环
                if (CollectionUtils.isEmpty(budgetCalConfigVos)) {
                    log.info("{}-未查到{}", yearBudgetDto.getYearBudgetCode(), "BudgetCalConfigVo1");
                    return;
                }
                List<SalesGoalVo> salesGoalVos = new ArrayList<>();
                List<BudgetCalConfigDataVo> dataList = new ArrayList<>();

                List<BudgetCalConfigVo> collect = budgetCalConfigVos.stream()
                        .filter(budgetCalConfigVo -> CollectionUtils.isEmpty(budgetCalConfigVo.getBudgetItemList())
                                || budgetCalConfigVo.getBudgetItemList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList()).contains(yearBudgetDto.getBudgetItemCode()))
                        .collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    log.info("{}-未查到{}", yearBudgetDto.getYearBudgetCode(), "BudgetCalConfigVo2");
                    return;
                }
                BudgetCalConfigVo budgetCalConfigVo = collect.get(0);

                dataList = budgetCalConfigVo.getDataList().stream()
                        .filter(budgetCalConfigDataVo -> CalDataFromEnum.SALES_GOAL.getCode().equals(budgetCalConfigDataVo.getCalDataFromCode()))
                        .collect(Collectors.toList());

                List<SalesGoalSumVo> salesGoalSumVos = this.listVerticalSalesGoalSum(budgetCalConfigVo, yearBudgetDto);
                log.info("{}-SalesGoal{}", yearBudgetDto.getYearBudgetCode(), JSON.toJSONString(salesGoalSumVos));
                yearBudgetDto.setBudgetCalCode(budgetCalConfigVo.getBudgetCalCode());
                this.buildSumGoalVerticalPoint(salesGoalSumVos, dataList, yearBudgetDto);

                /*salesGoalVos = this.listVerticalSalesGoal(budgetCalConfigVo, yearBudgetDto);

                this.buildGoalVerticalPoint(salesGoalVos, dataList, yearBudgetDto);*/
            }
        });
    }

    /**
     * 汇总查询数据
     *
     * @param budgetCalConfigVo
     * @param yearBudgetDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalSumVo>
     * @author huojia
     * @date 2023/2/9 10:54
     **/
    private List<SalesGoalSumVo> listVerticalSalesGoalSum(BudgetCalConfigVo budgetCalConfigVo, YearBudgetDto yearBudgetDto) {
        SalesGoalDto salesGoalDto = this.nebulaToolkitService.copyObjectByWhiteList(
                yearBudgetDto, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class
        );
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getTerminalList())) {
            List<String> terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesGoalDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getProductList())) {
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesGoalDto.setExcludeProductCodeList(productCodeList);
        }
        salesGoalDto.setYearMonthLy(yearBudgetDto.getYearLy());
        salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
        //预算计算配置-产品计费比例
        //产品计费比例产品编码
        List<String> productCodes = Lists.newArrayList();
        List<BudgetCalConfigProductRatioVo> productRatios = budgetCalConfigVo.getProductRatios();
        if(!CollectionUtils.isEmpty(productRatios)){
            productRatios.forEach(o -> {
                productCodes.add(o.getProductCode());
            });
        }
        salesGoalDto.setIncludeProductCodeList(productCodes);
        return salesGoalService.listVerticalSumByConditions(salesGoalDto);
    }

    /**
     * 构建汇总统计
     *
     * @param salesGoalSumVos
     * @param dataList
     * @param yearBudgetDto
     * @author huojia
     * @date 2023/2/9 10:45
     **/
    private void buildSumGoalVerticalPoint(List<SalesGoalSumVo> salesGoalSumVos, List<BudgetCalConfigDataVo> dataList, YearBudgetDto yearBudgetDto) {
        // 根据销量目标计算[销售目标、预算点数]
        AtomicReference<BigDecimal> reduce = new AtomicReference<>(BigDecimal.ZERO);

        YearBudgetDataDto pointDataDto = yearBudgetDto.getDataVos().stream()
                .filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_POINT.getCode().equals(dataVo.getDataType()))
                .collect(Collectors.toList())
                .get(0);

        YearBudgetDataDto amountDataDto = yearBudgetDto.getDataVos().stream()
                .filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode().equals(dataVo.getDataType()))
                .collect(Collectors.toList())
                .get(0);

        //销量目标
        YearBudgetDataDto goalDataDto = new YearBudgetDataDto();
        goalDataDto.setYearBudgetCode(yearBudgetDto.getYearBudgetCode());
        goalDataDto.setDataType(YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode());
        goalDataDto.setSortNum(YearBudgetDataTypeEnum.GOAL_QUANTITY.getSortNum());
        goalDataDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        goalDataDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        goalDataDto.setTenantCode(TenantUtils.getTenantCode());

        Map<String, SalesGoalSumVo> salesGoalSumMap = salesGoalSumVos.stream().collect(Collectors.toMap(SalesGoalSumVo::getYearMonthLy, Function.identity()));
        salesGoalSumMap.forEach((yearMonth, salesGoalSumVo) -> {
            AtomicReference<BigDecimal> salesGoal = new AtomicReference<>(BigDecimal.ZERO);

            if (SalesGoalAmountTypeEnum.DELIVERY_SALES_AMOUNT.getCode().equals(dataList.get(0).getAmountTypeCode())) {
                salesGoal.set(Optional.ofNullable(salesGoalSumVo.getDeliverySalesAmount()).orElse(BigDecimal.ZERO).add(salesGoal.get()));
                reduce.set(Optional.ofNullable(salesGoalSumVo.getDeliverySalesAmount()).orElse(BigDecimal.ZERO).add(reduce.get()));
            }

            if (SalesGoalAmountTypeEnum.DELIVERY_DISCOUNT_SALES_AMOUNT.getCode().equals(dataList.get(0).getAmountTypeCode())) {
                salesGoal.set(Optional.ofNullable(salesGoalSumVo.getDeliveryDiscountSalesAmount()).orElse(BigDecimal.ZERO).add(salesGoal.get()));
                reduce.set(Optional.ofNullable(salesGoalSumVo.getDeliveryDiscountSalesAmount()).orElse(BigDecimal.ZERO).add(reduce.get()));
            }

            if (SalesGoalAmountTypeEnum.DELIVERY_MULTIPLY_PRICE.getCode().equals(dataList.get(0).getAmountTypeCode())) {
                salesGoal.set(Optional.ofNullable(salesGoalSumVo.getDeliveryQuantity()).orElse(BigDecimal.ZERO).add(salesGoal.get()));
                reduce.set(Optional.ofNullable(salesGoalSumVo.getDeliveryQuantity()).orElse(BigDecimal.ZERO).add(reduce.get()));
            }

            this.buildMonthGoalVerticalPoint(yearBudgetDto, yearMonth, salesGoal, amountDataDto, pointDataDto, goalDataDto);
        });

        if (reduce.get().compareTo(BigDecimal.ZERO) != 0) {
            yearBudgetDto.setTotalGoalQuantity(reduce.get());
            yearBudgetDto.setBudgetTotalPoint(yearBudgetDto.getBudgetTotalAmount().multiply(new BigDecimal(100)).divide(reduce.get(), 4, RoundingMode.HALF_UP));
        }
        List<YearBudgetDataDto> dataVos = new ArrayList<>();
        dataVos.add(pointDataDto);
        dataVos.add(amountDataDto);
        dataVos.add(goalDataDto);
        yearBudgetDto.setDataVos(dataVos);
    }

    /**
     * 分月计算点数
     *
     * @param yearBudgetDto
     * @param yearMonth
     * @param salesGoal
     * @param amountDataDto
     * @param pointDataDto
     * @author huojia
     * @date 2023/1/31 16:03
     **/
    private void buildMonthGoalVerticalPoint(YearBudgetDto yearBudgetDto,
                                             String yearMonth,
                                             AtomicReference<BigDecimal> salesGoal,
                                             YearBudgetDataDto amountDataDto,
                                             YearBudgetDataDto pointDataDto,
                                             YearBudgetDataDto goalDataDto) {
        String month = yearMonth.split("-")[1];
        // 垂直分月计算点数
        switch (month) {
            case MonthConstant.JANUARY:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setJanuaryNum(salesGoal.get());
                    pointDataDto.setJanuaryNum(Optional.ofNullable(amountDataDto.getJanuaryNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.FEBRUARY:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setFebruaryNum(salesGoal.get());
                    pointDataDto.setFebruaryNum(Optional.ofNullable(amountDataDto.getFebruaryNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.MARCH:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setMarchNum(salesGoal.get());
                    pointDataDto.setMarchNum(Optional.ofNullable(amountDataDto.getMarchNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.APRIL:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setAprilNum(salesGoal.get());
                    pointDataDto.setAprilNum(Optional.ofNullable(amountDataDto.getAprilNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.MAY:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setMayNum(salesGoal.get());
                    pointDataDto.setMayNum(Optional.ofNullable(amountDataDto.getMayNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.JUNE:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setJuneNum(salesGoal.get());
                    pointDataDto.setJuneNum(Optional.ofNullable(amountDataDto.getJuneNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.JULY:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setJulyNum(salesGoal.get());
                    pointDataDto.setJulyNum(Optional.ofNullable(amountDataDto.getJulyNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.AUGUST:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setAugustNum(salesGoal.get());
                    pointDataDto.setAugustNum(Optional.ofNullable(amountDataDto.getAugustNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.SEPTEMBER:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setSeptemberNum(salesGoal.get());
                    pointDataDto.setSeptemberNum(Optional.ofNullable(amountDataDto.getSeptemberNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.OCTOBER:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setOctoberNum(salesGoal.get());
                    pointDataDto.setOctoberNum(Optional.ofNullable(amountDataDto.getOctoberNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.NOVEMBER:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setNovemberNum(salesGoal.get());
                    pointDataDto.setNovemberNum(Optional.ofNullable(amountDataDto.getNovemberNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.DECEMBER:
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    goalDataDto.setDecemberNum(salesGoal.get());
                    pointDataDto.setDecemberNum(Optional.ofNullable(amountDataDto.getDecemberNum()).orElse(BigDecimal.ZERO).multiply(new BigDecimal(100)).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            default:
                break;
        }
    }

    /**
     * 垂直查询销售任务
     *
     * @param budgetCalConfigVo
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo>
     * @author huojia
     * @date 2023/1/11 17:48
     **/
    private List<SalesGoalVo> listVerticalSalesGoal(BudgetCalConfigVo budgetCalConfigVo, YearBudgetDto yearBudgetDto) {
        SalesGoalDto salesGoalDto = this.nebulaToolkitService.copyObjectByWhiteList(
                yearBudgetDto, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class
        );
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getTerminalList())) {
            List<String> terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesGoalDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getProductList())) {
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesGoalDto.setExcludeProductCodeList(productCodeList);
        }
        salesGoalDto.setYearMonthLy(yearBudgetDto.getYearLy());
        // salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.ACHIEVEMENT.getCode());
        salesGoalDto.setYearSalesTypeCode(YearSalesTypeEnum.INTERNAL_CONTROL.getCode());
        // 根据计算配置获取对应销售组织
        /*if (SalesOrgAreaEnum.CUR_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            // 获取年度预算上当前组织
            if (StringUtils.isEmpty(yearBudgetDto.getSalesOrgCode())) {
                return Lists.newArrayList();
            }
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCode(yearBudgetDto.getSalesOrgCode());
            if (CollectionUtils.isEmpty(salesOrgVos)) {
                return Lists.newArrayList();
            }
            List<String> saleOrgCodeList = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            List<CustomerVo> customerVoList = customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty(customerVoList)) {
                return Lists.newArrayList();
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            salesGoalDto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            // 自定义的组织，自选组织
            if (CollectionUtils.isEmpty(budgetCalConfigVo.getSalesOrgList())) {
                return Lists.newArrayList();
            }
            List<String> saleOrgCodeList = budgetCalConfigVo.getSalesOrgList().stream()
                    .map(BudgetCalConfigSalesOrgVo::getSalesOrgCode).filter(Objects::nonNull)
                    .collect(Collectors.toList());
            List<CustomerVo> customerVoList = customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty(customerVoList)) {
                return Lists.newArrayList();
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            salesGoalDto.setCustomerCodeList(customerCodeList);
        }
        if (!CollectionUtils.isEmpty(salesGoalDto.getSalesOrgCodeList())
                && !StringUtils.isEmpty(salesGoalDto.getSalesOrgCode())) {
            salesGoalDto.getSalesOrgCodeList().remove(salesGoalDto.getSalesOrgCode());
        }*/
        //预算计算配置-产品计费比例
        //产品计费比例产品编码
        List<String> productCodes = Lists.newArrayList();
        List<BudgetCalConfigProductRatioVo> productRatios = budgetCalConfigVo.getProductRatios();
        if(!CollectionUtils.isEmpty(productRatios)){
            productRatios.forEach(o -> {
                productCodes.add(o.getProductCode());
            });
        }
        salesGoalDto.setIncludeProductCodeList(productCodes);
        // 查询销量计划，用于计算[首次回复预算金额]，但是只有管控类型为按率的场景才进行计算
        return salesGoalService.listVerticalByConditions(salesGoalDto);
    }

    /**
     * 查询销售任务
     *
     * @param budgetCalConfigVo
     * @param yearBudgetDto
     * @return java.util.List<com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo>
     * @author huojia
     * @date 2023/1/11 17:43
     **/
    private List<SalesGoalVo> listSalesGoal(BudgetCalConfigVo budgetCalConfigVo, YearBudgetDto yearBudgetDto) {
        // 能找到对应计算配置的，才能通过销售目标进行计算 预算点数
        SalesGoalDto salesGoalDto = this.nebulaToolkitService.copyObjectByWhiteList(yearBudgetDto, SalesGoalDto.class, LinkedHashSet.class, ArrayList.class);
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getCustomerList())) {
            List<String> customerCodeList = budgetCalConfigVo.getCustomerList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesGoalDto.setExcludeCustomerCodeList(customerCodeList);
        }
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getTerminalList())) {
            List<String> terminalCodeList = budgetCalConfigVo.getTerminalList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesGoalDto.setExcludeTerminalCodeList(terminalCodeList);
        }
        if (!CollectionUtils.isEmpty(budgetCalConfigVo.getProductList())) {
            List<String> productCodeList = budgetCalConfigVo.getProductList().stream().map(BudgetCalConfigAreaVo::getDataCode).collect(Collectors.toList());
            salesGoalDto.setExcludeProductCodeList(productCodeList);
        }
        salesGoalDto.setYearMonthLy(yearBudgetDto.getYearLy());
        // 根据计算配置获取对应销售组织
        if (SalesOrgAreaEnum.CUR_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            // 获取年度预算上当前组织
            if (StringUtils.isEmpty(yearBudgetDto.getSalesOrgCode())) {
                return Lists.newArrayList();
            }
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllChildrenBySalesOrgCode(yearBudgetDto.getSalesOrgCode());
            if (CollectionUtils.isEmpty(salesOrgVos)) {
                return Lists.newArrayList();
            }
            List<String> saleOrgCodeList = salesOrgVos.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
            List<CustomerVo> customerVoList = customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty(customerVoList)) {
                return Lists.newArrayList();
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            salesGoalDto.setCustomerCodeList(customerCodeList);
        }
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(budgetCalConfigVo.getOrgAreaCode())) {
            // 自定义的组织，自选组织
            if (CollectionUtils.isEmpty(budgetCalConfigVo.getSalesOrgList())) {
                return Lists.newArrayList();
            }
            List<String> saleOrgCodeList = budgetCalConfigVo.getSalesOrgList().stream()
                    .map(BudgetCalConfigSalesOrgVo::getSalesOrgCode).filter(Objects::nonNull)
                    .collect(Collectors.toList());
            List<CustomerVo> customerVoList = customerVoService.findBySalesOrgCodes(saleOrgCodeList);
            if (CollectionUtils.isEmpty(customerVoList)) {
                return Lists.newArrayList();
            }
            List<String> customerCodeList = customerVoList.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
            salesGoalDto.setCustomerCodeList(customerCodeList);
        }
        // 查询销量目标，用于计算[销售目标、预算点数]
        return salesGoalService.listByConditions(salesGoalDto);
    }

    /**
     * 根据销量目标计算预算点数
     *
     * @author huojia
     * @date 2022/11/5 19:25
     **/
    private List<MonthBudgetDto> buildGoalPoint(List<SalesGoalVo> salesGoalVos, List<MonthBudgetVo> monthBudgetVoList, Map<String, String> dataMap, YearBudgetDto yearBudgetDto) {
        // 将销量目标按照年月分组，一个年度预算对应12个月的值
        Map<String, MonthBudgetVo> monthBudgetVoMap = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getYearMonthLy, Function.identity()));
        List<MonthBudgetDto> monthBudgetDtoList = new ArrayList<>();
        Map<String, List<SalesGoalVo>> salesGoalVoMap = salesGoalVos.stream().collect(Collectors.groupingBy(SalesGoalVo::getYearMonthLy));
        // 根据销量目标计算[销售目标、预算点数]
        salesGoalVoMap.forEach((yearMonth, salesGoalList) -> {
            MonthBudgetVo monthBudgetVo = monthBudgetVoMap.get(yearMonth);
            AtomicReference<BigDecimal> reduce = new AtomicReference<>(BigDecimal.ZERO);
            salesGoalList.forEach(salesGoalVo -> {
                // 按照配置，取不同的字段
                if (SalesGoalAmountTypeEnum.DELIVERY_DISCOUNT_SALES_AMOUNT.getCode().equals(dataMap.get(salesGoalVo.getCustomerType()))) {
                    reduce.set(Optional.ofNullable(salesGoalVo.getDeliveryDiscountSalesAmount()).orElse(BigDecimal.ZERO).add(reduce.get()));
                }
                /*if (SalesGoalAmountTypeEnum.PURCHASE_DISCOUNT_SALES_AMOUNT.getCode().equals(salesGoalVo.getCustomerType())) {
                    reduce.set(Optional.ofNullable(salesGoalVo.getPurchaseDiscountSalesAmount()).orElse(BigDecimal.ZERO).add(reduce.get()));
                }*/
                if (SalesGoalAmountTypeEnum.DELIVERY_SALES_AMOUNT.getCode().equals(salesGoalVo.getCustomerType())) {
                    reduce.set(Optional.ofNullable(salesGoalVo.getDeliverySalesAmount()).orElse(BigDecimal.ZERO).add(reduce.get()));
                }
                /*if (SalesGoalAmountTypeEnum.PURCHASE_SALES_AMOUNT.getCode().equals(salesGoalVo.getCustomerType())) {
                    reduce.set(Optional.ofNullable(salesGoalVo.getPurchaseSalesAmount()).orElse(BigDecimal.ZERO).add(reduce.get()));
                }*/
            });
            // 计算月度预算点数
            monthBudgetVo.setBudgetTotalPoint(monthBudgetVo.getInitResolveAmount().divide(reduce.get(), 4, RoundingMode.HALF_UP));
            MonthBudgetDto monthBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(monthBudgetVo, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            /*this.buildYearBudget(yearBudgetDto, yearMonth, reduce);*/
            monthBudgetDtoList.add(monthBudgetDto);
        });
        return monthBudgetDtoList;
    }

    /**
     * 手动触发更新月度预算
     *
     * @param ids
     * @author huojia
     * @date 2022/11/4 14:58
     **/
    @Override
    public void manualUpdateMonth(List<String> ids) {
        Validate.notEmpty(ids, "请选择要操作的数据！");
        List<YearBudgetDto> yearBudgetDtoList = this.listByIds(ids);
        if (!CollectionUtils.isEmpty(yearBudgetDtoList)) {
            // 先只给垂直用，后续需要再放开，但是要注意不同单元业务逻辑不一样
            List<YearBudgetDto> collect = yearBudgetDtoList.stream()
                    .filter(yearBudgetDto -> BusinessUnitEnum.VERTICAL.getCode().equals(yearBudgetDto.getBusinessUnitCode()))
                    .collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return;
            }
            collect.forEach(yearBudgetDto -> {
                List<YearBudgetDataDto> pointDtoList = yearBudgetDto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_POINT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
                YearBudgetDataDto yearBudgetDataDto = null;
                if (CollectionUtils.isEmpty(pointDtoList)) {
                    yearBudgetDataDto = new YearBudgetDataDto();
                    yearBudgetDataDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    yearBudgetDataDto.setYearBudgetCode(yearBudgetDto.getYearBudgetCode());
                    yearBudgetDataDto.setTenantCode(yearBudgetDto.getTenantCode());
                    yearBudgetDataDto.setDataType(YearBudgetDataTypeEnum.BUDGET_POINT.getCode());
                    yearBudgetDataDto.setSortNum(YearBudgetDataTypeEnum.BUDGET_POINT.getSortNum());
                }
                if (!ObjectUtils.isEmpty(yearBudgetDataDto)) {
                    yearBudgetDto.getDataVos().add(yearBudgetDataDto);
                }
            });
            this.calTaskAndPoint(collect);
            this.refreshPoint(collect);
        }
    }

    /**
     * 刷新年度、月度点数、任务量
     *
     * @param dtoList
     * @author huojia
     * @date 2023/2/8 10:42
     **/
    private void refreshPoint(List<YearBudgetDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List<String> monthList = MonthEnum.concertEnumToList();
        List<MonthBudgetDto> monthBudgetDtoList = new ArrayList<>();
        List<String> yearBudgetCodeList = dtoList.stream()
                .filter(vo -> BooleanEnum.TRUE.getCapital().equals(vo.getMonthBudgetFlag()))
                .map(YearBudgetDto::getYearBudgetCode)
                .collect(Collectors.toList());
        List<MonthBudgetVo> allMonthBudgetList = monthBudgetService.listByYearBudgetCodes(yearBudgetCodeList);
        Map<String, List<MonthBudgetVo>> monthBudgetMap = allMonthBudgetList.stream().collect(Collectors.groupingBy(MonthBudgetVo::getYearBudgetCode));
        dtoList.forEach(yearDto -> {
            if (!monthBudgetMap.containsKey(yearDto.getYearBudgetCode())) {
                log.info("{}-没有{}", yearDto.getYearBudgetCode(), "monthBudgetMap");
                return;
            }
            List<MonthBudgetVo> monthBudgetVoList = monthBudgetMap.get(yearDto.getYearBudgetCode());
            List<MonthBudgetDto> monthBudgets = (List<MonthBudgetDto>) this.nebulaToolkitService.copyCollectionByWhiteList(monthBudgetVoList, MonthBudgetVo.class, MonthBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            Map<String, MonthBudgetDto> map = monthBudgets.stream().collect(Collectors.toMap(MonthBudgetDto::getYearMonthLy, Function.identity()));
            // 获取预算金额、预算点数
            List<YearBudgetDataDto> budgetPointList = yearDto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_POINT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
            log.info("{}-BudgetPoint{}", yearDto.getYearBudgetCode(), JSON.toJSONString(budgetPointList));
            // 构建每个月的月度预算明细
            monthList.forEach(month -> {
                MonthBudgetDto monthBudgetDto = map.get(yearDto.getYearLy() + "-" + month);
                // 设置年初分解金额、预算点数
                switch (month) {
                    case MonthConstant.JANUARY:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJanuaryNum());
                        }
                        break;
                    case MonthConstant.FEBRUARY:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getFebruaryNum());
                        }
                        break;
                    case MonthConstant.MARCH:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getMarchNum());
                        }
                        break;
                    case MonthConstant.APRIL:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getAprilNum());
                        }
                        break;
                    case MonthConstant.MAY:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getMayNum());
                        }
                        break;
                    case MonthConstant.JUNE:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJuneNum());
                        }
                        break;
                    case MonthConstant.JULY:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getJulyNum());
                        }
                        break;
                    case MonthConstant.AUGUST:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getAugustNum());
                        }
                        break;
                    case MonthConstant.SEPTEMBER:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getSeptemberNum());
                        }
                        break;
                    case MonthConstant.OCTOBER:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getOctoberNum());
                        }
                        break;
                    case MonthConstant.NOVEMBER:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getNovemberNum());
                        }
                        break;
                    case MonthConstant.DECEMBER:
                        if (!CollectionUtils.isEmpty(budgetPointList)) {
                            monthBudgetDto.setBudgetTotalPoint(budgetPointList.get(0).getDecemberNum());
                        }
                        break;
                    default:
                        break;
                }
                monthBudgetDtoList.add(monthBudgetDto);
            });
        });
        monthBudgetService.updateBatch(monthBudgetDtoList);
        this.updatePoint(dtoList);
    }

    /**
     * 更新年度预算点数
     *
     * @param dtoList
     * @author huojia
     * @date 2023/2/8 11:02
     **/
    @Transactional(rollbackFor = Exception.class)
    void updatePoint(List<YearBudgetDto> dtoList) {
        List<YearBudgetEntity> yearBudgetEntities = (List<YearBudgetEntity>) this.nebulaToolkitService.copyCollectionByWhiteList(
                dtoList, YearBudgetDto.class, YearBudgetEntity.class, LinkedHashSet.class, ArrayList.class
        );
        this.yearBudgetRepository.updateBatchById(yearBudgetEntities);
        List<String> yearBudgetCodeList = dtoList.stream().map(YearBudgetDto::getYearBudgetCode).collect(Collectors.toList());
        List<YearBudgetDataEntity> yearBudgetDataEntities = yearBudgetDataRepository.listByYearBudgetCodes(yearBudgetCodeList, Lists.newArrayList(YearBudgetDataTypeEnum.BUDGET_POINT.getCode()));
        yearBudgetDataEntities.forEach(yearBudgetDataEntity -> {
            yearBudgetDataEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        yearBudgetDataRepository.updateBatchById(yearBudgetDataEntities);
        List<YearBudgetDataEntity> newPointList = new ArrayList<>();
        dtoList.forEach(dto -> {
            List<YearBudgetDataDto> collect = dto.getDataVos().stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_POINT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
            newPointList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList(collect, YearBudgetDataDto.class, YearBudgetDataEntity.class, LinkedHashSet.class, ArrayList.class));
        });
        newPointList.forEach(newPoint -> {
            newPoint.setId(null);
        });
        yearBudgetDataRepository.saveBatch(newPointList);
    }

    /**
     * 获取年度预算
     *
     * @param codes
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo>
     * @author huojia
     * @date 2022/11/10 20:00
     **/
    @Override
    public List<YearBudgetVo> listByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<YearBudgetEntity> yearBudgetEntities = this.yearBudgetRepository.listByCodes(codes);
        if (CollectionUtils.isEmpty(yearBudgetEntities)) {
            return Lists.newArrayList();
        }
        List<YearBudgetVo> yearBudgetVos = new ArrayList<>(this.nebulaToolkitService.copyCollectionByWhiteList(yearBudgetEntities, YearBudgetEntity.class, YearBudgetVo.class, LinkedHashSet.class, ArrayList.class));
        // 查询年度预算明细
        List<YearBudgetDataEntity> yearBudgetDataEntities = this.yearBudgetDataRepository.listByYearBudgetCodes(codes, null);
        if (CollectionUtils.isEmpty(yearBudgetDataEntities)) {
            return yearBudgetVos;
        }
        List<YearBudgetDataVo> yearBudgetDataVos = new ArrayList<>(this.nebulaToolkitService.copyCollectionByWhiteList(yearBudgetDataEntities, YearBudgetDataEntity.class, YearBudgetDataVo.class, LinkedHashSet.class, ArrayList.class));
        Map<String, List<YearBudgetDataVo>> dataMap = yearBudgetDataVos.stream().collect(Collectors.groupingBy(YearBudgetDataVo::getYearBudgetCode));
        yearBudgetVos.forEach(yearBudgetVo -> {
            if (dataMap.containsKey(yearBudgetVo.getYearBudgetCode())) {
                yearBudgetVo.setDataVos(dataMap.get(yearBudgetVo.getYearBudgetCode()));
            }
        });
        return yearBudgetVos;
    }

    /**
     * 导入测试
     *
     * @param importsVos
     * @author huojia
     * @date 2023/1/2 22:32
     **/
    @Override
    public void importTest(List<YearBudgetImportsVo> importsVos) {
        yearBudgetImportsProcess.testClass(importsVos);
    }

    /**
     * 费用归口下拉框
     *
     * @param businessUnitCode
     * @return java.util.List<com.biz.crm.mn.common.base.vo.CommonSelectVo>
     * @author huojia
     * @date 2023/1/2 23:24
     **/
    @Override
    public List<CommonSelectVo> findBelongSelect(String businessFormatCode, String businessUnitCode) {
        List<CommonSelectVo> commonSelectVoList = new ArrayList<>();
        if (BusinessFormatEnum.NORMAL.getCode().equals(businessFormatCode)
                && BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)) {
            CommonSelectVo headSelectVo = new CommonSelectVo();
            headSelectVo.setCode(FeeBelongEnum.HEAD.getCode());
            headSelectVo.setValue(FeeBelongEnum.HEAD.getDes());
            commonSelectVoList.add(headSelectVo);

            CommonSelectVo areaSelectVo = new CommonSelectVo();
            areaSelectVo.setCode(FeeBelongEnum.AREA.getCode());
            areaSelectVo.setValue(FeeBelongEnum.AREA.getDes());
            commonSelectVoList.add(areaSelectVo);
        }
        if (BusinessFormatEnum.NORMAL.getCode().equals(businessFormatCode)
                && BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            CommonSelectVo headSelectVo = new CommonSelectVo();
            headSelectVo.setCode(FeeBelongEnum.HEAD.getCode());
            headSelectVo.setValue(FeeBelongEnum.HEAD.getDes());
            commonSelectVoList.add(headSelectVo);

            CommonSelectVo areaSelectVo = new CommonSelectVo();
            areaSelectVo.setCode(FeeBelongEnum.REGION_AUTOMATIC.getCode());
            areaSelectVo.setValue(FeeBelongEnum.REGION_AUTOMATIC.getDes());
            commonSelectVoList.add(areaSelectVo);

            CommonSelectVo regionSelectVo = new CommonSelectVo();
            regionSelectVo.setCode(FeeBelongEnum.REGION_REFERENDUM.getCode());
            regionSelectVo.setValue(FeeBelongEnum.REGION_REFERENDUM.getDes());
            commonSelectVoList.add(regionSelectVo);
        }
        if (BusinessFormatEnum.NORMAL.getCode().equals(businessFormatCode)
                && BusinessUnitEnum.SON_COMPANY.getCode().equals(businessUnitCode)) {
            CommonSelectVo autoSelectVo = new CommonSelectVo();
            autoSelectVo.setCode(FeeSourceEnum.AUTO_FEE.getCode());
            autoSelectVo.setValue(FeeSourceEnum.AUTO_FEE.getDesc());
            commonSelectVoList.add(autoSelectVo);

            CommonSelectVo internalSelectVo = new CommonSelectVo();
            internalSelectVo.setCode(FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
            internalSelectVo.setValue(FeeSourceEnum.INTERNAL_POINT_FEE.getDesc());
            commonSelectVoList.add(internalSelectVo);

            CommonSelectVo offSelectVo = new CommonSelectVo();
            offSelectVo.setCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
            offSelectVo.setValue(FeeSourceEnum.OFF_POINT_FEE.getDesc());
            commonSelectVoList.add(offSelectVo);
        }
        if (BusinessFormatEnum.NORMAL.getCode().equals(businessFormatCode)
                && BusinessUnitEnum.ONLINE.getCode().equals(businessUnitCode)) {
            CommonSelectVo areaSelectVo = new CommonSelectVo();
            areaSelectVo.setCode(FeeBelongEnum.REGION_AUTOMATIC.getCode());
            areaSelectVo.setValue(FeeBelongEnum.REGION_AUTOMATIC.getDes());
            commonSelectVoList.add(areaSelectVo);
        }
        return commonSelectVoList;
    }

    /**
     * 生成月度预算
     *
     * @param dto
     * @author huojia
     * @date 2023/1/3 0:29
     **/
    @Override
    public void generateMonthBudget(YearBudgetDto dto) {
        Validate.notNull(dto,"请选择要操作的数据！");
        boolean lockFlag = true;
        if (CollectionUtils.isEmpty(dto.getIds())) {
            //通过除id外的筛选条件选择数据，控制下最大维度，别一次扫全表，处理数据
            if ( StringUtil.isBlank(dto.getBusinessFormatCode())
                    || StringUtils.isBlank(dto.getBusinessUnitCode())
                    || StringUtils.isBlank(dto.getYearLy()) ) {

                throw new IllegalArgumentException("注意，请通过'勾选'(优先取) 或者 查询条件（至少填写业态、业务单元、年份)，两种方式来选择数据！");
            }
        }
        List<String> ids = new ArrayList<>();
        try {
            List<YearBudgetDto> yearBudgetDtoList = null;

            if (!CollectionUtils.isEmpty(dto.getIds())) {
                ids = dto.getIds();

                lockFlag = redisLockService.batchLock(YearBudgetConstant.YEAR_BUDGET_LOCK, ids, TimeUnit.MINUTES, 30);
                Validate.isTrue(lockFlag, "当前年度预算正在生成月度预算，请勿重复操作！");
                yearBudgetDtoList = this.listByIds(ids);
                if (CollectionUtils.isEmpty(yearBudgetDtoList)) {
                    throw new RuntimeException("年度预算不存在，请检查！");
                }

            }else {
                yearBudgetDtoList = this.getListByConditions(dto);
                if (CollectionUtils.isEmpty(yearBudgetDtoList)) {
                    throw new RuntimeException("年度预算不存在，请检查！");
                }
                ids = yearBudgetDtoList.stream().map(YearBudgetDto::getId).collect(Collectors.toList());

                lockFlag = redisLockService.batchLock(YearBudgetConstant.YEAR_BUDGET_LOCK, ids, TimeUnit.MINUTES, 30);
                Validate.isTrue(lockFlag, "当前年度预算正在生成月度预算，请勿重复操作！");

            }

            Set<String> yearBudgetCodeSet = yearBudgetDtoList.stream().map(YearBudgetDto::getYearBudgetCode).collect(Collectors.toSet());
            List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.listByYearBudgetCodes(new ArrayList<>(yearBudgetCodeSet));
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
                Set<String> collect = monthBudgetVoList.stream().map(MonthBudgetVo::getYearBudgetCode).collect(Collectors.toSet());
                throw new RuntimeException("年度预算" + String.join(",", collect) + "已生成过月度预算，无法重复生成！");
            }
            this.buildMonthBudget(yearBudgetDtoList);
        } finally {
            if (lockFlag) {
                redisLockService.batchUnLock(YearBudgetConstant.YEAR_BUDGET_LOCK, ids);
            }
        }
    }

    /**
     * 批量查询
     *
     * @param ids
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto>
     * @author huojia
     * @date 2022/11/4 15:03
     **/
    private List<YearBudgetDto> listByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<YearBudgetEntity> yearBudgetEntityList = this.yearBudgetRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(yearBudgetEntityList)) {
            return Lists.newArrayList();
        }
        // 查询对应数据，按规定排序
        List<String> dataTypeList = YearBudgetDataTypeEnum.concertEnumToEditList();
        List<String> yearBudgetCodeList = yearBudgetEntityList.stream().map(YearBudgetEntity::getYearBudgetCode).collect(Collectors.toList());
        List<YearBudgetDataEntity> yearBudgetDataEntities = this.yearBudgetDataRepository.listByYearBudgetCodes(yearBudgetCodeList, dataTypeList);
        ArrayList<YearBudgetDto> yearBudgetDtoList = Lists.newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(yearBudgetEntityList, YearBudgetEntity.class, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class));
        if (CollectionUtils.isEmpty(yearBudgetDataEntities)) {
            return yearBudgetDtoList;
        }
        Collection<YearBudgetDataDto> dataDtoList = this.nebulaToolkitService.copyCollectionByBlankList(yearBudgetDataEntities, YearBudgetDataEntity.class, YearBudgetDataDto.class, LinkedHashSet.class, ArrayList.class);
        Map<String, List<YearBudgetDataDto>> dataMap = Lists.newArrayList(dataDtoList).stream().collect(Collectors.groupingBy(YearBudgetDataDto::getYearBudgetCode));
        yearBudgetDtoList.forEach(yearBudgetDto -> {
            yearBudgetDto.setDataVos(dataMap.get(yearBudgetDto.getYearBudgetCode()));
        });
        return yearBudgetDtoList;
    }

    /**
     * 构建年度预算
     *
     * @param yearBudgetDto 年度预算
     * @param salesGoal     任务量
     * @author huojia
     * @date 2022/11/4 12:02
     **/
    private void buildYearBudget(YearBudgetDto yearBudgetDto, AtomicReference<BigDecimal> salesGoal) {
        // 获取已存在数据
        YearBudgetDataDto pointDataDto = new YearBudgetDataDto();
        YearBudgetDataDto goalDataDto = new YearBudgetDataDto();
        List<YearBudgetDataDto> dataVos = yearBudgetDto.getDataVos();
        // List<YearBudgetDataDto> pointDataDtoList = dataVos.stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_POINT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
        // List<YearBudgetDataDto> goalDataDtoList = dataVos.stream().filter(dataVo -> YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode().equals(dataVo.getDataType())).collect(Collectors.toList());
        // 预算金额必定存在
        YearBudgetDataDto amountDataDto = dataVos.stream().filter(dataVo -> YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode().equals(dataVo.getDataType())).collect(Collectors.toList()).get(0);
        /*if (!CollectionUtils.isEmpty(pointDataDtoList)) {
            pointDataDto = pointDataDtoList.get(0);
        }
        if (!CollectionUtils.isEmpty(goalDataDtoList)) {
            goalDataDto = goalDataDtoList.get(0);
        }*/
        /*String month = yearMonth.split("-")[1];*/
        /*switch (month) {
            case MonthConstant.JANUARY:
                goalDataDto.setJanuaryNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setJanuaryNum(Optional.ofNullable(amountDataDto.getJanuaryNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.FEBRUARY:
                goalDataDto.setFebruaryNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setFebruaryNum(Optional.ofNullable(amountDataDto.getFebruaryNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.MARCH:
                goalDataDto.setMarchNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setMarchNum(Optional.ofNullable(amountDataDto.getMarchNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.APRIL:
                goalDataDto.setAprilNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setAprilNum(Optional.ofNullable(amountDataDto.getAprilNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.MAY:
                goalDataDto.setMayNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setMayNum(Optional.ofNullable(amountDataDto.getMayNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.JUNE:
                goalDataDto.setJuneNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setJuneNum(Optional.ofNullable(amountDataDto.getJuneNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.JULY:
                goalDataDto.setJulyNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setJulyNum(Optional.ofNullable(amountDataDto.getJulyNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.AUGUST:
                goalDataDto.setAugustNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setAugustNum(Optional.ofNullable(amountDataDto.getAugustNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.SEPTEMBER:
                goalDataDto.setSeptemberNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setSeptemberNum(Optional.ofNullable(amountDataDto.getSeptemberNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.OCTOBER:
                goalDataDto.setOctoberNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setOctoberNum(Optional.ofNullable(amountDataDto.getOctoberNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.NOVEMBER:
                goalDataDto.setNovemberNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setNovemberNum(Optional.ofNullable(amountDataDto.getNovemberNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            case MonthConstant.DECEMBER:
                goalDataDto.setDecemberNum(salesGoal.get());
                if (BigDecimal.ZERO.compareTo(salesGoal.get()) != 0) {
                    pointDataDto.setDecemberNum(Optional.ofNullable(amountDataDto.getDecemberNum()).orElse(BigDecimal.ZERO).divide(salesGoal.get(), 4, RoundingMode.HALF_UP));
                }
                break;
            default:
                break;
        }
        yearBudgetDto.getDataVos().add(pointDataDto);
        yearBudgetDto.getDataVos().add(goalDataDto);*/
    }

    /**
     * 根据必填项查询出已有的年度预算
     * @param dto
     * @return {@link List}<{@link YearBudgetVo}>
     */
    @Override
    public List<YearBudgetVo> findListByConditions(YearBudgetDto dto) {
        return this.yearBudgetRepository.findByConditions(dto);
    }

    /**
     * 根据编码查询年度预算
     *
     * @param yearBudgetCode 年度预算编码
     * @return YearBudgetVo
     */
    @Override
    public YearBudgetVo getBudgetByCode(String yearBudgetCode) {
        if (StringUtils.isBlank(yearBudgetCode)) {
            return null;
        }
        YearBudgetEntity entity = yearBudgetRepository.getBudgetByCode(yearBudgetCode);
        if (Objects.isNull(entity)) {
            return null;
        }
        YearBudgetVo vo = this.nebulaToolkitService.copyObjectByBlankList(entity, YearBudgetVo.class, HashSet.class, ArrayList.class);
        return vo;
    }

    @Override
    public List<YearBudgetReportVo> findYearBudgetSumVo(YearBudgetDto queryDto) {
        return this.yearBudgetRepository.findYearBudgetSumVo(queryDto);
    }

    @Override
    public List<String> generateMonthBudgetForOut(List<String> ids) {
        List<String> monthBudgetIdList = new ArrayList<>();
        Validate.notEmpty(ids, "请选择要操作的数据！");
        boolean lockFlag = true;
        try {
            lockFlag = redisLockService.batchLock(YearBudgetConstant.YEAR_BUDGET_LOCK, ids, TimeUnit.SECONDS, 60);
            Validate.isTrue(lockFlag, "当前年度预算正在生成月度预算，请勿重复操作！");
            List<YearBudgetDto> yearBudgetDtoList = this.listByIds(ids);
            if (CollectionUtils.isEmpty(yearBudgetDtoList)) {
                throw new RuntimeException("年度预算不存在，请检查！");
            }
            Set<String> yearBudgetCodeSet = yearBudgetDtoList.stream().map(YearBudgetDto::getYearBudgetCode).collect(Collectors.toSet());
            List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.listByYearBudgetCodes(new ArrayList<>(yearBudgetCodeSet));
            if (!CollectionUtils.isEmpty(monthBudgetVoList)) {
                Set<String> collect = monthBudgetVoList.stream().map(MonthBudgetVo::getYearBudgetCode).collect(Collectors.toSet());
                throw new RuntimeException("年度预算" + String.join(",", collect) + "已生成过月度预算，无法重复生成！");
            }
            monthBudgetIdList = this.buildMonthBudgetForOut(yearBudgetDtoList);
        } finally {
            if (lockFlag) {
                redisLockService.batchUnLock(YearBudgetConstant.YEAR_BUDGET_LOCK, ids);
            }
        }
        return monthBudgetIdList;
    }

    /**
     * 查询年度预算总点数
     *
     * @param pointDto 参数
     * @return BigDecimal
     */
    @Override
    public BigDecimal getYearBudgetTotalPoint(YearBudgetToralPointDto pointDto) {
        return yearBudgetRepository.getYearBudgetTotalPoint(pointDto);
    }

    @Override
    public BigDecimal getYearBudgetTotalPointForCustomerGroup(YearBudgetToralPointDto pointDto) {
        return yearBudgetRepository.getYearBudgetTotalPointForCustomerGroup(pointDto);

    }

    @Override
    public List<YearBudgetVo> findYearBudgetByYearBudgetCodes(List<String> yearBudgetCodes) {
        return yearBudgetRepository.findYearBudgetByYearBudgetCodes(yearBudgetCodes);
    }

    @Override
    public Page<YearBudgetVo> findPageForOut(Pageable pageable, YearBudgetDto dto) {
        return yearBudgetRepository.findPageForOut(pageable, dto);
    }


    private List<YearBudgetDto> getListByConditions(YearBudgetDto dto) {
        if (Objects.isNull(dto)
                || StringUtil.isBlank(dto.getBusinessFormatCode())
                || StringUtils.isBlank(dto.getBusinessUnitCode())
                || StringUtils.isBlank(dto.getYearLy()) ) {

            return Lists.newArrayList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<YearBudgetDto> yearBudgetDtoList = this.yearBudgetRepository.getListByConditions(dto);
        if (CollectionUtils.isEmpty(yearBudgetDtoList)) {
            return Lists.newArrayList();
        }
        // 查询对应数据，按规定排序
        List<String> dataTypeList = YearBudgetDataTypeEnum.concertEnumToEditList();
        List<String> yearBudgetCodeList = yearBudgetDtoList.stream().map(YearBudgetDto::getYearBudgetCode).collect(Collectors.toList());
        List<YearBudgetDataEntity> yearBudgetDataEntities = this.yearBudgetDataRepository.listByYearBudgetCodes(yearBudgetCodeList, dataTypeList);
        if (CollectionUtils.isEmpty(yearBudgetDataEntities)) {
            return yearBudgetDtoList;
        }
        List<YearBudgetDataDto> dataDtoList = (List<YearBudgetDataDto>) this.nebulaToolkitService.copyCollectionByWhiteList(yearBudgetDataEntities, YearBudgetDataEntity.class, YearBudgetDataDto.class, LinkedHashSet.class, ArrayList.class);
        Map<String, List<YearBudgetDataDto>> dataMap = dataDtoList.stream().collect(Collectors.groupingBy(YearBudgetDataDto::getYearBudgetCode));
        yearBudgetDtoList.forEach(yearBudgetDto -> {
            yearBudgetDto.setDataVos(dataMap.get(yearBudgetDto.getYearBudgetCode()));
        });
        return yearBudgetDtoList;
    }

    @Override
    public void updateOperateBudget(List<YearBudgetEntity> values) {
        if (CollectionUtils.isEmpty(values)){
            return;
        }
        yearBudgetRepository.updateBatchById(values);
    }

}
