package com.biz.crm.tpm.business.year.budget.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.dto.DimensionInformationQueryData;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.enmus.MenuCodeEnum;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.service.DimensionDimensionInformationService;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionDimensionInformationVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.year.budget.local.service.YearBudgetService;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDataDto;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.eunm.YearBudgetDataTypeEnum;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetOnLineImportsVo;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年10月28日 11:42
 */
@Slf4j
@Component
public class YearBudgetOnLineImportsProcess implements ImportProcess<YearBudgetOnLineImportsVo> {

    @Resource
    private OrgVoService orgVoService;

    @Resource
    private ProductVoService productVoService;

    @Resource
    private CustomerVoService customerVoService;

    @Resource
    private TerminalVoService terminalVoService;

    @Resource
    private SalesOrgVoService salesOrgVoService;

    @Resource
    private CustomerChannelVoService customerChannelVoService;

    @Resource
    private MdmTerminalChannelVoService mdmTerminalChannelVoService;

    @Resource
    private ProductBrandService productBrandService;

    @Resource
    private ProductLevelVoSdkService productLevelVoSdkService;

    @Resource
    private BudgetItemService budgetItemService;

    @Resource
    private YearBudgetService yearBudgetService;

    @Resource
    private DictToolkitService dictToolkitService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DimensionDimensionInformationService dimensionDimensionInformationService;

    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);

    private Map<String, String> mdmBusinessFormatMap = new HashMap<>();
    private Map<String, String> mdmBusinessUnitMap = new HashMap<>();
    private Map<String, String> tpmGroupCodeMap = new HashMap<>();
    private Map<String, String> tpmFeeBelongMap = new HashMap<>();
    private Map<String, String> tpmFeeSourceMap = new HashMap<>();
    private Map<String, Integer> dataTypeMap = new HashMap<>();
    private Map<String, OrgVo> orgVoMap = new HashMap<>();
    private Map<String, YearBudgetVo> yearBudgetVoMap = new HashMap<>();
    private Map<String, BudgetItemVo> budgetItemVoMap = new HashMap<>();
    private Map<String, CustomerVo> customerVoMap = new HashMap<>();
    private Map<String, TerminalVo> terminalVoMap = new HashMap<>();
    private Map<String, ProductVo> productVoMap = new HashMap<>();
    private Map<String, SalesOrgVo> salesOrgVoMap = new HashMap<>();
    private Map<String, CustomerChannelVo> customerChannelVoMap = new HashMap<>();
    private Map<String, MdmTerminalChannelVo> terminalChannelVoMap = new HashMap<>();
    private Map<String, ProductBrandVo> productBrandVoMap = new HashMap<>();
    private Map<String, ProductLevelVo> productCategoryVoMap = new HashMap<>();
    private Map<String, ProductLevelVo> productItemVoMap = new HashMap<>();

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, YearBudgetOnLineImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            Validate.notEmpty(data, "导入数据不能为空！");

            List<YearBudgetDto> importList = this.validate(data);

            yearBudgetService.importSave(importList);
        } catch (IllegalArgumentException e) {
            throw e;
        } catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg(e);
            log.error("年度预算电商导入异常:{}", error);
            throw new IllegalArgumentException("导入异常[" + error + "]");
        }
        return null;
    }

    /**
     * 校验并转换数据
     *
     * @param yearBudgetImportsVos
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto>
     * @author huojia
     * @date 2022/10/28 14:40
     **/
    public List<YearBudgetDto> testClass(List<YearBudgetOnLineImportsVo> yearBudgetImportsVos) {
        List<YearBudgetDto> yearBudgetDtoList = new ArrayList<>();

        // 构建基础数据map
        this.buildBaseMap(yearBudgetImportsVos);

        yearBudgetImportsVos.forEach(importsVo -> {

            // 校验数据不能为空
            // this.validateNull(importsVo);

            // 校验基础数据
            // this.buildBaseData(importsVo);

            // 校验数字
            this.buildDecimal(importsVo);

            // 构建行明细
            List<YearBudgetDataDto> yearBudgetDataDtoList = this.buildDetailData(importsVo);

            // 组装明细
            YearBudgetDto yearBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(importsVo, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            yearBudgetDto.setDataVos(yearBudgetDataDtoList);
            yearBudgetDtoList.add(yearBudgetDto);
        });
        return yearBudgetDtoList;
    }

    /**
     * 校验并转换数据
     *
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto>
     * @author huojia
     * @date 2022/10/28 14:40
     **/
    private List<YearBudgetDto> validate(LinkedHashMap<Integer, YearBudgetOnLineImportsVo> data) {
        List<YearBudgetOnLineImportsVo> yearBudgetImportsVos = new ArrayList<>(data.values());
        List<YearBudgetDto> yearBudgetDtoList = new ArrayList<>();

        // 构建基础数据map
        this.buildBaseMap(yearBudgetImportsVos);

        // 分组校验
        yearBudgetImportsVos.forEach(importsVo -> {

            // 校验数据不能为空
            this.validateNull(importsVo);

            // 校验基础数据
            this.buildBaseData(importsVo);

            // 校验数字
            this.buildDecimal(importsVo);

            // 构建行明细
            List<YearBudgetDataDto> yearBudgetDataDtoList = this.buildDetailData(importsVo);

            // 组装明细
            YearBudgetDto yearBudgetDto = this.nebulaToolkitService.copyObjectByWhiteList(importsVo, YearBudgetDto.class, LinkedHashSet.class, ArrayList.class);
            yearBudgetDto.setDataVos(yearBudgetDataDtoList);
            yearBudgetDtoList.add(yearBudgetDto);
        });
        return yearBudgetDtoList;
    }

    /**
     * 校验关键数据
     *
     * @param importsVo
     * @author huojia
     * @date 2023/1/2 18:38
     **/
    private void validateNull(YearBudgetOnLineImportsVo importsVo) {
        if (StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            throw new NullPointerException("业态不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            throw new NullPointerException("业务单元不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getYearLy())) {
            throw new NullPointerException("年份不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getOrgCode())) {
            throw new NullPointerException("部门编码不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getFeeBelongCode())) {
            throw new NullPointerException("费用归口不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getBudgetItemCode())) {
            throw new NullPointerException("预算项目编码不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getBudgetTotalPointStr())) {
            throw new NullPointerException("预算总点数不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getBudgetTotalAmountStr())) {
            throw new NullPointerException("预算总金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getTotalGoalQuantityStr())) {
            throw new NullPointerException("总目标量不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getJanuaryNumStr())) {
            throw new NullPointerException("一月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getFebruaryNumStr())) {
            throw new NullPointerException("二月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getMarchNumStr())) {
            throw new NullPointerException("三月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getAprilNumStr())) {
            throw new NullPointerException("四月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getMayNumStr())) {
            throw new NullPointerException("五月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getJuneNumStr())) {
            throw new NullPointerException("六月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getJulyNumStr())) {
            throw new NullPointerException("七月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getAugustNumStr())) {
            throw new NullPointerException("八月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getSeptemberNumStr())) {
            throw new NullPointerException("九月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getOctoberNumStr())) {
            throw new NullPointerException("十月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getNovemberNumStr())) {
            throw new NullPointerException("十一月预算金额不能为空！");
        }
        if (StringUtils.isEmpty(importsVo.getDecemberNumStr())) {
            throw new NullPointerException("十二月预算金额不能为空！");
        }
    }

    /**
     * 获取维度配置，校验基础数据
     *
     * @param dimensionMap
     * @param importsVo
     * @param clazz
     * @author huojia
     * @date 2022/11/12 10:51
     **/
    private void buildDimension(Map<String, List<DimensionDimensionInformationVo>> dimensionMap, YearBudgetOnLineImportsVo importsVo, Class<YearBudgetOnLineImportsVo> clazz) {
        List<DimensionDimensionInformationVo> dimensionVoList = new ArrayList<>();
        if (!dimensionMap.containsKey(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.YEAR_BUDGET.getCode() + importsVo.getSalesOrgCode())) {
            // 获取维度配置
            DimensionInformationQueryData dto = new DimensionInformationQueryData();
            dto.setBusinessFormatCode(importsVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(importsVo.getBusinessUnitCode());
            dto.setMenu(MenuCodeEnum.YEAR_BUDGET.getCode());
            dto.setSalesOrgCodeList(Arrays.asList(importsVo.getSalesOrgCode()));
            dimensionVoList = dimensionDimensionInformationService.findDetailsByCodes(dto);
            dimensionMap.put(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.YEAR_BUDGET.getCode() + importsVo.getSalesOrgCode(), dimensionVoList);
        } else {
            dimensionVoList = dimensionMap.get(importsVo.getBusinessFormatCode() + importsVo.getBusinessUnitCode() + MenuCodeEnum.YEAR_BUDGET.getCode() + importsVo.getSalesOrgCode());
        }
        if (CollectionUtils.isEmpty(dimensionVoList)) {
            throw new IllegalArgumentException("没有找到对应维度配置数据！");
        }
        // 根据维度配置，判断必填字段
        dimensionVoList.forEach(informationVo -> {
            try {
                if (StringUtils.isEmpty(informationVo.getFieldCoding())) {
                    return;
                }
                Field field = clazz.getDeclaredField(informationVo.getFieldCoding());
                field.setAccessible(true);
                Object o = field.get(importsVo);
                if (ObjectUtils.isEmpty(o)) {
                    throw new IllegalArgumentException(informationVo.getFieldName() + "不能为空！");
                }
            } catch (NoSuchFieldException | IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        });
    }

    /**
     * 校验数字类型字段
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 20:44
     **/
    private void buildDecimal(YearBudgetOnLineImportsVo importsVo) {
        // 年度力度
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetIntensity())) {
                importsVo.setBudgetIntensityNumerator(new BigDecimal(importsVo.getBudgetIntensity().split("/")[0]));//分子
                importsVo.setBudgetIntensityDenominator(new BigDecimal(importsVo.getBudgetIntensity().split("/")[1]));//分母
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("年度力度" + importsVo.getBudgetIntensity() + "格式错误，请检查！");
        }
        // 预算点数
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetTotalPointStr())) {
                importsVo.setBudgetTotalPoint(new BigDecimal(importsVo.getBudgetTotalPointStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("预算总点数" + importsVo.getBudgetTotalPointStr() + "格式错误，请检查！");
        }
        // 预算总金额
        try {
            if (!StringUtils.isEmpty(importsVo.getBudgetTotalAmountStr())) {
                importsVo.setBudgetTotalAmount(new BigDecimal(importsVo.getBudgetTotalAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("预算总金额" + importsVo.getBudgetTotalAmountStr() + "格式错误，请检查！");
        }
        // 总目标量
        try {
            if (!StringUtils.isEmpty(importsVo.getTotalGoalQuantityStr())) {
                importsVo.setTotalGoalQuantity(new BigDecimal(importsVo.getTotalGoalQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("总目标量" + importsVo.getTotalGoalQuantityStr() + "格式错误，请检查！");
        }
        // 策略关联金额
        /*try {
            if (!StringUtils.isEmpty(importsVo.getStrategyAmountStr())) {
                importsVo.setStrategyAmount(new BigDecimal(importsVo.getStrategyAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("策略关联金额" + importsVo.getStrategyAmountStr() + "格式错误，请检查！");
        }
        // 剩余可关联金额
        try {
            if (!StringUtils.isEmpty(importsVo.getRemainderAmountStr())) {
                importsVo.setRemainderAmount(new BigDecimal(importsVo.getRemainderAmountStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("剩余可关联金额" + importsVo.getRemainderAmountStr() + "格式错误，请检查！");
        }*/
    }

    /**
     * 校验基础数据
     *
     * @param importsVo
     * @author huojia
     * @date 2022/11/10 20:42
     **/
    private void buildBaseData(YearBudgetOnLineImportsVo importsVo) {
        // 业态
        if (!StringUtils.isEmpty(importsVo.getBusinessFormatCode())) {
            if (!mdmBusinessFormatMap.containsKey(importsVo.getBusinessFormatCode())) {
                throw new IllegalArgumentException("业态" + importsVo.getBusinessFormatCode() + "错误，请检查！");
            } else {
                importsVo.setBusinessFormatCode(mdmBusinessFormatMap.get(importsVo.getBusinessFormatCode()));
            }
        }
        // 业务单元
        if (!StringUtils.isEmpty(importsVo.getBusinessUnitCode())) {
            if (!mdmBusinessUnitMap.containsKey(importsVo.getBusinessUnitCode())) {
                throw new IllegalArgumentException("业务单元" + importsVo.getBusinessUnitCode() + "错误，请检查！");
            } else {
                String businessUnitCode = mdmBusinessUnitMap.get(importsVo.getBusinessUnitCode());
                importsVo.setBusinessUnitCode(businessUnitCode);
            }
        }else {
            throw new IllegalArgumentException("业务单元不能为空");
        }
        // 年
        if (!StringUtils.isEmpty(importsVo.getYearLy())) {
            try {
                DateUtil.parseDate(importsVo.getYearLy(), "yyyy");
            } catch (Exception ignored) {
                throw new IllegalArgumentException("年份" + importsVo.getYearLy() + "格式错误，应该为" + "yyyy");
            }
        }else {
            throw new IllegalArgumentException("年份不能为空");
        }
        if (!StringUtils.isEmpty(importsVo.getOrgCode())) {
            if (!orgVoMap.containsKey(importsVo.getOrgCode())) {
                throw new IllegalArgumentException("部门编码" + importsVo.getOrgCode() + "错误，请检查！");
            } else {
                importsVo.setOrgName(orgVoMap.get(importsVo.getOrgCode()).getOrgName());
                importsVo.setOrgLevelCode(orgVoMap.get(importsVo.getOrgCode()).getOrgLevel());
            }
        }else {
            throw new IllegalArgumentException("部门编码不能为空");
        }
        // 分组
        if (!StringUtils.isEmpty(importsVo.getGroupCode())) {
            if (!tpmGroupCodeMap.containsKey(importsVo.getGroupCode())) {
                throw new IllegalArgumentException("分组" + importsVo.getGroupCode() + "错误，请检查！");
            } else {
                importsVo.setGroupCode(tpmGroupCodeMap.get(importsVo.getGroupCode()));
            }
        }
        else {
            throw new IllegalArgumentException("分组不能为空");
        }
        // 归口
        if (!StringUtils.isEmpty(importsVo.getFeeBelongCode())) {
            if (BusinessUnitEnum.SON_COMPANY.getCode().equals(importsVo.getBusinessUnitCode())) {
                if (!tpmFeeSourceMap.containsKey(importsVo.getFeeBelongCode())) {
                    throw new IllegalArgumentException("分子公司归口" + importsVo.getFeeBelongCode() + "错误，请检查！");
                } else {
                    importsVo.setFeeBelongCode(tpmFeeSourceMap.get(importsVo.getFeeBelongCode()));
                }
            } else {
                if (!tpmFeeBelongMap.containsKey(importsVo.getFeeBelongCode())) {
                    throw new IllegalArgumentException("归口" + importsVo.getFeeBelongCode() + "错误，请检查！");
                } else {
                    importsVo.setFeeBelongCode(tpmFeeBelongMap.get(importsVo.getFeeBelongCode()));
                }
            }
        }
        // 校验预算项目
        if (!StringUtils.isEmpty(importsVo.getBudgetItemCode())) {
            if (budgetItemVoMap.containsKey(importsVo.getBudgetItemCode())) {
                importsVo.setBudgetItemName(budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemName());
                importsVo.setBudgetItemLevelCode(budgetItemVoMap.get(importsVo.getBudgetItemCode()).getBudgetItemLevelCode());
            } else {
                throw new IllegalArgumentException("预算项目编码" + importsVo.getBudgetItemCode() + "错误，请检查！");
            }
        }
        // 销售组织
        if (!StringUtils.isEmpty(importsVo.getSalesOrgCode())) {
            if (!salesOrgVoMap.containsKey(importsVo.getSalesOrgCode())) {
                throw new IllegalArgumentException("销售组织" + importsVo.getSalesOrgCode() + "错误，请检查！");
            } else {
                importsVo.setSalesOrgName(salesOrgVoMap.get(importsVo.getSalesOrgCode()).getSalesOrgName());
                importsVo.setSalesOrgLevelCode(salesOrgVoMap.get(importsVo.getSalesOrgCode()).getSalesOrgLevel());
            }
        }
        // 客户渠道
//        if (!StringUtils.isEmpty(importsVo.getCustomerChannelCode())) {
//            if (!customerChannelVoMap.containsKey(importsVo.getCustomerChannelCode())) {
//                throw new IllegalArgumentException("客户渠道" + importsVo.getCustomerChannelCode() + "错误，请检查！");
//            } else {
//                importsVo.setCustomerChannelName(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelName());
//                importsVo.setCustomerChannelLevelCode(customerChannelVoMap.get(importsVo.getCustomerChannelCode()).getCustomerChannelType());
//            }
//        }
        // 终端渠道
//        if (!StringUtils.isEmpty(importsVo.getTerminalChannelCode())) {
//            if (!terminalChannelVoMap.containsKey(importsVo.getTerminalChannelCode())) {
//                throw new IllegalArgumentException("终端渠道" + importsVo.getTerminalChannelCode() + "错误，请检查！");
//            } else {
//                importsVo.setTerminalChannelName(terminalChannelVoMap.get(importsVo.getTerminalChannelCode()).getTerminalChannelName());
//
//            }
//        }
        // 系统、零售商
        if (!StringUtils.isEmpty(importsVo.getSystemCode())) {

        }
        // 客户
        if (!StringUtils.isEmpty(importsVo.getCustomerCode())) {
            if (customerVoMap.containsKey(importsVo.getCustomerCode())) {
                importsVo.setCustomerName(customerVoMap.get(importsVo.getCustomerCode()).getCustomerName());
            } else {
                throw new IllegalArgumentException("客户编码" + importsVo.getCustomerCode() + "错误，请检查！");
            }
        }
        // 门店
//        if (!StringUtils.isEmpty(importsVo.getTerminalCode())) {
//            if (terminalVoMap.containsKey(importsVo.getTerminalCode())) {
//                importsVo.setTerminalName(terminalVoMap.get(importsVo.getTerminalCode()).getTerminalName());
//            } else {
//                throw new IllegalArgumentException("门店编码" + importsVo.getTerminalCode() + "错误，请检查！");
//            }
//        }
        // 产品品牌
        if (!StringUtils.isEmpty(importsVo.getProductBrandCode())) {
            if (productBrandVoMap.containsKey(importsVo.getProductBrandCode())) {
                importsVo.setProductBrandName(productBrandVoMap.get(importsVo.getProductBrandCode()).getProductBrandName());
            } else {
                throw new IllegalArgumentException("产品品牌" + importsVo.getProductBrandCode() + "错误，请检查！");
            }
        }
        // 产品品类
        if (!StringUtils.isEmpty(importsVo.getProductCategoryCode())) {
            if (productCategoryVoMap.containsKey(importsVo.getProductCategoryCode())) {
                importsVo.setProductCategoryName(productCategoryVoMap.get(importsVo.getProductCategoryCode()).getProductLevelName());
            } else {
                throw new IllegalArgumentException("产品品类" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品品项
        if (!StringUtils.isEmpty(importsVo.getProductItemCode())) {
            if (productItemVoMap.containsKey(importsVo.getProductItemCode())) {
                importsVo.setProductItemName(productItemVoMap.get(importsVo.getProductItemCode()).getProductLevelName());
            } else {
                throw new IllegalArgumentException("产品品项" + importsVo.getProductCategoryCode() + "错误，请检查！");
            }
        }
        // 产品
        if (!StringUtils.isEmpty(importsVo.getProductCode())) {
            if (productVoMap.containsKey(importsVo.getProductCode())) {
                importsVo.setProductName(productVoMap.get(importsVo.getProductCode()).getProductName());
            } else {
                throw new IllegalArgumentException("产品编码" + importsVo.getProductCode() + "错误，请检查！");
            }
        }
    }

    /**
     * 构建行明细
     *
     * @param budgetData
     * @return java.util.List<com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDataDto>
     * @author huojia
     * @date 2022/11/10 20:39
     **/
    private List<YearBudgetDataDto> buildDetailData(YearBudgetOnLineImportsVo budgetData) {
        budgetData.setDataType(YearBudgetDataTypeEnum.BUDGET_AMOUNT.getCode());
        budgetData.setSortNum(dataTypeMap.get(budgetData.getDataType()));
        //数据
        List<YearBudgetDataDto> yearBudgetDataDtoList = new ArrayList<>();
        //预算点数
        YearBudgetDataDto yearBudgetPointDataDto = new YearBudgetDataDto();
        yearBudgetPointDataDto.setDataType(YearBudgetDataTypeEnum.BUDGET_POINT.getCode());
        yearBudgetPointDataDto.setSortNum(dataTypeMap.get(yearBudgetPointDataDto.getDataType()));

        //目标量
        YearBudgetDataDto salesDto = new YearBudgetDataDto();
        salesDto.setDataType(YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode());
        salesDto.setSortNum(dataTypeMap.get(YearBudgetDataTypeEnum.GOAL_QUANTITY.getCode()));
        // 校验金额

        // 一月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJanuaryNumStr())) {
                budgetData.setJanuaryNum(new BigDecimal(budgetData.getJanuaryNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("一月份预算金额" + budgetData.getJanuaryNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getJanuaryQuantityStr())) {
                salesDto.setJanuaryNum(new BigDecimal(budgetData.getJanuaryQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("一月份目标量" + budgetData.getJanuaryQuantityStr() + "格式错误，请检查！");
        }
        //每个月的预算点数=每个月的预算金额/每个月的销售目标
        yearBudgetPointDataDto.setJanuaryNum(budgetData.getJanuaryNum()
            .divide(salesDto.getJanuaryNum(),6,BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));
        // 二月份
        try {
            if (!StringUtils.isEmpty(budgetData.getFebruaryNumStr())) {
                budgetData.setFebruaryNum(new BigDecimal(budgetData.getFebruaryNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("二月份预算金额" + budgetData.getFebruaryNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getFebruaryQuantityStr())) {
                salesDto.setFebruaryNum(new BigDecimal(budgetData.getFebruaryQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("二月份目标量" + budgetData.getFebruaryQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setFebruaryNum(budgetData.getFebruaryNum()
            .divide(salesDto.getFebruaryNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 三月份
        try {
            if (!StringUtils.isEmpty(budgetData.getMarchNumStr())) {
                budgetData.setMarchNum(new BigDecimal(budgetData.getMarchNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("三月份预算金额" + budgetData.getMarchNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getMarchQuantityStr())) {
                salesDto.setMarchNum(new BigDecimal(budgetData.getMarchQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("三月份目标量" + budgetData.getMarchQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setMarchNum(budgetData.getMarchNum()
            .divide(salesDto.getMarchNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 四月份
        try {
            if (!StringUtils.isEmpty(budgetData.getAprilNumStr())) {
                budgetData.setAprilNum(new BigDecimal(budgetData.getAprilNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("四月份预算金额" + budgetData.getAprilNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getAprilQuantityStr())) {
                salesDto.setAprilNum(new BigDecimal(budgetData.getAprilQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("四月份目标量" + budgetData.getAprilQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setAprilNum(budgetData.getAprilNum()
            .divide(salesDto.getAprilNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 五月份
        try {
            if (!StringUtils.isEmpty(budgetData.getMayNumStr())) {
                budgetData.setMayNum(new BigDecimal(budgetData.getMayNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("五月份预算金额" + budgetData.getMayNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getMayQuantityStr())) {
                salesDto.setMayNum(new BigDecimal(budgetData.getMayQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("五月份目标量" + budgetData.getMayQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setMayNum(budgetData.getMayNum()
            .divide(salesDto.getMayNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 六月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJuneNumStr())) {
                budgetData.setJuneNum(new BigDecimal(budgetData.getJuneNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("六月份预算金额" + budgetData.getJuneNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getJuneQuantityStr())) {
                salesDto.setJuneNum(new BigDecimal(budgetData.getJuneQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("六月份目标量" + budgetData.getJuneQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setJuneNum(budgetData.getJuneNum()
            .divide(salesDto.getJuneNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 七月份
        try {
            if (!StringUtils.isEmpty(budgetData.getJulyNumStr())) {
                budgetData.setJulyNum(new BigDecimal(budgetData.getJulyNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("七月份预算金额" + budgetData.getJulyNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getJulyQuantityStr())) {
                salesDto.setJulyNum(new BigDecimal(budgetData.getJulyQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("七月份预算点数" + budgetData.getJulyQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setJulyNum(budgetData.getJulyNum()
            .divide(salesDto.getJulyNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 八月份
        try {
            if (!StringUtils.isEmpty(budgetData.getAugustNumStr())) {
                budgetData.setAugustNum(new BigDecimal(budgetData.getAugustNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("八月份预算金额" + budgetData.getAugustNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getAugustQuantityStr())) {
                salesDto.setAugustNum(new BigDecimal(budgetData.getAugustQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("八月份目标量" + budgetData.getAugustQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setAugustNum(budgetData.getAugustNum()
            .divide(salesDto.getAugustNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 九月份
        try {
            if (!StringUtils.isEmpty(budgetData.getSeptemberNumStr())) {
                budgetData.setSeptemberNum(new BigDecimal(budgetData.getSeptemberNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("九月份预算金额" + budgetData.getSeptemberNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getSeptemberQuantityStr())) {
                salesDto.setSeptemberNum(new BigDecimal(budgetData.getSeptemberQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("九月份目标量" + budgetData.getSeptemberQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setSeptemberNum(budgetData.getSeptemberNum()
            .divide(salesDto.getSeptemberNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 十月份
        try {
            if (!StringUtils.isEmpty(budgetData.getOctoberNumStr())) {
                budgetData.setOctoberNum(new BigDecimal(budgetData.getOctoberNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("十月份预算金额" + budgetData.getOctoberNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getOctoberQuantityStr())) {
                salesDto.setOctoberNum(new BigDecimal(budgetData.getOctoberQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("十月份目标量" + budgetData.getOctoberQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setOctoberNum(budgetData.getOctoberNum()
            .divide(salesDto.getOctoberNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 十一月份
        try {
            if (!StringUtils.isEmpty(budgetData.getNovemberNumStr())) {
                budgetData.setNovemberNum(new BigDecimal(budgetData.getNovemberNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("十一月份预算金额" + budgetData.getNovemberNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getNovemberQuantityStr())) {
                salesDto.setNovemberNum(new BigDecimal(budgetData.getNovemberQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("十一月份目标量" + budgetData.getNovemberQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setNovemberNum(budgetData.getNovemberNum()
            .divide(salesDto.getNovemberNum(), BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        // 十二月份
        try {
            if (!StringUtils.isEmpty(budgetData.getDecemberNumStr())) {
                budgetData.setDecemberNum(new BigDecimal(budgetData.getDecemberNumStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("十二月份预算金额" + budgetData.getDecemberNumStr() + "格式错误，请检查！");
        }
        try {
            if (!StringUtils.isEmpty(budgetData.getDecemberQuantityStr())) {
                salesDto.setDecemberNum(new BigDecimal(budgetData.getDecemberQuantityStr()));
            }
        } catch (Exception e) {
            throw new IllegalArgumentException("十二月份目标量" + budgetData.getDecemberQuantityStr() + "格式错误，请检查！");
        }
        yearBudgetPointDataDto.setDecemberNum(budgetData.getDecemberNum()
            .divide(salesDto.getDecemberNum(),6, BigDecimal.ROUND_HALF_UP).multiply(this.ONE_HUNDRED));

        YearBudgetDataDto yearBudgetDataDto = this.nebulaToolkitService.copyObjectByWhiteList(budgetData, YearBudgetDataDto.class, LinkedHashSet.class, ArrayList.class);
        yearBudgetDataDtoList.add(yearBudgetDataDto);
        yearBudgetDataDtoList.add(salesDto);
        yearBudgetDataDtoList.add(yearBudgetPointDataDto);
        return yearBudgetDataDtoList;
    }

    /**
     * 构建基础数据map
     *
     * @param yearBudgetImportsVos
     * @author huojia
     * @date 2022/11/10 20:31
     **/
    private void buildBaseMap(List<YearBudgetOnLineImportsVo> yearBudgetImportsVos) {
        // 查询数据字典
        mdmBusinessFormatMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_FORMAT);
        mdmBusinessUnitMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.MDM_BUSINESS_UNIT);
        tpmGroupCodeMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_GROUP_CODE);
        tpmFeeBelongMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_FEE_BELONG_US);
        tpmFeeSourceMap = dictToolkitService.findConvertMapByDictTypeCode(DictTypeCodeConstant.TPM_FEE_SOURCE);

        // 枚举类型map
        dataTypeMap = YearBudgetDataTypeEnum.concertEnumToMap();
        // 查询主数据数据，校验
        Set<String> orgCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> yearBudgetSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getYearBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> budgetItemSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> salesOrgCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getSalesOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> customerChannelCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getCustomerChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> terminalChannelCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getTerminalChannelCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> systemCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getSystemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> customerCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
//        Set<String> terminalCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productBrandCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getProductBrandCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCategoryCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getProductCategoryCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productItemCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getProductItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> productCodeSet = yearBudgetImportsVos.stream().map(YearBudgetOnLineImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());

        // 获取年度预算
        if (!CollectionUtils.isEmpty(yearBudgetSet)) {
            List<YearBudgetVo> yearBudgetVoList = yearBudgetService.listByCodes(new ArrayList<>(yearBudgetSet));
            if (!CollectionUtils.isEmpty(yearBudgetVoList)) {
                yearBudgetVoMap = yearBudgetVoList.stream().collect(Collectors.toMap(YearBudgetVo::getYearBudgetCode, Function.identity()));
            }
        }

        // 校验组织
        if (!CollectionUtils.isEmpty(orgCodeSet)) {
            List<OrgVo> orgVoList = orgVoService.findByOrgCodes(new ArrayList<>(orgCodeSet));
            if (!CollectionUtils.isEmpty(orgVoList)) {
                orgVoMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, Function.identity()));
            }
        }

        // 预算项目
        if (!CollectionUtils.isEmpty(budgetItemSet)) {
            List<BudgetItemVo> budgetItemVoList = budgetItemService.listByCodes(new ArrayList<>(budgetItemSet));
            if (!CollectionUtils.isEmpty(budgetItemVoList)) {
                budgetItemVoMap = budgetItemVoList.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            }
        }

        // 销售组织
        if (!CollectionUtils.isEmpty(salesOrgCodeSet)) {
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findBySalesOrgCodes(new ArrayList<>(salesOrgCodeSet));
            if (!CollectionUtils.isEmpty(salesOrgVos)) {
                salesOrgVoMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
            }
        }

        // 客户渠道
//        if (!CollectionUtils.isEmpty(customerChannelCodeSet)) {
//            List<CustomerChannelVo> customerChannelVos = customerChannelVoService.findByCodes(new ArrayList<>(customerChannelCodeSet));
//            if (!CollectionUtils.isEmpty(customerChannelVos)) {
//                customerChannelVoMap = customerChannelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
//            }
//        }

        // 终端渠道
//        if (!CollectionUtils.isEmpty(terminalChannelCodeSet)) {
//            List<MdmTerminalChannelVo> mdmTerminalChannelVos = mdmTerminalChannelVoService.listByCodes(new ArrayList<>(terminalChannelCodeSet));
//            if (!CollectionUtils.isEmpty(mdmTerminalChannelVos)) {
//                terminalChannelVoMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, Function.identity()));
//            }
//        }

        // 客户
        if (!CollectionUtils.isEmpty(customerCodeSet)) {
            List<CustomerVo> customerVos = customerVoService.findByCustomerCodes(new ArrayList<>(customerCodeSet));
            if (!CollectionUtils.isEmpty(customerVos)) {
                customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
            }
        }

        // 终端
//        if (!CollectionUtils.isEmpty(terminalCodeSet)) {
//            List<TerminalVo> terminalVos = terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList<>(terminalCodeSet));
//            if (!CollectionUtils.isEmpty(terminalVos)) {
//                terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
//            }
//        }

        // 品牌
        if (!CollectionUtils.isEmpty(productBrandCodeSet)) {
            List<ProductBrandVo> productBrandVos = productBrandService.listByCodes(new ArrayList<>(productBrandCodeSet));
            if (!CollectionUtils.isEmpty(productBrandVos)) {
                productBrandVoMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, Function.identity(), (v1, v2) -> v1));
            }
        }

        // 品类
        if (!CollectionUtils.isEmpty(productCategoryCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productCategoryCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productCategoryVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity(), (v1, v2) -> v1));
            }
        }

        // 品项
        if (!CollectionUtils.isEmpty(productItemCodeSet)) {
            List<ProductLevelVo> productLevelVos = productLevelVoSdkService.findListByCodes(new ArrayList<>(productItemCodeSet));
            if (!CollectionUtils.isEmpty(productLevelVos)) {
                productItemVoMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, Function.identity(), (v1, v2) -> v1));
            }
        }

        // 产品
        if (!CollectionUtils.isEmpty(productCodeSet)) {
            List<ProductVo> productVoList = productVoService.findByCodes(new ArrayList<>(productCodeSet));
            if (!CollectionUtils.isEmpty(productVoList)) {
                productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            }
        }
    }

    @Override
    public Class<YearBudgetOnLineImportsVo> findCrmExcelVoClass() {
        return YearBudgetOnLineImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_YEAR_BUDGET_ONLINE_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM-年度预算电商导入";
    }

    @Override
    public String getBusinessCode() {
        return "TPM_YEAR_BUDGET_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "TPM-年度预算导入";
    }
}
