package com.biz.crm.wechatpay.v3.model;

import com.google.gson.annotations.SerializedName;

/**
 * 转账明细单列表
 */
public class TransferDetailCompact {
    /**
     * 微信明细单号 必填
     * 说明：微信支付系统内部区分转账批次单下不同转账明细单的唯一标识
     */
    @SerializedName("detail_id")
    private String detailId;

    /**
     * 商家明细单号 必填
     * 说明：商户系统内部区分转账批次单下不同转账明细单的唯一标识
     */
    @SerializedName("out_detail_no")
    private String outDetailNo;

    /**
     * 明细状态 必填
     * 说明：INIT: 初始态。 系统转账校验中
     * WAIT_PAY: 待确认。待商户确认, 符合免密条件时, 系统会自动扭转为转账中
     * PROCESSING:转账中。正在处理中，转账结果尚未明确
     * SUCCESS:转账成功
     * FAIL:转账失败。需要确认失败原因后，再决定是否重新发起对该笔明细单的转账（并非整个转账批次单）
     */
    @SerializedName("detail_status")
    private String detailStatus;

    public String getDetailId() {
        return detailId;
    }

    public void setDetailId(String detailId) {
        this.detailId = detailId;
    }

    public String getOutDetailNo() {
        return outDetailNo;
    }

    public void setOutDetailNo(String outDetailNo) {
        this.outDetailNo = outDetailNo;
    }

    public String getDetailStatus() {
        return detailStatus;
    }

    public void setDetailStatus(String detailStatus) {
        this.detailStatus = detailStatus;
    }

}
