package com.biz.crm.wechatpay.v3plus.model;

import com.google.gson.annotations.SerializedName;

import java.util.List;
import java.util.Objects;

/**
 * 商家零钱转账自定义请求体(发起转账时的请求对象)
 */
public class InitiateBillsTransferRequest {
    /**
     * 商户appid 必填
     * 说明：是微信开放平台和微信公众平台为开发者的应用程序(APP、小程序、公众号、企业号corpid即为此AppID)提供的一个唯一标识。此处，可以填写这四种类型中的任意一种APPID，但请确保该appid与商户号有绑定关系
     */
    @SerializedName("appid")
    private String appid;

    /**
     * 商户单号 必填
     * 说明：商户系统内部的商家单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     */
    @SerializedName("out_bill_no")
    private String outBillNo;

    /**
     * 转账场景  必填
     * 说明：该笔转账使用的转账场景，可前往“商户平台-产品中心-商家转账”中申请。如：1000（现金营销），1006（企业报销）等
     */
    @SerializedName("transfer_scene_id")
    private String transferSceneId;

    /**
     * 收款用户OpenID 必填
     * 说明：商户AppID下，某用户的OpenID
     */
    @SerializedName("openid")
    private String openid;

    /**
     * 收款用户姓名 选填
     * 说明：收款方真实姓名。需要加密传入，支持标准RSA算法和国密算法，公钥由微信侧提供。
     * 转账金额 >= 2,000元时，该笔明细必须填写
     * 若商户传入收款用户姓名，微信支付会校验收款用户与输入姓名是否一致，并提供电子回单
     */
    @SerializedName("user_name")
    private String userName;

    /**
     * 转账金额 必填
     * 说明：转账金额单位为“分”。
     */
    @SerializedName("transfer_amount")
    private Integer transferAmount;

    /**
     * 转账备注 必填
     * 说明：转账备注，用户收款时可见该备注信息，UTF8编码，最多允许32个字符。
     */
    @SerializedName("transfer_remark")
    private String transferRemark;

    /**
     * 通知地址 选填
     * 说明：异步接收微信支付结果通知的回调地址，通知url必须为公网可访问的url，必须为https，不能携带参数。
     */
    @SerializedName("notify_url")
    private String notifyUrl;

    /**
     * 用户收款感知  选填
     * 说明：用户收款时感知到的收款原因将根据转账场景自动展示默认内容。如有其他展示需求，可在本字段传入。
     */
    @SerializedName("user_recv_perception")
    private String userRecvPerception;

    /**
     * 转账场景报备信息 必填
     * 说明：各转账场景下需报备的内容，商户需要按照所属转账场景规则传参
     */
    @SerializedName("transfer_scene_report_infos")
    private List<TransferSceneReportInfo> transferSceneReportInfos;

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getOutBillNo() {
        return outBillNo;
    }

    public void setOutBillNo(String outBillNo) {
        this.outBillNo = outBillNo;
    }

    public String getTransferSceneId() {
        return transferSceneId;
    }

    public void setTransferSceneId(String transferSceneId) {
        this.transferSceneId = transferSceneId;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Integer getTransferAmount() {
        return transferAmount;
    }

    public void setTransferAmount(Integer transferAmount) {
        this.transferAmount = transferAmount;
    }

    public String getTransferRemark() {
        return transferRemark;
    }

    public void setTransferRemark(String transferRemark) {
        this.transferRemark = transferRemark;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public String getUserRecvPerception() {
        return userRecvPerception;
    }

    public void setUserRecvPerception(String userRecvPerception) {
        this.userRecvPerception = userRecvPerception;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public List<TransferSceneReportInfo> getTransferSceneReportInfos() {
        return transferSceneReportInfos;
    }

    public void setTransferSceneReportInfos(List<TransferSceneReportInfo> transferSceneReportInfos) {
        this.transferSceneReportInfos = transferSceneReportInfos;
    }

    public InitiateBillsTransferRequest() {
        super();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        InitiateBillsTransferRequest that = (InitiateBillsTransferRequest) o;
        return Objects.equals(appid, that.appid) && Objects.equals(outBillNo, that.outBillNo) && Objects.equals(transferSceneId, that.transferSceneId) && Objects.equals(openid, that.openid) && Objects.equals(userName, that.userName) && Objects.equals(transferAmount, that.transferAmount) && Objects.equals(transferRemark, that.transferRemark) && Objects.equals(notifyUrl, that.notifyUrl) && Objects.equals(transferSceneReportInfos, that.transferSceneReportInfos);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, outBillNo, transferSceneId, openid, userName, transferAmount, transferRemark, notifyUrl, transferSceneReportInfos);
    }
}

