package com.biz.crm.wechatpay.v3plus.model;

import com.google.gson.annotations.SerializedName;

import java.util.Objects;

/**
 * 转账场景报备信息实体类
 */
public class TransferSceneReportInfo {

    /**
     * 信息类型 必填
     * 说明：不能超过15个字符，商户所属转账场景下的信息类型，此字段内容为固定值
     * 如：转账场景为1000-现金营销，需填入活动名称、奖励说明
     */
    @SerializedName("info_type")
    private String infoType;

    /**
     * 信息内容 必填
     * 说明： 不能超过32个字符，商户所属转账场景下的信息内容，商户可按实际业务场景自定义传参
     * 如：信息类型为活动名称，请在信息内容描述用户参与活动的名称，如新会员有礼
     * 信息类型为奖励说明，请在信息内容描述用户因为什么奖励获取这笔资金，如注册会员抽奖一等奖
     */
    @SerializedName("info_content")
    private String infoContent;

    public TransferSceneReportInfo(String infoType, String infoContent) {
        this.infoType = infoType;
        this.infoContent = infoContent;
    }

    public TransferSceneReportInfo() {
    }

    public String getInfoType() {
        return infoType;
    }

    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    public String getInfoContent() {
        return infoContent;
    }

    public void setInfoContent(String infoContent) {
        this.infoContent = infoContent;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        TransferSceneReportInfo that = (TransferSceneReportInfo) o;
        return Objects.equals(infoType, that.infoType) && Objects.equals(infoContent, that.infoContent);
    }

    @Override
    public int hashCode() {
        return Objects.hash(infoType, infoContent);
    }
}

